/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.xml.model.diff.utils;

import com.vertabelo.xml.model.diff.Properties;
import com.vertabelo.xml.model.diff.Property;
import com.vertabelo.xml.model.diff.VersionableBoolean;
import com.vertabelo.xml.model.diff.VersionableElementWithIdREF;
import com.vertabelo.xml.model.diff.VersionableString;
import com.vertabelo.xml.model.diff.utils.Version;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Utils {
    private static final String FIELD_NOT_CONTAIN_VERSION_EXCEPTION_MESSAGE = "Field does not contain version ";

    public static Integer getDifferenceIdFromBoolean(List<VersionableBoolean> input) {
        if (input == null) {
            return null;
        }
        BigInteger diffId = input.getFirst().getDifferenceId();
        return diffId != null ? Integer.valueOf(diffId.intValue()) : null;
    }

    public static Integer getDifferenceIdFromString(List<VersionableString> input) {
        if (input == null) {
            return null;
        }
        BigInteger diffId = input.getFirst().getDifferenceId();
        return diffId != null ? Integer.valueOf(diffId.intValue()) : null;
    }

    public static Property getProperty(String name, Properties props) {
        for (Property prop : props.getProperty()) {
            for (VersionableString propName : prop.getName()) {
                if (!propName.getValue().equals(name)) continue;
                return prop;
            }
        }
        return null;
    }

    public static String getPropertyValue(String name, Version version, Properties props) {
        for (Property prop : props.getProperty()) {
            if (!Utils.getValueA(prop.getName(), version).equals(name)) continue;
            return Utils.getValueA(prop.getValue(), version);
        }
        return "";
    }

    public static List<VersionableString> getPropertyValues(String name, Properties props) {
        for (Property prop : props.getProperty()) {
            for (VersionableString propName : prop.getName()) {
                if (!propName.getValue().equals(name)) continue;
                return prop.getValue();
            }
        }
        return new LinkedList<VersionableString>();
    }

    public static <R> R getReferenced(List<VersionableElementWithIdREF> inputs, Version version) {
        for (VersionableElementWithIdREF ref : inputs) {
            if (ref.getDifferenceVersion() != null && !ref.getDifferenceVersion().equals(version.toString())) continue;
            return (R)ref.getValue();
        }
        return null;
    }

    public static String getValue(List<VersionableString> inputs, Version version) {
        return Utils.getValue(inputs, version, true, true);
    }

    public static String nullToEmpty(String string) {
        return string == null ? "" : string;
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static String getValue(List<VersionableString> inputs, Version version, boolean extended, boolean shouldExist) {
        for (VersionableString value : inputs) {
            String curVersion = value.getDifferenceVersion();
            if (!version.toString().equals(curVersion) && (!extended || !Utils.isNullOrEmpty(curVersion))) continue;
            return value.getValue();
        }
        if (shouldExist) {
            throw new IllegalArgumentException(FIELD_NOT_CONTAIN_VERSION_EXCEPTION_MESSAGE + version.toString());
        }
        return "";
    }

    public static String getValueA(List<VersionableString> inputs, Version version) {
        return Utils.getValueA(inputs, version, true, true);
    }

    public static String getValueA(List<VersionableString> inputs, Version version, boolean extended, boolean shouldExist) {
        for (VersionableString value : inputs) {
            String curVersion = Utils.nullToEmpty(value.getDifferenceVersion());
            if (!version.toString().equals(curVersion) && (!extended || !curVersion.isEmpty())) continue;
            return value.getValue();
        }
        if (shouldExist) {
            throw new IllegalArgumentException(FIELD_NOT_CONTAIN_VERSION_EXCEPTION_MESSAGE + version.toString());
        }
        return "";
    }

    public static String getValue(Property property, Version version) {
        List<VersionableString> inputs = property.getValue();
        if (property.getDifferenceVersion().equals(version.toString())) {
            return inputs.getFirst().getValue();
        }
        for (VersionableString value : inputs) {
            String curVersion = Utils.nullToEmpty(value.getDifferenceVersion());
            if (!version.toString().equals(curVersion)) continue;
            return value.getValue();
        }
        throw new IllegalArgumentException(FIELD_NOT_CONTAIN_VERSION_EXCEPTION_MESSAGE + version.toString());
    }

    public static boolean isPropertyValue(String name, Version version, Properties props) {
        return Utils.getPropertyValue(name, version, props).equals("true");
    }

    public static boolean isValue(List<VersionableBoolean> inputs, Version version) {
        for (VersionableBoolean value : inputs) {
            String curVersion = Utils.nullToEmpty(value.getDifferenceVersion());
            if (!version.toString().equals(curVersion) && !curVersion.isEmpty()) continue;
            return value.isValue();
        }
        throw new IllegalArgumentException(FIELD_NOT_CONTAIN_VERSION_EXCEPTION_MESSAGE + version.toString());
    }

    public static Map<String, String> mapProperties(Properties props, Version version) {
        HashMap<String, String> model = new HashMap<String, String>();
        for (Property p : props.getProperty()) {
            if ("A".equals(p.getDifferenceVersion())) continue;
            String propertyName = Utils.getValue(p.getName(), version);
            String value = Utils.getValue(p.getValue(), version);
            model.put(propertyName, value);
        }
        return model;
    }
}

