/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.xml.model.elements;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlEnum;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Field;

public class EnumsGenerator {
    private static final String JAXB_PATH = "build/generated-sources/jaxb/com/vertabelo/xml/model/";
    private static final String JAXB_PACKAGE = "com.vertabelo.xml.model";
    private static final String OUTPUT_PATH = "build/generated-sources/elements/com/vertabelo/xml/model/elements/";
    private static final String OUTPUT_PACKAGE = "com.vertabelo.xml.model.elements";

    public static void main(String[] args) throws Exception {
        new File(OUTPUT_PATH).mkdirs();
        new EnumsGenerator();
    }

    public EnumsGenerator() throws Exception {
        File dir = new File(JAXB_PATH);
        for (File f : dir.listFiles()) {
            if (f.isDirectory() || !f.getName().endsWith(".java") || f.getName().equals("ObjectFactory.java")) continue;
            String className = f.getName().substring(0, f.getName().lastIndexOf(46));
            this.analyzeClass(Class.forName("com.vertabelo.xml.model." + className));
        }
    }

    private void analyzeClass(Class<?> elem) throws Exception {
        if (elem.isAnnotationPresent(XmlEnum.class)) {
            return;
        }
        PrintWriter writer = new PrintWriter(OUTPUT_PATH + elem.getSimpleName() + ".java", "UTF-8");
        writer.print("package com.vertabelo.xml.model.elements;\n\npublic enum " + elem.getSimpleName() + " implements Tag {\n\n");
        Field[] fields = elem.getDeclaredFields();
        Object buffer = "";
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            String name = "";
            if (f.isAnnotationPresent(XmlElement.class)) {
                name = f.getAnnotation(XmlElement.class).name();
            } else if (f.isAnnotationPresent(XmlElementRef.class)) {
                name = f.getAnnotation(XmlElementRef.class).name();
            }
            if (name.isEmpty()) continue;
            if (!((String)buffer).isEmpty()) {
                writer.println((String)buffer + ",");
            }
            buffer = "    " + this.convertCamelCaseToConstant(name) + "(\"" + name + "\")";
        }
        if (!((String)buffer).isEmpty()) {
            writer.println((String)buffer + ";");
        }
        writer.println();
        writer.print("    private final String text;\n\n    private " + elem.getSimpleName() + "(final String text) {\n        this.text = text;\n    }\n\n    @Override\n    public String toString() {\n         return text;\n    }\n}\n");
        writer.close();
    }

    private String convertCamelCaseToConstant(String in) {
        Object res = "";
        String[] split = in.split("(?<=[a-z])(?=[A-Z])");
        for (int i = 0; i < split.length; ++i) {
            res = (String)res + split[i].toUpperCase();
            if (i + 1 >= split.length) continue;
            res = (String)res + "_";
        }
        return res;
    }
}

