/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.xml.model_import;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtils {
    public static String removeInvalidCharacters(String xml) {
        return xml.replaceAll("[\\x00-\\x09\\x11\\x12\\x14-\\x1F\\x7F]", " ");
    }

    public static XMLStreamReader getXMLReaderForXML(String xml) throws XMLStreamException {
        XMLInputFactory xif = XMLInputFactory.newInstance();
        xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        xif.setProperty("javax.xml.stream.supportDTD", false);
        XMLStreamReader xsr = xif.createXMLStreamReader(new StringReader(xml));
        return xsr;
    }

    public static String JAXBserialize(Class rootClass, Object object) {
        try {
            StringWriter os;
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{rootClass});
            Marshaller m = jc.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
            try (StringWriter stringWriter = os = new StringWriter();){
                m.marshal(object, (Writer)os);
            }
            String xml = os.toString();
            xml = XmlUtils.removeInvalidCharacters(xml);
            return xml;
        }
        catch (JAXBException e) {
            throw new IllegalStateException(e);
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String marshall(Document doc) {
        try {
            DOMSource domSource = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(domSource, result);
            writer.flush();
            String resultXml = writer.toString();
            return resultXml;
        }
        catch (TransformerException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Document unmarshal(String xml) {
        try {
            return XmlUtils.parseXML(xml);
        }
        catch (SAXException e) {
            throw new IllegalStateException(e);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Document parseXML(String xml) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(xml));
        Document doc = dBuilder.parse(is);
        return doc;
    }

    public static boolean isValidXML(String xml) {
        try {
            XmlUtils.parseXML(xml);
            return true;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            return false;
        }
    }
}

