/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.xml.model_import.display;

import com.vertabelo.xml.model.ExternalTable;
import com.vertabelo.xml.model.ExternalTableDisplayInfo;
import com.vertabelo.xml.model.Point;
import com.vertabelo.xml.model.Table;
import com.vertabelo.xml.model.TableDisplayInfo;
import com.vertabelo.xml.model.View;
import com.vertabelo.xml.model.ViewDisplayInfo;
import com.vertabelo.xml.model_import.display.graph.Edge;
import com.vertabelo.xml.model_import.display.graph.Graph;
import com.vertabelo.xml.model_import.display.graph.Node;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;

public class GraphDrawer {
    public static final String fileName = "/tmp/graph";
    private String suffix = "1000";

    public GraphDrawer(String suffix) {
        this.suffix = suffix;
    }

    public void drawGraph(Graph graph) {
        try {
            BufferedImage bi = this.getImage(graph);
            File outputfile = new File(fileName + this.suffix + ".png");
            ImageIO.write((RenderedImage)bi, "png", outputfile);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private BufferedImage getImage(Graph graph) {
        BufferedImage image = new BufferedImage(2000, 2000, 1);
        Graphics2D g = image.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, 2000, 2000);
        Font font = g.getFont();
        font = font.deriveFont(font.getSize() * 10);
        g.setFont(font);
        Iterator<Object> it = graph.edgesIterator();
        while (it.hasNext()) {
            Edge edge = it.next();
            this.drawEdge(g, edge);
        }
        it = graph.nodesIterator();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            this.drawNode(g, node);
        }
        return image;
    }

    private void drawNode(Graphics2D g, Node node) {
        ViewDisplayInfo view;
        ExternalTableDisplayInfo externalTable;
        int x = (int)Math.round(node.getXMin());
        int y = (int)Math.round(node.getYMin());
        int width = (int)Math.round(node.getWidth());
        int height = (int)Math.round(node.getHeight());
        g.setColor(Color.WHITE);
        g.fillRect(x, y, width, height);
        g.setColor(Color.BLACK);
        g.drawRect(x, y, width, height);
        g.drawRect(x + 1, y + 1, width, height);
        g.drawRect(x + 2, y + 2, width, height);
        int middleX = (int)Math.round(node.getMiddleX());
        int middleY = (int)Math.round(node.getMiddleY());
        String label = "";
        TableDisplayInfo table = node.getTableDisplayInfo();
        if (table != null) {
            label = ((Table)table.getTable()).getName();
        }
        if ((externalTable = node.getExternalTableDisplayInfo()) != null) {
            label = ((ExternalTable)externalTable.getExternalTable()).getName();
        }
        if ((view = node.getViewDisplayInfo()) != null) {
            label = ((View)view.getView()).getName();
        }
        g.drawString(label, middleX, middleY);
        g.drawRect(middleX, middleY, 1, 1);
    }

    private void drawEdge(Graphics2D g, Edge edge) {
        List<Point> points = edge.getReferenceDisplayInfo().getControlPoints().getControlPoint();
        for (int i = 0; i < points.size() - 1; ++i) {
            g.setColor(Color.BLACK);
            Point2D.Double p1 = new Point2D.Double(points.get(i).getX(), points.get(i).getY());
            Point2D.Double p2 = new Point2D.Double(points.get(i + 1).getX(), points.get(i + 1).getY());
            g.draw(new Line2D.Double(p1, p2));
        }
    }
}

