/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.xml.model_import.display;

import com.vertabelo.xml.model.Column;
import com.vertabelo.xml.model.ControlPointsType;
import com.vertabelo.xml.model.DatabaseModel;
import com.vertabelo.xml.model.ExternalTable;
import com.vertabelo.xml.model.ExternalTableColumn;
import com.vertabelo.xml.model.ExternalTableDisplayInfo;
import com.vertabelo.xml.model.MaterializedView;
import com.vertabelo.xml.model.MaterializedViewDisplayInfo;
import com.vertabelo.xml.model.Point;
import com.vertabelo.xml.model.ReferenceDisplayInfo;
import com.vertabelo.xml.model.Table;
import com.vertabelo.xml.model.TableDisplayInfo;
import com.vertabelo.xml.model.View;
import com.vertabelo.xml.model.ViewColumn;
import com.vertabelo.xml.model.ViewDisplayInfo;
import com.vertabelo.xml.model_import.display.GraphDrawingAlgorithm;
import com.vertabelo.xml.model_import.display.graph.Edge;
import com.vertabelo.xml.model_import.display.graph.Graph;
import com.vertabelo.xml.model_import.display.graph.Node;
import jakarta.xml.bind.JAXBElement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class XmlDrawer {
    public static final int MIN_TABLE_WIDTH = 104;
    public static final int HEADER_HEIGHT = 25;
    public static final int COLUMN_HEIGHT = 16;
    public static final int LETTER_WIDTH = 8;
    private GraphDrawingAlgorithm algorithm;

    public XmlDrawer(GraphDrawingAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    public void drawModel(DatabaseModel databaseModel) {
        Graph graph = this.convertToGraph(databaseModel);
        int diagramSize = this.getDiagramSize(graph);
        this.algorithm.run(graph, diagramSize, diagramSize);
        this.copyCoordinatesToModel(graph);
    }

    private int getDiagramSize(Graph graph) {
        int nodesSize = graph.getNodes().size();
        if (nodesSize <= 20) {
            return 1500;
        }
        if (nodesSize <= 80) {
            return 3000;
        }
        if (nodesSize <= 200) {
            return 5000;
        }
        return 10000;
    }

    private void computeTableSize(DatabaseModel databaseModel) {
        List<TableDisplayInfo> tableDisplayList = databaseModel.getTableDisplays().getTableDisplay();
        for (TableDisplayInfo tableDisplayInfo : tableDisplayList) {
            Table table = (Table)tableDisplayInfo.getTable();
            this.computeTableSize(tableDisplayInfo, table);
        }
        List<ExternalTableDisplayInfo> externalTableDisplayList = databaseModel.getExternalTableDisplays().getExternalTableDisplay();
        for (ExternalTableDisplayInfo externalTableDisplayInfo : externalTableDisplayList) {
            ExternalTable et = (ExternalTable)externalTableDisplayInfo.getExternalTable();
            this.computeExternalTableSize(externalTableDisplayInfo, et);
        }
        List<ViewDisplayInfo> list = databaseModel.getViewDisplays().getViewDisplay();
        for (ViewDisplayInfo viewDisplay : list) {
            View view = (View)viewDisplay.getView();
            this.computeViewSize(viewDisplay, view);
        }
        for (MaterializedViewDisplayInfo display : databaseModel.getMaterializedViewDisplays().getMaterializedViewDisplay()) {
            this.setDisplayWidthAndHeight(display, (MaterializedView)display.getMaterializedView());
        }
        List<ReferenceDisplayInfo> list2 = databaseModel.getReferenceDisplays().getReferenceDisplay();
        for (ReferenceDisplayInfo referenceDisplay : list2) {
            this.computeReferenceDisplay(referenceDisplay);
        }
    }

    private void setDisplayWidthAndHeight(MaterializedViewDisplayInfo display, MaterializedView materializedView) {
        int maxColumnWidth = materializedView.getMaterializedViewColumns().getMaterializedViewColumn().stream().map(column -> {
            String approximateLabel = column.getName() + " " + column.getType();
            return approximateLabel.length() * 8;
        }).max(Integer::compare).orElse(104);
        int columnsAmount = materializedView.getMaterializedViewColumns().getMaterializedViewColumn().size();
        int viewNameWidth = materializedView.getName().length() * 8;
        display.setWidth(Math.max(maxColumnWidth, viewNameWidth));
        display.setHeight((double)columnsAmount * 16.0 + 25.0 + 25.0);
    }

    private void computeViewSize(ViewDisplayInfo viewDisplay, View view) {
        int columnCount = view.getViewColumns().getViewColumn().size();
        viewDisplay.setHeight((double)columnCount * 16.0 + 25.0 + 25.0);
        int width = 104;
        List<ViewColumn> columns = view.getViewColumns().getViewColumn();
        for (ViewColumn column : columns) {
            String name = column.getName();
            String type = column.getType();
            String approximateLabel = name + " " + type;
            int letterWidth = approximateLabel.length() * 8;
            width = Math.max(width, letterWidth);
        }
        String viewName = view.getName();
        int tableNameLetterWidth = viewName.length() * 8;
        width = Math.max(width, tableNameLetterWidth);
        viewDisplay.setWidth(width);
    }

    private void computeReferenceDisplay(ReferenceDisplayInfo referenceDisplay) {
        TableDisplayInfo fkTableDisplay = (TableDisplayInfo)referenceDisplay.getFkTableDisplay();
        double fkXMiddle = fkTableDisplay.getX() + fkTableDisplay.getWidth() / 2.0;
        double fkYMiddle = fkTableDisplay.getY() + fkTableDisplay.getHeight() / 2.0;
        TableDisplayInfo pkTable = (TableDisplayInfo)referenceDisplay.getPkTableDisplay();
        double pkXMiddle = pkTable.getX() + pkTable.getWidth() / 2.0;
        double pkYMiddle = pkTable.getY() + pkTable.getHeight() / 2.0;
        referenceDisplay.setType(ControlPointsType.CROSS_3_CP);
        referenceDisplay.getControlPoints().getControlPoint().clear();
        Point point3 = new Point();
        point3.setX(pkXMiddle);
        point3.setY(pkYMiddle);
        referenceDisplay.getControlPoints().getControlPoint().add(point3);
        Point point2 = new Point();
        point2.setX(pkXMiddle);
        point2.setY(fkYMiddle);
        referenceDisplay.getControlPoints().getControlPoint().add(point2);
        Point point = new Point();
        point.setX(fkXMiddle);
        point.setY(fkYMiddle);
        referenceDisplay.getControlPoints().getControlPoint().add(point);
    }

    private void computeTableSize(TableDisplayInfo tableDisplay, Table table) {
        int columnCount = table.getColumns().getColumn().size();
        tableDisplay.setHeight((double)columnCount * 16.0 + 25.0);
        HashSet<Object> pkColumns = new HashSet<Object>();
        if (table.getPrimaryKey() != null) {
            for (JAXBElement<Object> o : table.getPrimaryKey().getColumns().getColumn()) {
                Column c = (Column)o.getValue();
                pkColumns.add(c);
            }
        }
        int width = 104;
        List<Column> columns = table.getColumns().getColumn();
        for (Column column : columns) {
            String name = column.getName();
            String type = column.getType();
            String approximateLabel = name + " " + type;
            if (pkColumns.contains(column)) {
                approximateLabel = approximateLabel + " PK";
            }
            int letterWidth = approximateLabel.length() * 8;
            width = Math.max(width, letterWidth);
        }
        String tableName = table.getName();
        int tableNameLetterWidth = tableName.length() * 8;
        width = Math.max(width, tableNameLetterWidth);
        tableDisplay.setWidth(width);
    }

    private void computeExternalTableSize(ExternalTableDisplayInfo externalTableDisplay, ExternalTable externalTable) {
        int columnCount = externalTable.getColumns().getExternalTableColumn().size();
        externalTableDisplay.setHeight((double)columnCount * 16.0 + 25.0);
        HashSet<Object> pkColumns = new HashSet<Object>();
        if (externalTable.getPrimaryKey() != null) {
            for (JAXBElement<Object> o : externalTable.getPrimaryKey().getColumns().getColumn()) {
                ExternalTableColumn c = (ExternalTableColumn)o.getValue();
                pkColumns.add(c);
            }
        }
        int width = 104;
        List<ExternalTableColumn> columns = externalTable.getColumns().getExternalTableColumn();
        for (ExternalTableColumn column : columns) {
            String name = column.getName();
            String type = column.getType();
            String approximateLabel = name + " " + type;
            if (pkColumns.contains(column)) {
                approximateLabel = approximateLabel + " PK";
            }
            int letterWidth = approximateLabel.length() * 8;
            width = Math.max(width, letterWidth);
        }
        String tableName = externalTable.getName();
        int tableNameLetterWidth = tableName.length() * 8;
        width = Math.max(width, tableNameLetterWidth);
        externalTableDisplay.setWidth(width);
    }

    private Graph convertToGraph(DatabaseModel databaseModel) {
        this.computeTableSize(databaseModel);
        Graph graph = new Graph();
        HashMap<TableDisplayInfo, Node> tableDisplayToNode = new HashMap<TableDisplayInfo, Node>();
        List<TableDisplayInfo> tableList = databaseModel.getTableDisplays().getTableDisplay();
        for (TableDisplayInfo tableDisplayInfo : tableList) {
            double x = tableDisplayInfo.getX();
            double y = tableDisplayInfo.getY();
            double height = tableDisplayInfo.getHeight();
            double width = tableDisplayInfo.getWidth();
            Node node = new Node(x, y, width, height, tableDisplayInfo);
            graph.addNode(node);
            tableDisplayToNode.put(tableDisplayInfo, node);
        }
        List<ReferenceDisplayInfo> referenceList = databaseModel.getReferenceDisplays().getReferenceDisplay();
        for (ReferenceDisplayInfo reference : referenceList) {
            TableDisplayInfo pkTableDisplayInfo = (TableDisplayInfo)reference.getPkTableDisplay();
            Node pkTableNode = (Node)tableDisplayToNode.get(pkTableDisplayInfo);
            TableDisplayInfo fkTableDisplayInfo = (TableDisplayInfo)reference.getFkTableDisplay();
            Node fkTableNode = (Node)tableDisplayToNode.get(fkTableDisplayInfo);
            Edge edge = new Edge(pkTableNode, fkTableNode, reference);
            graph.addEdge(edge);
        }
        List<ViewDisplayInfo> list = databaseModel.getViewDisplays().getViewDisplay();
        for (ViewDisplayInfo displayInfo : list) {
            double x = displayInfo.getX();
            double y = displayInfo.getY();
            double height = displayInfo.getHeight();
            double width = displayInfo.getWidth();
            Node node = new Node(x, y, width, height, displayInfo);
            graph.addNode(node);
        }
        List<ExternalTableDisplayInfo> externalTableList = databaseModel.getExternalTableDisplays().getExternalTableDisplay();
        for (ExternalTableDisplayInfo displayInfo : externalTableList) {
            double x = displayInfo.getX();
            double y = displayInfo.getY();
            double height = displayInfo.getHeight();
            double width = displayInfo.getWidth();
            Node node = new Node(x, y, width, height, displayInfo);
            graph.addNode(node);
        }
        for (MaterializedViewDisplayInfo display : databaseModel.getMaterializedViewDisplays().getMaterializedViewDisplay()) {
            graph.addNode(new Node(display.getX(), display.getY(), display.getWidth(), display.getHeight(), display));
        }
        return graph;
    }

    private void copyCoordinatesToModel(Graph graph) {
        Iterator<Node> nodesIterator = graph.nodesIterator();
        while (nodesIterator.hasNext()) {
            MaterializedViewDisplayInfo matViewDisplayInfo;
            ViewDisplayInfo viewDisplayInfo;
            ExternalTableDisplayInfo externalTableDisplayInfo;
            Node node = nodesIterator.next();
            TableDisplayInfo tableDisplayInfo = node.getTableDisplayInfo();
            if (tableDisplayInfo != null) {
                tableDisplayInfo.setX(this.fixCoordinate(node.getXMin()));
                tableDisplayInfo.setY(this.fixCoordinate(node.getYMin()));
            }
            if ((externalTableDisplayInfo = node.getExternalTableDisplayInfo()) != null) {
                externalTableDisplayInfo.setX(this.fixCoordinate(node.getXMin()));
                externalTableDisplayInfo.setY(this.fixCoordinate(node.getYMin()));
            }
            if ((viewDisplayInfo = node.getViewDisplayInfo()) != null) {
                viewDisplayInfo.setX(this.fixCoordinate(node.getXMin()));
                viewDisplayInfo.setY(this.fixCoordinate(node.getYMin()));
            }
            if ((matViewDisplayInfo = node.getMaterializedViewDisplayInfo()) == null) continue;
            matViewDisplayInfo.setX(this.fixCoordinate(node.getXMin()));
            matViewDisplayInfo.setY(this.fixCoordinate(node.getYMin()));
        }
        Iterator<Edge> it = graph.edgesIterator();
        while (it.hasNext()) {
            Edge edge = it.next();
            for (Point controlPoint : edge.getReferenceDisplayInfo().getControlPoints().getControlPoint()) {
                controlPoint.setX(this.fixCoordinate(controlPoint.getX()));
                controlPoint.setY(this.fixCoordinate(controlPoint.getY()));
            }
        }
    }

    double fixCoordinate(double x) {
        return Math.ceil(x) - 0.5;
    }
}

