/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.xml.model_import.display.geometry;

import com.vertabelo.xml.model_import.display.geometry.Point;
import com.vertabelo.xml.model_import.display.geometry.Vector;

public class Rectangle {
    private Point topLeft;
    private Point bottomRight;

    public Rectangle(Point topLeft, Point bottomRight) {
        this.topLeft = topLeft;
        this.bottomRight = bottomRight;
    }

    public double getXMin() {
        return this.topLeft.getX();
    }

    public double getXMax() {
        return this.bottomRight.getX();
    }

    public double getYMin() {
        return this.topLeft.getY();
    }

    public double getYMax() {
        return this.bottomRight.getY();
    }

    public double getHeight() {
        return this.getYMax() - this.getYMin();
    }

    public double getWidth() {
        return this.getXMax() - this.getXMin();
    }

    public double getMiddleX() {
        return (this.getXMax() + this.getXMin()) / 2.0;
    }

    public double getMiddleY() {
        return (this.getYMax() + this.getYMin()) / 2.0;
    }

    public Rectangle move(Vector v) {
        Point newTopLeft = this.topLeft.move(v);
        Point newBottomRight = this.bottomRight.move(v);
        return new Rectangle(newTopLeft, newBottomRight);
    }
}

