/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.xml.model_import.display.graph;

import com.vertabelo.xml.model.ExternalTableDisplayInfo;
import com.vertabelo.xml.model.MaterializedViewDisplayInfo;
import com.vertabelo.xml.model.TableDisplayInfo;
import com.vertabelo.xml.model.ViewDisplayInfo;
import com.vertabelo.xml.model_import.display.geometry.Point;
import com.vertabelo.xml.model_import.display.geometry.Rectangle;
import com.vertabelo.xml.model_import.display.geometry.Vector;
import com.vertabelo.xml.model_import.display.graph.Edge;
import java.util.HashSet;
import java.util.Set;

public class Node {
    private Rectangle rectangle;
    private TableDisplayInfo table;
    private ExternalTableDisplayInfo externalTable;
    private ViewDisplayInfo view;
    private MaterializedViewDisplayInfo materializedViewDisplay;
    Set<Edge> edgesNode1 = new HashSet<Edge>();
    Set<Edge> edgesNode2 = new HashSet<Edge>();

    public Node(double x, double y, double width, double height, TableDisplayInfo table) {
        Point topLeft = new Point(x, y);
        Point bottomRight = new Point(x + width, y + height);
        this.rectangle = new Rectangle(topLeft, bottomRight);
        this.table = table;
    }

    public Node(double x, double y, double width, double height, ViewDisplayInfo view) {
        Point topLeft = new Point(x, y);
        Point bottomRight = new Point(x + width, y + height);
        this.rectangle = new Rectangle(topLeft, bottomRight);
        this.view = view;
    }

    public Node(double x, double y, double width, double height, MaterializedViewDisplayInfo display) {
        Point topLeft = new Point(x, y);
        Point bottomRight = new Point(x + width, y + height);
        this.rectangle = new Rectangle(topLeft, bottomRight);
        this.materializedViewDisplay = display;
    }

    public Node(double x, double y, double width, double height, ExternalTableDisplayInfo externalTable) {
        Point topLeft = new Point(x, y);
        Point bottomRight = new Point(x + width, y + height);
        this.rectangle = new Rectangle(topLeft, bottomRight);
        this.externalTable = externalTable;
    }

    public TableDisplayInfo getTableDisplayInfo() {
        return this.table;
    }

    public ExternalTableDisplayInfo getExternalTableDisplayInfo() {
        return this.externalTable;
    }

    public ViewDisplayInfo getViewDisplayInfo() {
        return this.view;
    }

    public MaterializedViewDisplayInfo getMaterializedViewDisplayInfo() {
        return this.materializedViewDisplay;
    }

    public double getMiddleX() {
        return this.rectangle.getMiddleX();
    }

    public double getMiddleY() {
        return this.rectangle.getMiddleY();
    }

    public Point getMiddle() {
        return new Point(this.getMiddleX(), this.getMiddleY());
    }

    public void setMiddle(double newMiddleX, double newMiddleY) {
        double vectorX = newMiddleX - this.getMiddleX();
        double vectorY = newMiddleY - this.getMiddleY();
        this.rectangle = this.rectangle.move(new Vector(vectorX, vectorY));
    }

    public double getWidth() {
        return this.rectangle.getWidth();
    }

    public double getHeight() {
        return this.rectangle.getHeight();
    }

    public double getYMax() {
        return this.rectangle.getYMax();
    }

    public double getYMin() {
        return this.rectangle.getYMin();
    }

    public double getXMax() {
        return this.rectangle.getXMax();
    }

    public double getXMin() {
        return this.rectangle.getXMin();
    }

    void addEdgeNode1(Edge edge) {
        this.edgesNode1.add(edge);
    }

    void addEdgeNode2(Edge edge) {
        this.edgesNode2.add(edge);
    }

    public Set<Edge> getEdges() {
        HashSet<Edge> allEdges = new HashSet<Edge>();
        allEdges.addAll(this.edgesNode1);
        allEdges.addAll(this.edgesNode2);
        return allEdges;
    }
}

