/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.xml.model_import.display.spiral;

import com.vertabelo.xml.model.ControlPointsType;
import com.vertabelo.xml.model.Point;
import com.vertabelo.xml.model_import.display.GraphDrawingAlgorithm;
import com.vertabelo.xml.model_import.display.graph.Edge;
import com.vertabelo.xml.model_import.display.graph.Graph;
import com.vertabelo.xml.model_import.display.graph.Node;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class SpiralGraphDrawingAlgorithm
implements GraphDrawingAlgorithm {
    private static final SecureRandom r = new SecureRandom();
    private List<Node> sortedNodes = new ArrayList<Node>();
    private static final int DIAGRAM_SIZE = 10000;

    @Override
    public void run(Graph graph, int width, int height) {
        this.initNodes(graph);
        this.arrangeNodes();
        this.arrangeEdges(graph.getEdges());
    }

    private void initNodes(Graph graph) {
        this.sortedNodes.clear();
        this.sortedNodes.addAll(graph.getNodes());
        Collections.sort(this.sortedNodes, (o1, o2) -> {
            double area2;
            double area1 = o1.getWidth() * o1.getHeight();
            if (area1 - (area2 = o2.getWidth() * o2.getHeight()) < 0.0) {
                return 1;
            }
            if (area1 - area2 > 0.0) {
                return -1;
            }
            return 0;
        });
    }

    private void arrangeNodes() {
        double phi = 0.0;
        double r = 0.0;
        int maxNodesInLayer = 1;
        int nodesInLayer = 0;
        for (Node node : this.sortedNodes) {
            double x = r * Math.cos(phi) + 5000.0;
            double y = r * Math.sin(phi) + 5000.0;
            node.setMiddle(x, y);
            this.shiftNodeIntoVisibleArea(node);
            if (++nodesInLayer >= maxNodesInLayer) {
                nodesInLayer = 0;
                maxNodesInLayer = maxNodesInLayer == 1 ? 6 : maxNodesInLayer + 4;
                double edgeDistance = this.edgeDistance(node);
                if (edgeDistance > 2500.0) {
                    r += 2.0 * this.getDiagonal(node);
                } else if (edgeDistance > 500.0) {
                    r += 1.5 * this.getDiagonal(node);
                }
                phi = this.random(Math.PI * 2 / (double)maxNodesInLayer);
                continue;
            }
            phi += Math.PI * 2 / (double)maxNodesInLayer;
        }
    }

    private double edgeDistance(Node node) {
        double min1 = Math.min(node.getXMin(), node.getYMin());
        double min2 = Math.min(10000.0 - node.getXMax(), 10000.0 - node.getYMax());
        return Math.min(min1, min2);
    }

    private double random(double max) {
        return r.nextDouble() * max;
    }

    protected double getDiagonal(Node firstNode) {
        return Math.sqrt(firstNode.getWidth() * firstNode.getWidth() + firstNode.getHeight() * firstNode.getHeight()) / 2.0;
    }

    private void shiftNodeIntoVisibleArea(Node node) {
        if (node.getXMin() < 0.0) {
            node.setMiddle(node.getWidth() / 2.0, node.getMiddleY());
        }
        if (node.getYMin() < 0.0) {
            node.setMiddle(node.getMiddleX(), node.getHeight() / 2.0);
        }
        if (node.getXMax() >= 10000.0) {
            node.setMiddle(10000.0 - node.getWidth() / 2.0, node.getMiddleY());
        }
        if (node.getYMax() >= 10000.0) {
            node.setMiddle(node.getMiddleX(), 10000.0 - node.getHeight() / 2.0);
        }
    }

    private void arrangeEdges(Set<Edge> edges) {
        for (Edge edge : edges) {
            Node node2;
            Node node1 = edge.getNode1();
            if (node1.equals(node2 = edge.getNode2())) {
                this.addSelfReferenceControlPoints(edge);
                continue;
            }
            this.addCross3CpControlPoints(edge);
        }
    }

    protected void addCross3CpControlPoints(Edge edge) {
        edge.getReferenceDisplayInfo().setType(ControlPointsType.CROSS_3_CP);
        Node node1 = edge.getNode1();
        Node node2 = edge.getNode2();
        double x1 = node1.getMiddleX() - node1.getWidth() / 3.0 + this.random(2.0 * node1.getWidth() / 3.0);
        double y1 = node1.getMiddleY() - node1.getHeight() / 3.0 + this.random(2.0 * node1.getHeight() / 3.0);
        double x2 = node2.getMiddleX() - node2.getWidth() / 3.0 + this.random(2.0 * node2.getWidth() / 3.0);
        double y2 = node2.getMiddleY() - node2.getHeight() / 3.0 + this.random(2.0 * node2.getHeight() / 3.0);
        Point point1 = this.makePoint(x1, y1);
        Point point2 = this.makePoint(x1, y2);
        Point point3 = this.makePoint(x2, y2);
        edge.getReferenceDisplayInfo().getControlPoints().getControlPoint().clear();
        edge.getReferenceDisplayInfo().getControlPoints().getControlPoint().add(point1);
        edge.getReferenceDisplayInfo().getControlPoints().getControlPoint().add(point2);
        edge.getReferenceDisplayInfo().getControlPoints().getControlPoint().add(point3);
    }

    protected void addSelfReferenceControlPoints(Edge edge) {
        edge.getReferenceDisplayInfo().setType(ControlPointsType.SELF_5_CP);
        Node node = edge.getNode1();
        double x1 = node.getMiddleX() - node.getWidth() / 3.0 + this.random(2.0 * node.getWidth() / 3.0);
        double y1 = node.getYMax() - node.getHeight() * 1.0 / 3.0 - this.random(node.getHeight() * 1.0 / 3.0);
        double x2 = node.getXMax() + node.getWidth() / 3.0 + this.random(2.0 * node.getWidth() / 3.0);
        double y2 = node.getYMin() - node.getHeight() * 1.0 / 3.0 - this.random(node.getHeight() * 1.0 / 3.0);
        double y3 = node.getYMax() - node.getHeight() * 1.0 / 3.0 - this.random(node.getHeight() * 1.0 / 3.0);
        Point point1 = this.makePoint(x1, y1);
        Point point2 = this.makePoint(x1, y2);
        Point point3 = this.makePoint(x2, y2);
        Point point4 = this.makePoint(x2, y3);
        Point point5 = this.makePoint(x1, y3);
        edge.getReferenceDisplayInfo().getControlPoints().getControlPoint().clear();
        edge.getReferenceDisplayInfo().getControlPoints().getControlPoint().add(point1);
        edge.getReferenceDisplayInfo().getControlPoints().getControlPoint().add(point2);
        edge.getReferenceDisplayInfo().getControlPoints().getControlPoint().add(point3);
        edge.getReferenceDisplayInfo().getControlPoints().getControlPoint().add(point4);
        edge.getReferenceDisplayInfo().getControlPoints().getControlPoint().add(point5);
    }

    protected Point makePoint(double x, double y) {
        Point p = new Point();
        p.setX(x);
        p.setY(y);
        return p;
    }

    @Override
    public void setDebug(boolean debug) {
    }
}

