/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.xml.model_import.model;

import com.vertabelo.xml.model_import.model.Check;
import com.vertabelo.xml.model_import.model.DatabaseObject;
import com.vertabelo.xml.model_import.model.HavingOwner;
import com.vertabelo.xml.model_import.model.TableExpression;
import java.util.Comparator;

public class Column
extends DatabaseObject
implements HavingOwner {
    private String typeName;
    private boolean nullable;
    private String defaultValue;
    protected TableExpression owner;
    private Check checkExpression;

    public Column(String name, String typeName, boolean nullable, String defaultValue, TableExpression owner) {
        super(name);
        this.name = name;
        this.typeName = typeName;
        this.nullable = nullable;
        this.defaultValue = defaultValue;
        this.owner = owner;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Column other = (Column)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.owner == null ? other.owner != null : !this.owner.equals(other.owner)) {
            return false;
        }
        return !(this.typeName == null ? other.typeName != null : !this.typeName.equals(other.typeName));
    }

    public Check getCheckExpression() {
        return this.checkExpression;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public TableExpression getOwner() {
        return this.owner;
    }

    public String getOwnerName() {
        return this.owner.name;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.owner == null ? 0 : this.owner.hashCode());
        result = 31 * result + (this.typeName == null ? 0 : this.typeName.hashCode());
        return result;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setCheckExpression(Check checkExpression) {
        this.checkExpression = checkExpression;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    @Override
    public void setOwner(TableExpression owner) {
        this.owner = owner;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("\t\tColumn:\n");
        result.append("\t\tName: ");
        result.append(this.name);
        result.append("\n");
        result.append("\t\tType: ");
        result.append(this.typeName);
        result.append("\n");
        result.append("\t\tTableExpression: ");
        if (this.owner == null) {
            result.append("null");
        } else {
            result.append(this.owner.name);
        }
        result.append("\n");
        return result.toString();
    }

    public static class ColumnNameComparator
    implements Comparator<Column> {
        @Override
        public int compare(Column o1, Column o2) {
            if (o1 == null || o2 == null) {
                throw new NullPointerException();
            }
            return o1.name.compareToIgnoreCase(o2.name);
        }
    }
}

