/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.xml.model_import.model;

import com.vertabelo.xml.model_import.model.DatabaseObject;
import com.vertabelo.xml.model_import.model.ExternalTable;
import com.vertabelo.xml.model_import.model.HavingSchema;
import com.vertabelo.xml.model_import.model.MaterializedView;
import com.vertabelo.xml.model_import.model.Reference;
import com.vertabelo.xml.model_import.model.Sequence;
import com.vertabelo.xml.model_import.model.Table;
import com.vertabelo.xml.model_import.model.TableExpression;
import com.vertabelo.xml.model_import.model.View;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class Database {
    protected String databaseEngineName = "";
    protected String databaseEngineVersion = "";
    protected Set<Table> tables = new LinkedHashSet<Table>();
    protected Set<ExternalTable> externalTables = new LinkedHashSet<ExternalTable>();
    protected Set<View> views = new LinkedHashSet<View>();
    protected Set<MaterializedView> materializedViews = new LinkedHashSet<MaterializedView>();
    protected Set<Reference> references = new LinkedHashSet<Reference>();
    protected Set<Sequence> sequences = new LinkedHashSet<Sequence>();

    public void addReference(Reference reference) {
        this.references.add(reference);
    }

    public void addSequence(Sequence s) {
        this.sequences.add(s);
    }

    public void addTable(Table table) {
        this.tables.add(table);
    }

    public void addExternalTable(ExternalTable externalTable) {
        this.externalTables.add(externalTable);
    }

    public void addView(View view) {
        this.views.add(view);
    }

    public void addMaterializedView(MaterializedView view) {
        this.materializedViews.add(view);
    }

    public Reference findReference(String name, String ownerName, String ownerSchema) {
        if (ownerSchema != null && ownerName == null) {
            throw new IllegalArgumentException("Schema set but not owner name.");
        }
        for (Reference r : this.getReferences()) {
            if (!this.stringsEqual(name, r.getName())) continue;
            TableExpression t = r.getOwner();
            if (t == null && ownerName == null) {
                return r;
            }
            if (t == null || !this.stringsEqual(t.getName(), ownerName) || !this.stringsEqual(t.getSchema(), ownerSchema)) continue;
            return r;
        }
        return null;
    }

    public Reference findReference(String parentRole, String childRole) {
        for (Reference r : this.getReferences()) {
            if (r.getParentRole() == null || !r.getParentRole().equals(parentRole) || r.getChildRole() == null || !r.getChildRole().equals(childRole)) continue;
            return r;
        }
        return null;
    }

    public List<Reference> findReferencesByForeignTable(TableExpression table) {
        LinkedList<Reference> result = new LinkedList<Reference>();
        for (Reference r : this.getReferences()) {
            if (!r.getOwner().equals(table)) continue;
            result.add(r);
        }
        return result;
    }

    public Table findTable(String name, String schema) {
        return this.findByName(name, schema, this.getTables());
    }

    public Sequence findSequence(String name, String schema) {
        return this.findByName(name, schema, this.getSequences());
    }

    public ExternalTable findExternalTable(String name, String schema) {
        return this.findByName(name, schema, this.getExternalTables());
    }

    public View findView(String name, String schema) {
        return this.findByName(name, schema, this.getViews());
    }

    public MaterializedView findMaterializedView(String name, String schema) {
        return this.findByName(name, schema, this.getMaterializedViews());
    }

    public String getDatabaseEngineName() {
        return this.databaseEngineName;
    }

    public String getDatabaseEngineVersion() {
        return this.databaseEngineVersion;
    }

    public Set<Reference> getReferences() {
        return Collections.unmodifiableSet(this.references);
    }

    public Set<Sequence> getSequences() {
        return Collections.unmodifiableSet(this.sequences);
    }

    public Set<Table> getTables() {
        return Collections.unmodifiableSet(this.tables);
    }

    public Set<ExternalTable> getExternalTables() {
        return Collections.unmodifiableSet(this.externalTables);
    }

    public Set<View> getViews() {
        return Collections.unmodifiableSet(this.views);
    }

    public Set<MaterializedView> getMaterializedViews() {
        return Collections.unmodifiableSet(this.materializedViews);
    }

    public void removeReference(Reference reference) {
        this.references.remove(reference);
    }

    public void removeSequence(Sequence sequence) {
        this.sequences.remove(sequence);
    }

    public void removeTable(Table table) {
        this.tables.remove(table);
    }

    public void removeExternalTable(ExternalTable table) {
        this.externalTables.remove(table);
    }

    public void removeView(View view) {
        this.views.remove(view);
    }

    public void setDatabaseEngineName(String databaseEngineName) {
        this.databaseEngineName = databaseEngineName;
    }

    public void setDatabaseEngineVersion(String databaseEngineVersion) {
        this.databaseEngineVersion = databaseEngineVersion;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Database:\n");
        result.append("Tables:\n");
        Iterator<DatabaseObject> i = this.tables.iterator();
        while (i.hasNext()) {
            result.append(i.next().toString());
        }
        result.append("External tables:\n");
        i = this.externalTables.iterator();
        while (i.hasNext()) {
            result.append(((ExternalTable)i.next()).toString());
        }
        result.append("Views:\n");
        i = this.views.iterator();
        while (i.hasNext()) {
            result.append(((View)i.next()).toString());
        }
        result.append("Materialized views:\n");
        this.materializedViews.forEach(it -> result.append(it.toString()));
        result.append("References:\n");
        i = this.references.iterator();
        while (i.hasNext()) {
            result.append(((Reference)i.next()).toString());
        }
        return result.toString();
    }

    private <T extends DatabaseObject> T findByName(String name, String schema, Collection<T> inputs) {
        for (DatabaseObject o : inputs) {
            HavingSchema havingSchema;
            if (!this.stringsEqual(name, o.getName()) || o instanceof HavingSchema && !this.stringsEqual(schema, (havingSchema = (HavingSchema)((Object)o)).getSchema())) continue;
            return (T)o;
        }
        return null;
    }

    private boolean stringsEqual(String a, String b) {
        if (a == null && b == null) {
            return true;
        }
        return a != null && b != null && a.equals(b);
    }
}

