/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.xml.model_import.model;

import com.vertabelo.xml.model_import.model.DatabaseObject;
import com.vertabelo.xml.model_import.model.ExternalTableColumn;
import com.vertabelo.xml.model_import.model.ExternalTablePrimaryKey;
import com.vertabelo.xml.model_import.model.HavingSchema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class ExternalTableExpression
extends DatabaseObject
implements HavingSchema {
    protected String catalog;
    protected String schema;
    protected List<ExternalTableColumn> columns = new ArrayList<ExternalTableColumn>();
    protected ExternalTablePrimaryKey primaryKey;

    public ExternalTableExpression() {
        super(null);
    }

    public ExternalTableExpression(String name) {
        super(name);
    }

    public void addColumn(ExternalTableColumn c) {
        c.setOwner(this);
        this.columns.add(c);
    }

    public void addColumn(int index, ExternalTableColumn c) {
        c.setOwner(this);
        this.columns.add(index, c);
    }

    public ExternalTableColumn findColumn(String name) {
        for (ExternalTableColumn c : this.getColumns()) {
            if (c.getName() == null || !c.getName().equals(name)) continue;
            return c;
        }
        return null;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public ExternalTableColumn getColumn(int i) {
        return this.columns.get(i);
    }

    public int getColumnPosition(ExternalTableColumn c) {
        return this.columns.indexOf(c);
    }

    public List<ExternalTableColumn> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public ExternalTablePrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    public void removeColumn(ExternalTableColumn c) {
        this.columns.remove(c);
        c.setOwner(null);
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public void setPrimaryKey(ExternalTablePrimaryKey primaryKey) {
        primaryKey.setOwner(this);
        this.primaryKey = primaryKey;
    }

    @Override
    public void setSchema(String schema) {
        this.schema = schema;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("\tName: ");
        result.append(this.name);
        result.append("\n");
        result.append("\tColumns:\n");
        Iterator<ExternalTableColumn> i = this.columns.iterator();
        while (i.hasNext()) {
            result.append(i.next().toString());
        }
        if (this.primaryKey != null) {
            result.append("\tPrimary key:\n");
            result.append(this.primaryKey);
        }
        return result.toString();
    }
}

