/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.xml.model_import.model;

import com.vertabelo.xml.model_import.model.ColumnPair;
import com.vertabelo.xml.model_import.model.Constraint;
import com.vertabelo.xml.model_import.model.Table;
import com.vertabelo.xml.model_import.model.TableExpression;
import java.util.Iterator;
import java.util.List;

public class Reference
extends Constraint {
    protected List<ColumnPair> columnPairs;
    protected String parentRole;
    protected String childRole;
    protected boolean oneToMany;
    protected Table parentTable;
    protected Integer onDeleteAction;
    protected Integer onUpdateAction;
    protected boolean mandatory;

    public Reference(String name, Table parentTable, Table childTable, String parentRole, String childRole, boolean multiplicity, List<ColumnPair> columnPairs, Integer onUpdateAction, Integer onDeleteAction, boolean mandatory) {
        super(name, childTable);
        this.parentTable = parentTable;
        this.columnPairs = columnPairs;
        this.parentRole = parentRole;
        this.childRole = childRole;
        this.oneToMany = multiplicity;
        this.onUpdateAction = onUpdateAction;
        this.onDeleteAction = onDeleteAction;
        this.mandatory = mandatory;
    }

    public String getChildRole() {
        return this.childRole;
    }

    public Table getChildTable() {
        return (Table)this.getOwner();
    }

    public List<ColumnPair> getColumnPairs() {
        return this.columnPairs;
    }

    public Integer getOnDeleteAction() {
        return this.onDeleteAction;
    }

    public Integer getOnUpdateAction() {
        return this.onUpdateAction;
    }

    public String getParentRole() {
        return this.parentRole;
    }

    public Table getParentTable() {
        return this.parentTable;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public boolean isOneToMany() {
        return this.oneToMany;
    }

    @Override
    public void setOwner(TableExpression owner) {
        if (!(owner instanceof Table)) {
            throw new IllegalArgumentException("Reference may be defined between tables only.");
        }
        super.setOwner(owner);
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("\tParent role: ");
        result.append(this.parentRole);
        result.append("\n");
        result.append("\tChild role: ");
        result.append(this.childRole);
        result.append("\n");
        result.append("\tOne to many: ");
        result.append(this.oneToMany);
        result.append("\n");
        result.append("\tReference joins:\n");
        Iterator<ColumnPair> i = this.columnPairs.iterator();
        while (i.hasNext()) {
            result.append(i.next());
        }
        return result.toString();
    }

    public void setParentTable(Table parentTable) {
        this.parentTable = parentTable;
    }

    public void setChildTable(Table childTable) {
        super.setOwner(childTable);
    }
}

