/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.xml.model_import.model;

import com.vertabelo.xml.model_import.model.Check;
import com.vertabelo.xml.model_import.model.Column;
import com.vertabelo.xml.model_import.model.DatabaseObject;
import com.vertabelo.xml.model_import.model.HavingSchema;
import com.vertabelo.xml.model_import.model.Key;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public abstract class TableExpression
extends DatabaseObject
implements HavingSchema {
    protected String catalog;
    protected String schema;
    protected List<Column> columns = new ArrayList<Column>();
    protected Key primaryKey;
    protected Set<Key> alternateKeys = new LinkedHashSet<Key>();
    protected Set<Check> tableChecks = new LinkedHashSet<Check>();

    public TableExpression() {
        super(null);
    }

    public TableExpression(String name) {
        super(name);
    }

    public void addAlternateKey(Key alternateKey) {
        alternateKey.setOwner(this);
        this.alternateKeys.add(alternateKey);
    }

    public void addAlternateKeys(Collection<Key> alternateKeys) {
        for (Key alternateKey : alternateKeys) {
            this.addAlternateKey(alternateKey);
        }
    }

    public void addColumn(Column c) {
        c.setOwner(this);
        this.columns.add(c);
    }

    public void addColumn(int index, Column c) {
        c.setOwner(this);
        this.columns.add(index, c);
    }

    public void addTableCheck(Check tableCheck) {
        tableCheck.setOwner(this);
        this.tableChecks.add(tableCheck);
    }

    public Key findAlternateKey(String name) {
        for (Key c : this.getAlternateKeys()) {
            if (c.getName() == null || !c.getName().equals(name)) continue;
            return c;
        }
        return null;
    }

    public Column findColumn(String name) {
        for (Column c : this.getColumns()) {
            if (c.getName() == null || !c.getName().equals(name)) continue;
            return c;
        }
        return null;
    }

    public Check findTableCheck(String name) {
        for (Check c : this.getTableChecks()) {
            if (c.getName() == null || !c.getName().equals(name)) continue;
            return c;
        }
        return null;
    }

    public Set<Key> getAlternateKeys() {
        return Collections.unmodifiableSet(this.alternateKeys);
    }

    public String getCatalog() {
        return this.catalog;
    }

    public Column getColumn(int i) {
        return this.columns.get(i);
    }

    public int getColumnPosition(Column c) {
        return this.columns.indexOf(c);
    }

    public List<Column> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public Key getPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    public Set<Check> getTableChecks() {
        return Collections.unmodifiableSet(this.tableChecks);
    }

    public void removeAlternateKey(Key alternateKey) {
        this.alternateKeys.remove(alternateKey);
        alternateKey.setOwner(null);
    }

    public void removeColumn(Column c) {
        this.columns.remove(c);
        c.setOwner(null);
    }

    public void removeTableCheck(Check c) {
        this.tableChecks.remove(c);
        c.setOwner(null);
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public void setPrimaryKey(Key primaryKey) {
        primaryKey.setOwner(this);
        this.primaryKey = primaryKey;
    }

    @Override
    public void setSchema(String schema) {
        this.schema = schema;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("\tName: ");
        result.append(this.name);
        result.append("\n");
        result.append("\tColumns:\n");
        Iterator<DatabaseObject> i = this.columns.iterator();
        while (i.hasNext()) {
            result.append(i.next().toString());
        }
        if (this.primaryKey != null) {
            result.append("\tPrimary key:\n");
            result.append(this.primaryKey);
        }
        if (!this.alternateKeys.isEmpty()) {
            result.append("\tAlternate keys:\n");
            i = this.alternateKeys.iterator();
            while (i.hasNext()) {
                result.append(((Key)i.next()).toString());
            }
        }
        return result.toString();
    }
}

