/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.xml.model_import.model2xml;

import com.vertabelo.xml.model.AlternateKey;
import com.vertabelo.xml.model.AlternateKeyColumns;
import com.vertabelo.xml.model.AlternateKeys;
import com.vertabelo.xml.model.Areas;
import com.vertabelo.xml.model.Column;
import com.vertabelo.xml.model.Columns;
import com.vertabelo.xml.model.ConstraintAction;
import com.vertabelo.xml.model.ControlPointsType;
import com.vertabelo.xml.model.Counter;
import com.vertabelo.xml.model.Counters;
import com.vertabelo.xml.model.DatabaseEngine;
import com.vertabelo.xml.model.DatabaseModel;
import com.vertabelo.xml.model.ExternalTable;
import com.vertabelo.xml.model.ExternalTableColumn;
import com.vertabelo.xml.model.ExternalTableColumns;
import com.vertabelo.xml.model.ExternalTableDisplayInfo;
import com.vertabelo.xml.model.ExternalTableDisplays;
import com.vertabelo.xml.model.ExternalTables;
import com.vertabelo.xml.model.Indexes;
import com.vertabelo.xml.model.MaterializedView;
import com.vertabelo.xml.model.MaterializedViewColumn;
import com.vertabelo.xml.model.MaterializedViewColumns;
import com.vertabelo.xml.model.MaterializedViewDisplayInfo;
import com.vertabelo.xml.model.MaterializedViewDisplays;
import com.vertabelo.xml.model.MaterializedViews;
import com.vertabelo.xml.model.Notes;
import com.vertabelo.xml.model.ObjectFactory;
import com.vertabelo.xml.model.Point;
import com.vertabelo.xml.model.Properties;
import com.vertabelo.xml.model.Property;
import com.vertabelo.xml.model.ReferenceColumn;
import com.vertabelo.xml.model.ReferenceColumns;
import com.vertabelo.xml.model.ReferenceDisplayInfo;
import com.vertabelo.xml.model.ReferenceDisplays;
import com.vertabelo.xml.model.References;
import com.vertabelo.xml.model.Sequences;
import com.vertabelo.xml.model.TableCheck;
import com.vertabelo.xml.model.TableChecks;
import com.vertabelo.xml.model.TableDisplayInfo;
import com.vertabelo.xml.model.TableDisplays;
import com.vertabelo.xml.model.Tables;
import com.vertabelo.xml.model.Texts;
import com.vertabelo.xml.model.ViewColumn;
import com.vertabelo.xml.model.ViewColumns;
import com.vertabelo.xml.model.ViewDisplayInfo;
import com.vertabelo.xml.model.ViewDisplays;
import com.vertabelo.xml.model.Views;
import com.vertabelo.xml.model_import.model.Check;
import com.vertabelo.xml.model_import.model.ColumnPair;
import com.vertabelo.xml.model_import.model.Database;
import com.vertabelo.xml.model_import.model.DatabaseObject;
import com.vertabelo.xml.model_import.model.ExternalTablePrimaryKey;
import com.vertabelo.xml.model_import.model.Index;
import com.vertabelo.xml.model_import.model.IndexColumn;
import com.vertabelo.xml.model_import.model.Key;
import com.vertabelo.xml.model_import.model.Reference;
import com.vertabelo.xml.model_import.model.Sequence;
import com.vertabelo.xml.model_import.model.Table;
import com.vertabelo.xml.model_import.model.View;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Model2Xml {
    private static final String LATEST_XSD_VERSION = "2.4";
    private static final String LINE_COLOR = "#000000";
    public static final String ZERO_TO_ONE = "0..1";
    public static final String ZERO_TO_MANY = "0..*";
    private final Consumer<String> progressConsumer;
    private int tableCount = 0;
    private int externalTableCount = 0;
    private int viewCount = 0;
    private int materializedViewCount = 0;
    private int columnCount = 0;
    private int externalTableColumnCount = 0;
    private int indexCount = 0;
    private int alternateKeyCount = 0;
    private int referenceCount = 0;
    private int sequenceCount = 0;
    private int tableCheckCount = 0;
    private int viewColumnCount = 0;
    private int materializedViewColumnCount = 0;
    private int tableDisplayCount = 0;
    private int externalTableDisplayCount = 0;
    private int viewDisplayCount = 0;
    private int materializedViewDisplayCount = 0;
    private int referenceDisplayCount = 0;
    private Map<Table, com.vertabelo.xml.model.Table> tableToXmlTable = new HashMap<Table, com.vertabelo.xml.model.Table>();
    private Map<com.vertabelo.xml.model_import.model.ExternalTable, ExternalTable> externalTableToXmlExternalTable = new HashMap<com.vertabelo.xml.model_import.model.ExternalTable, ExternalTable>();
    private Map<View, com.vertabelo.xml.model.View> viewToXmlView = new HashMap<View, com.vertabelo.xml.model.View>();
    private Map<Table, TableDisplayInfo> tableToXmlTableDisplayInfo = new HashMap<Table, TableDisplayInfo>();
    private Map<com.vertabelo.xml.model_import.model.ExternalTable, ExternalTableDisplayInfo> externalTableToXmlExternalTableDisplayInfo = new HashMap<com.vertabelo.xml.model_import.model.ExternalTable, ExternalTableDisplayInfo>();
    private Map<com.vertabelo.xml.model_import.model.Column, Column> columnToXmlColumn = new HashMap<com.vertabelo.xml.model_import.model.Column, Column>();
    private Map<com.vertabelo.xml.model_import.model.ExternalTableColumn, ExternalTableColumn> externalTableColumnToXmlExternalTableColumn = new HashMap<com.vertabelo.xml.model_import.model.ExternalTableColumn, ExternalTableColumn>();
    private Map<Reference, com.vertabelo.xml.model.Reference> referenceToXmlReference = new HashMap<Reference, com.vertabelo.xml.model.Reference>();
    private ObjectFactory objectFactory = new ObjectFactory();

    public Model2Xml(Consumer<String> progressConsumer) {
        this.progressConsumer = progressConsumer;
    }

    private void initCounters() {
        this.tableCount = 0;
        this.externalTableCount = 0;
        this.viewCount = 0;
        this.materializedViewCount = 0;
        this.columnCount = 0;
        this.externalTableColumnCount = 0;
        this.indexCount = 0;
        this.alternateKeyCount = 0;
        this.referenceCount = 0;
        this.tableCheckCount = 0;
        this.viewColumnCount = 0;
        this.materializedViewColumnCount = 0;
        this.materializedViewDisplayCount = 0;
        this.tableDisplayCount = 0;
        this.externalTableDisplayCount = 0;
        this.referenceDisplayCount = 0;
        this.tableToXmlTable.clear();
        this.externalTableToXmlExternalTable.clear();
        this.columnToXmlColumn.clear();
        this.externalTableColumnToXmlExternalTableColumn.clear();
    }

    public DatabaseModel buildXmlModel(Database database) {
        this.progressConsumer.accept("Preparing xml..." + System.lineSeparator());
        this.initCounters();
        DatabaseModel databaseModel = new DatabaseModel();
        databaseModel.setVersionId(LATEST_XSD_VERSION);
        databaseModel.setAdditionalSQLBeforeCreate("");
        databaseModel.setAdditionalSQLAfterCreate("");
        databaseModel.setAdditionalSQLBeforeDrop("");
        databaseModel.setAdditionalSQLAfterDrop("");
        Tables tables = this.buildXmlTables(database);
        databaseModel.setTables(tables);
        TableDisplays tableDisplays = this.buildXmlTableDisplays(database);
        databaseModel.setTableDisplays(tableDisplays);
        ExternalTables externalTables = this.buildXmlExternalTables(database);
        databaseModel.setExternalTables(externalTables);
        ExternalTableDisplays externalTableDisplays = this.buildXmlExternalTableDisplays(database);
        databaseModel.setExternalTableDisplays(externalTableDisplays);
        Views views = this.buildXmlViews(database);
        databaseModel.setViews(views);
        ViewDisplays viewDisplays = this.buildXmlViewDisplays(database);
        databaseModel.setViewDisplays(viewDisplays);
        Map<com.vertabelo.xml.model_import.model.MaterializedView, MaterializedView> materializedViewToXmlMaterializedView = this.buildMaterializedViewToXmlMaterializedViewMap(database);
        databaseModel.setMaterializedViews(this.buildXmlMaterializedViews(materializedViewToXmlMaterializedView.values()));
        databaseModel.setMaterializedViewDisplays(this.buildXmlMaterializedViewDisplays(database.getMaterializedViews(), materializedViewToXmlMaterializedView::get));
        References xmlReferences = this.buildXmlReferences(database);
        databaseModel.setReferences(xmlReferences);
        ReferenceDisplays xmlReferenceDisplays = this.buildXmlReferenceDisplays(database);
        databaseModel.setReferenceDisplays(xmlReferenceDisplays);
        Sequences xmlSequences = this.buildXmlSequences(database);
        databaseModel.setSequences(xmlSequences);
        databaseModel.setNotes(new Notes());
        databaseModel.setAreas(new Areas());
        databaseModel.setTexts(new Texts());
        Counters xmlCounters = this.buildXmlCounters();
        databaseModel.setCounters(xmlCounters);
        databaseModel.setDatabaseEngine(new DatabaseEngine());
        databaseModel.getDatabaseEngine().setName(database.getDatabaseEngineName());
        databaseModel.getDatabaseEngine().setVersion(database.getDatabaseEngineVersion());
        databaseModel.setName("");
        databaseModel.setDescription("");
        this.progressConsumer.accept("Preparing xml done." + System.lineSeparator());
        return databaseModel;
    }

    private MaterializedViewDisplays buildXmlMaterializedViewDisplays(Collection<com.vertabelo.xml.model_import.model.MaterializedView> materializedViews, Function<com.vertabelo.xml.model_import.model.MaterializedView, MaterializedView> materializedViewToXmlMaterializedView) {
        MaterializedViewDisplays displays = new MaterializedViewDisplays();
        materializedViews.stream().map(it -> this.buildXmlMaterializedViewDisplayInfo((com.vertabelo.xml.model_import.model.MaterializedView)it, materializedViewToXmlMaterializedView)).forEach(xmlDisplay -> displays.getMaterializedViewDisplay().add((MaterializedViewDisplayInfo)xmlDisplay));
        return displays;
    }

    private MaterializedViewDisplayInfo buildXmlMaterializedViewDisplayInfo(com.vertabelo.xml.model_import.model.MaterializedView materializedView, Function<com.vertabelo.xml.model_import.model.MaterializedView, MaterializedView> materializedViewToXmlMaterializedView) {
        MaterializedViewDisplayInfo info = new MaterializedViewDisplayInfo();
        info.setId(this.getNextMaterializedViewDisplayId());
        info.setFillColor("#B8F0FF");
        info.setLineColor(LINE_COLOR);
        info.setHeight(0.0);
        info.setWidth(0.0);
        info.setX(0.0);
        info.setY(0.0);
        MaterializedView xmlView = materializedViewToXmlMaterializedView.apply(materializedView);
        info.setMaterializedView(xmlView);
        return info;
    }

    private MaterializedViews buildXmlMaterializedViews(Collection<MaterializedView> materializedViews) {
        MaterializedViews out = new MaterializedViews();
        materializedViews.forEach(it -> out.getMaterializedView().add((MaterializedView)it));
        return out;
    }

    private Map<com.vertabelo.xml.model_import.model.MaterializedView, MaterializedView> buildMaterializedViewToXmlMaterializedViewMap(Database database) {
        return database.getMaterializedViews().stream().collect(Collectors.toMap(view -> view, this::buildXmlMaterializedView));
    }

    private Views buildXmlViews(Database database) {
        Views xmlViews = new Views();
        Set<View> views = database.getViews();
        for (View view : views) {
            com.vertabelo.xml.model.View xmlView = this.buildXmlView(view);
            xmlViews.getView().add(xmlView);
            this.viewToXmlView.put(view, xmlView);
        }
        return xmlViews;
    }

    private com.vertabelo.xml.model.View buildXmlView(View view) {
        com.vertabelo.xml.model.View xmlView = new com.vertabelo.xml.model.View();
        xmlView.setId(this.getNextViewId());
        xmlView.setName(view.getName());
        xmlView.setViewColumns(this.buildXmlViewColumns(view));
        xmlView.setSQLQuery(view.getSql() == null ? "" : view.getSql());
        xmlView.setAdditionalSQLAfter("");
        xmlView.setAdditionalSQLBefore("");
        xmlView.setDescription(view.getDescription() == null ? "" : view.getDescription());
        xmlView.setProperties(this.getProperties(view));
        xmlView.setDependantViews(this.objectFactory.createViewDependencies());
        xmlView.setDependantMaterializedViews(this.objectFactory.createMaterializedViewDependencies());
        return xmlView;
    }

    private MaterializedView buildXmlMaterializedView(com.vertabelo.xml.model_import.model.MaterializedView materializedView) {
        MaterializedView xmlView = new MaterializedView();
        xmlView.setId(this.getNextMaterializedViewId());
        xmlView.setName(materializedView.getName());
        MaterializedViewColumns xmlViewColumns = this.buildXmlMaterializedViewColumns(materializedView);
        xmlView.setMaterializedViewColumns(xmlViewColumns);
        xmlView.setSQLQuery(materializedView.getSql() == null ? "" : materializedView.getSql());
        xmlView.setAdditionalSQLAfter("");
        xmlView.setAdditionalSQLBefore("");
        xmlView.setDescription(materializedView.getDescription() == null ? "" : materializedView.getDescription());
        xmlView.setProperties(this.getProperties(materializedView));
        xmlView.setDependantViews(this.objectFactory.createViewDependencies());
        xmlView.setDependantMaterializedViews(this.objectFactory.createMaterializedViewDependencies());
        return xmlView;
    }

    private MaterializedViewColumns buildXmlMaterializedViewColumns(com.vertabelo.xml.model_import.model.MaterializedView materializedView) {
        MaterializedViewColumns xmlColumns = new MaterializedViewColumns();
        materializedView.getColumns().stream().map(this::buildXmlMaterializedViewColumn).forEach(it -> xmlColumns.getMaterializedViewColumn().add((MaterializedViewColumn)it));
        return xmlColumns;
    }

    private MaterializedViewColumn buildXmlMaterializedViewColumn(com.vertabelo.xml.model_import.model.Column column) {
        MaterializedViewColumn xmlColumn = new MaterializedViewColumn();
        xmlColumn.setDescription(column.getDescription() == null ? "" : column.getDescription());
        xmlColumn.setId(this.getNextMaterializedViewColumnId());
        xmlColumn.setName(column.getName());
        xmlColumn.setProperties(this.getProperties(column));
        xmlColumn.setType(column.getTypeName());
        return xmlColumn;
    }

    private ViewDisplayInfo buildXmlViewDisplayInfo(View view) {
        ViewDisplayInfo viewDisplayInfo = new ViewDisplayInfo();
        viewDisplayInfo.setId(this.getNextViewDisplayId());
        viewDisplayInfo.setFillColor("#C9DAF8");
        viewDisplayInfo.setLineColor(LINE_COLOR);
        viewDisplayInfo.setHeight(0.0);
        viewDisplayInfo.setWidth(0.0);
        viewDisplayInfo.setX(0.0);
        viewDisplayInfo.setY(0.0);
        com.vertabelo.xml.model.View xmlView = this.viewToXmlView.get(view);
        viewDisplayInfo.setView(xmlView);
        return viewDisplayInfo;
    }

    private ViewDisplays buildXmlViewDisplays(Database database) {
        ViewDisplays viewDisplays = new ViewDisplays();
        for (View view : database.getViews()) {
            ViewDisplayInfo xmlViewDisplay = this.buildXmlViewDisplayInfo(view);
            viewDisplays.getViewDisplay().add(xmlViewDisplay);
        }
        return viewDisplays;
    }

    private ViewColumns buildXmlViewColumns(View view) {
        ViewColumns xmlViewColumns = new ViewColumns();
        List<com.vertabelo.xml.model_import.model.Column> viewColumns = view.getColumns();
        for (com.vertabelo.xml.model_import.model.Column column : viewColumns) {
            ViewColumn xmlViewColumn = this.buildXmlViewColumn(column);
            xmlViewColumns.getViewColumn().add(xmlViewColumn);
        }
        return xmlViewColumns;
    }

    private ViewColumn buildXmlViewColumn(com.vertabelo.xml.model_import.model.Column column) {
        ViewColumn xmlViewColumn = new ViewColumn();
        xmlViewColumn.setDescription(column.getDescription() == null ? "" : column.getDescription());
        xmlViewColumn.setId(this.getNextViewColumnId());
        xmlViewColumn.setName(column.getName());
        xmlViewColumn.setProperties(this.getProperties(column));
        xmlViewColumn.setType(column.getTypeName());
        return xmlViewColumn;
    }

    private Sequences buildXmlSequences(Database database) {
        Sequences xmlSequences = new Sequences();
        Set<Sequence> sequences = database.getSequences();
        for (Sequence sequence : sequences) {
            com.vertabelo.xml.model.Sequence xmlSequence = this.buildXmlSequence(sequence);
            xmlSequences.getSequence().add(xmlSequence);
        }
        return xmlSequences;
    }

    private com.vertabelo.xml.model.Sequence buildXmlSequence(Sequence sequence) {
        com.vertabelo.xml.model.Sequence xmlSequence = new com.vertabelo.xml.model.Sequence();
        xmlSequence.setId(this.getNextSequenceId());
        xmlSequence.setName(sequence.getName());
        xmlSequence.setStartWith(sequence.getStartWith());
        xmlSequence.setIncrementBy(sequence.getIncrementBy());
        xmlSequence.setMaxValue(sequence.getMaxValue() == null ? "" : sequence.getMaxValue());
        xmlSequence.setMinValue(sequence.getMinValue() == null ? "" : sequence.getMinValue());
        xmlSequence.setCache(sequence.getCache() == null ? "" : sequence.getCache());
        xmlSequence.setUseCache(sequence.getCache() != null);
        xmlSequence.setCycle(sequence.isCycle());
        xmlSequence.setAdditionalSQLAfter("");
        xmlSequence.setAdditionalSQLBefore("");
        Properties props = this.getProperties(sequence);
        if (sequence.getSchema() != null && !sequence.getSchema().equals("public") && props.getProperty().stream().noneMatch(p -> "schema".equals(p.getName()))) {
            Property property = new Property();
            property.setName("schema");
            property.setValue(sequence.getSchema());
            props.getProperty().add(property);
        }
        xmlSequence.setProperties(props);
        xmlSequence.setDescription(sequence.getDescription() == null ? "" : sequence.getDescription());
        return xmlSequence;
    }

    private Counters buildXmlCounters() {
        Counters xmlCounters = new Counters();
        xmlCounters.getCounter().add(this.buildXmlCounter("table", "t", this.tableCount));
        xmlCounters.getCounter().add(this.buildXmlCounter("external_table", "et", this.externalTableCount));
        xmlCounters.getCounter().add(this.buildXmlCounter("column", "c", this.columnCount));
        xmlCounters.getCounter().add(this.buildXmlCounter("external_table_column", "etc", this.externalTableColumnCount));
        xmlCounters.getCounter().add(this.buildXmlCounter("index", "i", this.indexCount));
        xmlCounters.getCounter().add(this.buildXmlCounter("reference", "r", this.referenceCount));
        xmlCounters.getCounter().add(this.buildXmlCounter("table_check", "tc", this.tableCheckCount));
        xmlCounters.getCounter().add(this.buildXmlCounter("alternate_key", "a", this.alternateKeyCount));
        xmlCounters.getCounter().add(this.buildXmlCounter("sequence", "s", this.sequenceCount));
        xmlCounters.getCounter().add(this.buildXmlCounter("note", "n", 0L));
        xmlCounters.getCounter().add(this.buildXmlCounter("view", "v", this.viewCount));
        xmlCounters.getCounter().add(this.buildXmlCounter("materialized_view", "mv", this.materializedViewCount));
        xmlCounters.getCounter().add(this.buildXmlCounter("materialized_view_column", "mvc", this.materializedViewColumnCount));
        xmlCounters.getCounter().add(this.buildXmlCounter("area", "ar", 0L));
        xmlCounters.getCounter().add(this.buildXmlCounter("text", "tx", 0L));
        xmlCounters.getCounter().add(this.buildXmlCounter("view_column", "vc", this.viewColumnCount));
        xmlCounters.getCounter().add(this.buildXmlCounter("tableDisplay", "td", this.tableDisplayCount));
        xmlCounters.getCounter().add(this.buildXmlCounter("externalTableDisplay", "etd", this.externalTableDisplayCount));
        xmlCounters.getCounter().add(this.buildXmlCounter("viewDisplay", "vd", this.viewDisplayCount));
        xmlCounters.getCounter().add(this.buildXmlCounter("materializedViewDisplay", "mvd", this.materializedViewDisplayCount));
        xmlCounters.getCounter().add(this.buildXmlCounter("referenceDisplay", "rd", this.referenceDisplayCount));
        return xmlCounters;
    }

    private Counter buildXmlCounter(String name, String prefix, long value) {
        Counter c = new Counter();
        c.setName(name);
        c.setPrefix(prefix);
        c.setValue(new BigInteger("" + value));
        return c;
    }

    private References buildXmlReferences(Database database) {
        References xmlReferences = new References();
        Set<Reference> references = database.getReferences();
        for (Reference reference : references) {
            com.vertabelo.xml.model.Reference xmlReference = this.buildXmlReference(reference);
            xmlReferences.getReference().add(xmlReference);
            this.referenceToXmlReference.put(reference, xmlReference);
        }
        return xmlReferences;
    }

    private ReferenceDisplays buildXmlReferenceDisplays(Database database) {
        ReferenceDisplays xmlReferenceDisplays = new ReferenceDisplays();
        Set<Reference> references = database.getReferences();
        for (Reference reference : references) {
            ReferenceDisplayInfo xmlReferenceDisplay = this.buildXmlReferenceDisplay(reference);
            xmlReferenceDisplays.getReferenceDisplay().add(xmlReferenceDisplay);
        }
        return xmlReferenceDisplays;
    }

    private ReferenceDisplayInfo buildXmlReferenceDisplay(Reference reference) {
        ReferenceDisplayInfo xmlReferenceDisplayInfo = new ReferenceDisplayInfo();
        xmlReferenceDisplayInfo.setId(this.getNextReferenceDisplayId());
        xmlReferenceDisplayInfo.setColor(LINE_COLOR);
        xmlReferenceDisplayInfo.setType(ControlPointsType.VERTICAL_2_CP);
        xmlReferenceDisplayInfo.setControlPoints(this.objectFactory.createReferenceControlPoints());
        xmlReferenceDisplayInfo.getControlPoints().getControlPoint().add(new Point());
        xmlReferenceDisplayInfo.getControlPoints().getControlPoint().add(new Point());
        com.vertabelo.xml.model.Reference xmlReference = this.referenceToXmlReference.get(reference);
        xmlReferenceDisplayInfo.setReference(xmlReference);
        Table parentTable = reference.getParentTable();
        TableDisplayInfo xmlParentTableDisplay = this.tableToXmlTableDisplayInfo.get(parentTable);
        xmlReferenceDisplayInfo.setPkTableDisplay(xmlParentTableDisplay);
        Table childTable = reference.getChildTable();
        TableDisplayInfo xmlChildTableDisplay = this.tableToXmlTableDisplayInfo.get(childTable);
        xmlReferenceDisplayInfo.setFkTableDisplay(xmlChildTableDisplay);
        return xmlReferenceDisplayInfo;
    }

    private com.vertabelo.xml.model.Reference buildXmlReference(Reference reference) {
        com.vertabelo.xml.model.Reference xmlReference = new com.vertabelo.xml.model.Reference();
        xmlReference.setId(this.getNextReferenceId());
        if (reference.getName() != null) {
            xmlReference.setName(reference.getName());
        } else {
            xmlReference.setName("Reference_" + this.referenceCount);
        }
        xmlReference.setFKRole(reference.getChildRole() == null ? "" : reference.getChildRole());
        Table childTable = reference.getChildTable();
        com.vertabelo.xml.model.Table xmlFkTable = this.tableToXmlTable.get(childTable);
        xmlReference.setFKTable(xmlFkTable);
        xmlReference.setPKRole(reference.getParentRole() == null ? "" : reference.getParentRole());
        Table parentTable = reference.getParentTable();
        com.vertabelo.xml.model.Table xmlPkTable = this.tableToXmlTable.get(parentTable);
        xmlReference.setPKTable(xmlPkTable);
        xmlReference.setCardinality(reference.isOneToMany() ? ZERO_TO_MANY : ZERO_TO_ONE);
        xmlReference.setMandatory(reference.isMandatory());
        ReferenceColumns referenceColumns = this.buildXmlReferenceColumns(reference);
        xmlReference.setReferenceColumns(referenceColumns);
        ConstraintAction onDeleteAction = this.getConstraintAction(reference.getOnDeleteAction());
        xmlReference.setOnDeleteAction(onDeleteAction);
        ConstraintAction onUpdateAction = this.getConstraintAction(reference.getOnUpdateAction());
        xmlReference.setOnUpdateAction(onUpdateAction);
        xmlReference.setDescription(reference.getDescription() == null ? "" : reference.getDescription());
        xmlReference.setProperties(this.getProperties(reference));
        return xmlReference;
    }

    private ConstraintAction getConstraintAction(Integer onDeleteAction) {
        if (onDeleteAction == null) {
            return ConstraintAction.NONE;
        }
        switch (onDeleteAction) {
            case 0: {
                return ConstraintAction.CASCADE;
            }
            case 3: {
                return ConstraintAction.NONE;
            }
            case 1: {
                return ConstraintAction.RESTRICT;
            }
            case 4: {
                return ConstraintAction.SET_DEFAULT;
            }
            case 2: {
                return ConstraintAction.SET_NULL;
            }
        }
        return ConstraintAction.NONE;
    }

    private ReferenceColumns buildXmlReferenceColumns(Reference reference) {
        ReferenceColumns xmlReferenceColumns = new ReferenceColumns();
        List<ColumnPair> columnPairs = reference.getColumnPairs();
        for (ColumnPair columnPair : columnPairs) {
            ReferenceColumn xmlReferenceColumn = new ReferenceColumn();
            Column xmlChildColumn = this.columnToXmlColumn.get(columnPair.getChildColumn());
            xmlReferenceColumn.setFKColumn(xmlChildColumn);
            Column xmlParentColumn = this.columnToXmlColumn.get(columnPair.getParentColumn());
            xmlReferenceColumn.setPKColumn(xmlParentColumn);
            xmlReferenceColumns.getReferenceColumn().add(xmlReferenceColumn);
        }
        return xmlReferenceColumns;
    }

    public Tables buildXmlTables(Database database) {
        Tables tables = new Tables();
        for (Table table : database.getTables()) {
            com.vertabelo.xml.model.Table xmlTable = this.buildXmlTable(table);
            tables.getTable().add(xmlTable);
        }
        return tables;
    }

    public TableDisplays buildXmlTableDisplays(Database database) {
        TableDisplays tables = new TableDisplays();
        for (Table table : database.getTables()) {
            TableDisplayInfo xmlTableDisplay = this.buildXmlTableDisplayInfo(table);
            tables.getTableDisplay().add(xmlTableDisplay);
            this.tableToXmlTableDisplayInfo.put(table, xmlTableDisplay);
        }
        return tables;
    }

    public com.vertabelo.xml.model.Table buildXmlTable(Table table) {
        com.vertabelo.xml.model.Table xmlTable = new com.vertabelo.xml.model.Table();
        this.tableToXmlTable.put(table, xmlTable);
        String tableId = this.getNextTableId();
        xmlTable.setId(tableId);
        xmlTable.setName(table.getName());
        xmlTable.setDescription(table.getDescription() == null ? "" : table.getDescription());
        Columns xmlColumns = this.buildXmlColumns(table);
        xmlTable.setColumns(xmlColumns);
        AlternateKeys xmlAlternateKeys = this.buildXmlAlternateKeys(table);
        xmlTable.setAlternateKeys(xmlAlternateKeys);
        Indexes indexes = this.buildXmlIndexes(table);
        xmlTable.setIndexes(indexes);
        TableChecks tableChecks = this.buildXmlTableChecks(table);
        xmlTable.setTableChecks(tableChecks);
        xmlTable.setAdditionalSQLAfter("");
        xmlTable.setAdditionalSQLBefore("");
        Properties props = this.getProperties(table);
        if (table.getSchema() != null && !table.getSchema().equals("public") && props.getProperty().stream().noneMatch(p -> "schema".equals(p.getName()))) {
            Property property = new Property();
            property.setName("schema");
            property.setValue(table.getSchema());
            props.getProperty().add(property);
        }
        xmlTable.setProperties(props);
        Key primaryKey = table.getPrimaryKey();
        if (primaryKey != null) {
            xmlTable.setPrimaryKey(this.objectFactory.createPrimaryKey());
            xmlTable.getPrimaryKey().setName(primaryKey.getName());
            xmlTable.getPrimaryKey().setColumns(this.objectFactory.createPrimaryKeyColumns());
            for (com.vertabelo.xml.model_import.model.Column c : primaryKey.getColumns()) {
                Column xmlPkColumn = this.columnToXmlColumn.get(c);
                xmlTable.getPrimaryKey().getColumns().getColumn().add(this.objectFactory.createPrimaryKeyColumnsColumn(xmlPkColumn));
            }
        }
        return xmlTable;
    }

    public TableDisplayInfo buildXmlTableDisplayInfo(Table table) {
        TableDisplayInfo tableDisplayInfo = new TableDisplayInfo();
        com.vertabelo.xml.model.Table xmlTable = this.tableToXmlTable.get(table);
        tableDisplayInfo.setId(this.getNextTableDisplayId());
        tableDisplayInfo.setTable(xmlTable);
        tableDisplayInfo.setFillColor("#ffffff");
        tableDisplayInfo.setLineColor(LINE_COLOR);
        tableDisplayInfo.setHeight(90.0);
        tableDisplayInfo.setWidth(190.0);
        tableDisplayInfo.setX(1000.0);
        tableDisplayInfo.setY(1000.0);
        return tableDisplayInfo;
    }

    public TableChecks buildXmlTableChecks(Table table) {
        TableChecks xmlTableChecks = new TableChecks();
        Set<Check> tableChecks = table.getTableChecks();
        for (Check tableCheck : tableChecks) {
            TableCheck xmlTableCheck = new TableCheck();
            xmlTableCheck.setId(this.getNextTableCheckId());
            xmlTableCheck.setName(tableCheck.getName());
            xmlTableCheck.setCheckExpression(tableCheck.getExpression());
            xmlTableCheck.setDescription("");
            xmlTableCheck.setProperties(this.getProperties(tableCheck));
            xmlTableChecks.getTableCheck().add(xmlTableCheck);
        }
        return xmlTableChecks;
    }

    private Indexes buildXmlIndexes(Table table) {
        Indexes xmlIndexes = new Indexes();
        Set<Index> indexes = table.getIndexes();
        for (Index index : indexes) {
            com.vertabelo.xml.model.Index xmlIndex = this.buildXmlIndex(index);
            xmlIndexes.getIndex().add(xmlIndex);
        }
        return xmlIndexes;
    }

    private com.vertabelo.xml.model.Index buildXmlIndex(Index index) {
        com.vertabelo.xml.model.Index xmlIndex = new com.vertabelo.xml.model.Index();
        xmlIndex.setId(this.getNextIndexId());
        xmlIndex.setName(index.getName());
        xmlIndex.setProperties(this.getProperties(index));
        xmlIndex.setDescription("");
        List<IndexColumn> indexColumns = index.getColumns();
        xmlIndex.setColumns(this.objectFactory.createIndexColumns());
        for (IndexColumn indexColumn : indexColumns) {
            com.vertabelo.xml.model.IndexColumn xmlIndexColumn = new com.vertabelo.xml.model.IndexColumn();
            Column xmlColumn = this.columnToXmlColumn.get(indexColumn.getColumn());
            xmlIndexColumn.setColumn(xmlColumn);
            xmlIndexColumn.setAscending(indexColumn.isAscending());
            xmlIndex.getColumns().getColumn().add(xmlIndexColumn);
        }
        return xmlIndex;
    }

    private AlternateKeys buildXmlAlternateKeys(Table table) {
        AlternateKeys xmlAlternateKeys = new AlternateKeys();
        Set<Key> alternateKeys = table.getAlternateKeys();
        for (Key key : alternateKeys) {
            AlternateKey xmlAlternateKey = this.buildXmlAlternateKey(key);
            xmlAlternateKeys.getAlternateKey().add(xmlAlternateKey);
        }
        return xmlAlternateKeys;
    }

    private AlternateKey buildXmlAlternateKey(Key key) {
        AlternateKey xmlAlternateKey = new AlternateKey();
        xmlAlternateKey.setId(this.getNextAlternateKeyId());
        xmlAlternateKey.setName(key.getName());
        xmlAlternateKey.setProperties(this.getProperties(key));
        xmlAlternateKey.setDescription("");
        List<com.vertabelo.xml.model_import.model.Column> keyColumns = key.getColumns();
        AlternateKeyColumns xmlAlternateKeyColumn = new AlternateKeyColumns();
        xmlAlternateKey.setColumns(xmlAlternateKeyColumn);
        for (com.vertabelo.xml.model_import.model.Column column : keyColumns) {
            Column xmlColumn = this.columnToXmlColumn.get(column);
            xmlAlternateKeyColumn.getColumn().add(this.objectFactory.createAlternateKeyColumnsColumn(xmlColumn));
        }
        return xmlAlternateKey;
    }

    public ExternalTables buildXmlExternalTables(Database database) {
        ExternalTables tables = new ExternalTables();
        for (com.vertabelo.xml.model_import.model.ExternalTable table : database.getExternalTables()) {
            ExternalTable xmlTable = this.buildXmlExternalTable(table);
            tables.getExternalTable().add(xmlTable);
        }
        return tables;
    }

    public ExternalTableDisplays buildXmlExternalTableDisplays(Database database) {
        ExternalTableDisplays tables = new ExternalTableDisplays();
        for (com.vertabelo.xml.model_import.model.ExternalTable table : database.getExternalTables()) {
            ExternalTableDisplayInfo xmlTableDisplay = this.buildXmlExternalTableDisplayInfo(table);
            tables.getExternalTableDisplay().add(xmlTableDisplay);
            this.externalTableToXmlExternalTableDisplayInfo.put(table, xmlTableDisplay);
        }
        return tables;
    }

    public ExternalTable buildXmlExternalTable(com.vertabelo.xml.model_import.model.ExternalTable table) {
        ExternalTable xmlTable = new ExternalTable();
        this.externalTableToXmlExternalTable.put(table, xmlTable);
        String tableId = this.getNextExternalTableId();
        xmlTable.setId(tableId);
        xmlTable.setName(table.getName());
        xmlTable.setDescription(table.getDescription() == null ? "" : table.getDescription());
        ExternalTableColumns xmlColumns = this.buildXmlExternalTableColumns(table);
        xmlTable.setColumns(xmlColumns);
        xmlTable.setAdditionalSQLAfter("");
        xmlTable.setAdditionalSQLBefore("");
        xmlTable.setProperties(this.getProperties(table));
        ExternalTablePrimaryKey primaryKey = table.getPrimaryKey();
        if (primaryKey != null) {
            xmlTable.setPrimaryKey(this.objectFactory.createPrimaryKey());
            xmlTable.getPrimaryKey().setName(primaryKey.getName());
            xmlTable.getPrimaryKey().setColumns(this.objectFactory.createPrimaryKeyColumns());
            for (com.vertabelo.xml.model_import.model.ExternalTableColumn c : primaryKey.getColumns()) {
                ExternalTableColumn xmlPkColumn = this.externalTableColumnToXmlExternalTableColumn.get(c);
                xmlTable.getPrimaryKey().getColumns().getColumn().add(this.objectFactory.createPrimaryKeyColumnsColumn(xmlPkColumn));
            }
        }
        return xmlTable;
    }

    public ExternalTableDisplayInfo buildXmlExternalTableDisplayInfo(com.vertabelo.xml.model_import.model.ExternalTable table) {
        ExternalTableDisplayInfo tableDisplayInfo = new ExternalTableDisplayInfo();
        ExternalTable xmlTable = this.externalTableToXmlExternalTable.get(table);
        tableDisplayInfo.setId(this.getNextExternalTableDisplayId());
        tableDisplayInfo.setExternalTable(xmlTable);
        tableDisplayInfo.setFillColor("#ffffff");
        tableDisplayInfo.setLineColor(LINE_COLOR);
        tableDisplayInfo.setHeight(90.0);
        tableDisplayInfo.setWidth(190.0);
        tableDisplayInfo.setX(1000.0);
        tableDisplayInfo.setY(1000.0);
        return tableDisplayInfo;
    }

    private ExternalTableColumns buildXmlExternalTableColumns(com.vertabelo.xml.model_import.model.ExternalTable table) {
        ExternalTableColumns xmlColumns = new ExternalTableColumns();
        List<com.vertabelo.xml.model_import.model.ExternalTableColumn> columns = table.getColumns();
        for (com.vertabelo.xml.model_import.model.ExternalTableColumn column : columns) {
            ExternalTableColumn xmlColumn = this.buildXmlExternalTableColumn(column);
            xmlColumns.getExternalTableColumn().add(xmlColumn);
        }
        return xmlColumns;
    }

    private ExternalTableColumn buildXmlExternalTableColumn(com.vertabelo.xml.model_import.model.ExternalTableColumn column) {
        ExternalTableColumn xmlColumn = new ExternalTableColumn();
        this.externalTableColumnToXmlExternalTableColumn.put(column, xmlColumn);
        String columnId = this.getNextExternalTableColumnId();
        xmlColumn.setId(columnId);
        xmlColumn.setName(column.getName());
        xmlColumn.setType(column.getTypeName());
        xmlColumn.setNullable(column.isNullable());
        xmlColumn.setProperties(this.getProperties(column));
        return xmlColumn;
    }

    private String getNextExternalTableId() {
        ++this.externalTableCount;
        return "et" + this.externalTableCount;
    }

    private String getNextExternalTableDisplayId() {
        ++this.externalTableDisplayCount;
        return "etd" + this.externalTableDisplayCount;
    }

    private String getNextExternalTableColumnId() {
        ++this.externalTableColumnCount;
        return "etc" + this.externalTableColumnCount;
    }

    private Columns buildXmlColumns(Table table) {
        Columns xmlColumns = new Columns();
        List<com.vertabelo.xml.model_import.model.Column> columns = table.getColumns();
        for (com.vertabelo.xml.model_import.model.Column column : columns) {
            Column xmlColumn = this.buildXmlColumn(column);
            xmlColumns.getColumn().add(xmlColumn);
        }
        return xmlColumns;
    }

    private Column buildXmlColumn(com.vertabelo.xml.model_import.model.Column column) {
        Column xmlColumn = new Column();
        this.columnToXmlColumn.put(column, xmlColumn);
        String columnId = this.getNextColumnId();
        xmlColumn.setId(columnId);
        xmlColumn.setName(column.getName());
        xmlColumn.setType(column.getTypeName());
        xmlColumn.setNullable(column.isNullable());
        xmlColumn.setDefaultValue(column.getDefaultValue() == null ? "" : column.getDefaultValue());
        xmlColumn.setDescription(column.getDescription() == null ? "" : column.getDescription());
        xmlColumn.setCheckExpression("");
        xmlColumn.setProperties(this.getProperties(column));
        return xmlColumn;
    }

    private String getNextTableId() {
        ++this.tableCount;
        return "t" + this.tableCount;
    }

    private String getNextTableDisplayId() {
        ++this.tableDisplayCount;
        return "td" + this.tableDisplayCount;
    }

    private String getNextViewId() {
        ++this.viewCount;
        return "v" + this.viewCount;
    }

    private String getNextViewDisplayId() {
        ++this.viewDisplayCount;
        return "vd" + this.viewDisplayCount;
    }

    private String getNextMaterializedViewId() {
        ++this.materializedViewCount;
        return "mv" + this.materializedViewCount;
    }

    private String getNextMaterializedViewDisplayId() {
        ++this.materializedViewDisplayCount;
        return "mvd" + this.materializedViewDisplayCount;
    }

    private String getNextColumnId() {
        ++this.columnCount;
        return "c" + this.columnCount;
    }

    private String getNextAlternateKeyId() {
        ++this.alternateKeyCount;
        return "a" + this.alternateKeyCount;
    }

    private String getNextReferenceId() {
        ++this.referenceCount;
        return "r" + this.referenceCount;
    }

    private String getNextReferenceDisplayId() {
        ++this.referenceDisplayCount;
        return "rd" + this.referenceDisplayCount;
    }

    private String getNextIndexId() {
        ++this.indexCount;
        return "i" + this.indexCount;
    }

    private String getNextTableCheckId() {
        ++this.tableCheckCount;
        return "tc" + this.tableCheckCount;
    }

    private String getNextSequenceId() {
        ++this.sequenceCount;
        return "s" + this.sequenceCount;
    }

    private String getNextViewColumnId() {
        ++this.viewColumnCount;
        return "vc" + this.viewColumnCount;
    }

    private String getNextMaterializedViewColumnId() {
        ++this.materializedViewColumnCount;
        return "mvc" + this.materializedViewColumnCount;
    }

    private Properties getProperties(DatabaseObject object) {
        Properties xmlProperties = new Properties();
        for (Map.Entry<String, String> additionalProperty : object.getAdditionalProperties().entrySet()) {
            Property xmlProperty = new Property();
            xmlProperty.setName(additionalProperty.getKey());
            xmlProperty.setValue(additionalProperty.getValue());
            xmlProperties.getProperty().add(xmlProperty);
        }
        return xmlProperties;
    }
}

