/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool;

import com.vertabelo.autolayout_tool.algorithm.NodeAutolayout;
import com.vertabelo.autolayout_tool.graph.ConnectedGraph;
import com.vertabelo.autolayout_tool.graph.Edge;
import com.vertabelo.autolayout_tool.graph.EdgeView;
import com.vertabelo.autolayout_tool.graph.Graph;
import com.vertabelo.autolayout_tool.graph.GraphBuilder;
import com.vertabelo.autolayout_tool.graph.NPoint;
import com.vertabelo.autolayout_tool.graph.Node;
import com.vertabelo.autolayout_tool.graph.NodeView;
import com.vertabelo.autolayout_tool.util.DatabaseModelCloner;
import com.vertabelo.autolayout_tool.util.GraphConverter;
import com.vertabelo.autolayout_tool.util.GraphRaw;
import com.vertabelo.xml.model.DatabaseModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AutolayoutRunner {
    static final int WORKSPACE_SIZE = 14142;
    private static final int PADDING = 5;
    private final NodeAutolayout algorithm;
    private final GraphConverter graphConverter;

    public AutolayoutRunner(NodeAutolayout algorithm) {
        this.algorithm = algorithm;
        this.graphConverter = new GraphConverter();
    }

    public Graph run(Graph graph) {
        this.doAlgorithmForSplittedGraph(graph);
        this.scaleToWorkspace(graph);
        this.placeToMiddle(graph);
        return graph;
    }

    public DatabaseModel run(DatabaseModel databaseModel) {
        DatabaseModel model = DatabaseModelCloner.INSTANCE.clone(databaseModel);
        Graph inGraph = this.graphConverter.toGraph(model);
        Graph outGraph = this.run(inGraph);
        return this.graphConverter.toModel(outGraph, model);
    }

    public GraphRaw run(GraphRaw graphRaw) {
        Graph inGraph = this.graphConverter.fromRawGraph(graphRaw);
        Graph outGraph = this.run(inGraph);
        return this.graphConverter.toRawGraph(outGraph);
    }

    private void doAlgorithmForSplittedGraph(Graph graph) {
        List<ConnectedGraph> parts = new GraphBuilder().graph(graph).buildConnected();
        ArrayList<Graph> formated = new ArrayList<Graph>();
        double highest = 0.0;
        double widest = 0.0;
        for (Graph graph2 : parts) {
            if (!graph2.getEdges().isEmpty()) {
                formated.add(this.algorithm.relocate(graph2));
            }
            highest = Math.max(graph2.height(), highest);
            widest = Math.max(graph2.width(), widest);
        }
        for (Graph graph3 : parts) {
            if (graph3.width() > 14142.0) {
                graph3.scale(14142.0 / graph3.width(), 1.0);
            }
            if (!(graph3.height() > 14142.0)) continue;
            graph3.scale(1.0, 14142.0 / graph3.height());
        }
        double maxWidth = Math.min(widest, 14142.0);
        Collections.sort(parts, (g1, g2) -> {
            if (Math.abs(g1.height() - g2.height()) < 0.01) {
                return 0;
            }
            if (g1.height() < g2.height()) {
                return 1;
            }
            return -1;
        });
        int startX = 0;
        int startY = 0;
        double lastRowY = 0.0;
        for (Graph graph4 : parts) {
            if (startX > 14142) {
                startX = 0;
            }
            if (graph4.width() + (double)startX + 5.0 < maxWidth) {
                graph4.translate(startX, startY);
                startX = (int)((double)startX + (graph4.width() + 5.0));
                lastRowY = Math.max(lastRowY, graph4.height());
                continue;
            }
            if ((startY = (int)((double)startY + (lastRowY + 5.0))) > 14142) {
                startY = 0;
            }
            startX = 0;
            graph4.translate(startX, startY);
            startX = (int)((double)startX + graph4.width());
            lastRowY = graph4.height();
        }
    }

    private void scaleToWorkspace(Graph graph) {
        double minX = graph.minX();
        double maxX = graph.maxX();
        double minY = graph.minY();
        double maxY = graph.maxY();
        double width = maxX - minX;
        double height = maxY - minY;
        double scaleX = 1.0;
        double scaleY = 1.0;
        if (width > 14142.0) {
            scaleX = 14142.0 / width;
        }
        if (height > 14142.0) {
            scaleY = 14142.0 / height;
        }
        graph.scale(scaleX, scaleY);
    }

    private void placeToMiddle(Graph graph) {
        double minX = graph.minX();
        double maxX = graph.maxX();
        double minY = graph.minY();
        double maxY = graph.maxY();
        double moveX = Math.max((14142.0 - (maxX - minX)) / 2.0 - minX, 0.0 - minX);
        double moveY = Math.max((14142.0 - (maxY - minY)) / 2.0 - minY, 0.0 - minY);
        for (Node node : graph.getNodes()) {
            NodeView view = node.nodeView();
            view.setX(view.getX() + (double)((int)moveX) + 1.0);
            view.setY(view.getY() + (double)((int)moveY) + 1.0);
        }
        for (Edge edge : graph.getEdges()) {
            EdgeView edgeView = edge.getEdgeView();
            for (NPoint point : edgeView.getPoints()) {
                point.setX(point.getX() + moveX);
                point.setY(point.getY() + moveY);
            }
        }
    }
}

