/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool;

import com.vertabelo.autolayout_tool.AutolayoutRunner;
import com.vertabelo.autolayout_tool.algorithm.mps.MpsLayout;
import com.vertabelo.xml.model.DatabaseModel;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.io.IOException;

public class StandaloneAutolayout {
    public static void main(String[] args) throws JAXBException {
        if (args.length < 1) {
            throw new IllegalArgumentException("Parameter expected");
        }
        String filePath = args[0];
        File input = new File(filePath);
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{DatabaseModel.class});
        Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
        DatabaseModel databaseModel = (DatabaseModel)jaxbUnmarshaller.unmarshal(input);
        MpsLayout nodeAutolayout = new MpsLayout();
        AutolayoutRunner autolayoutRunner = new AutolayoutRunner(nodeAutolayout);
        databaseModel = autolayoutRunner.run(databaseModel);
        File output = new File(input.getPath().replace(".xml", "-" + nodeAutolayout.name() + ".xml"));
        output.delete();
        try {
            output.createNewFile();
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            jaxbMarshaller.marshal((Object)databaseModel, output);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot create file with output" + e.getMessage(), e);
        }
    }
}

