/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool;

import com.vertabelo.autolayout_tool.graph.Graph;
import com.vertabelo.autolayout_tool.util.GraphConverter;
import com.vertabelo.autolayout_tool.util.GraphRaw;
import com.vertabelo.xml.model.DatabaseModel;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;

public class XmlToRawGraph {
    public static void main(String[] args) throws JAXBException {
        if (args.length < 1) {
            throw new IllegalArgumentException("Parameter expected");
        }
        String filePath = args[0];
        File input = new File(filePath);
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{DatabaseModel.class});
        Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
        DatabaseModel databaseModel = (DatabaseModel)jaxbUnmarshaller.unmarshal(input);
        GraphConverter graphConverter = new GraphConverter();
        Graph graph = graphConverter.toGraph(databaseModel);
        GraphRaw rawGraph = graphConverter.toRawGraph(graph);
        String json = rawGraph.toJSON();
        System.out.print(json);
    }
}

