/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.algorithm;

import com.vertabelo.autolayout_tool.algorithm.RandomEdgeLocator;
import com.vertabelo.autolayout_tool.graph.Edge;
import com.vertabelo.autolayout_tool.graph.EdgeType;
import com.vertabelo.autolayout_tool.graph.EdgeView;
import com.vertabelo.autolayout_tool.graph.NPoint;
import com.vertabelo.autolayout_tool.util.DefaultTimeManager;
import java.util.List;
import java.util.Optional;

public class EdgeViewGenerator {
    private final RandomEdgeLocator randomEdgeLocator = new RandomEdgeLocator(new DefaultTimeManager());

    public EdgeView findView(Edge edge, List<NPoint> points) {
        Optional<EdgeType> type = this.figureOutType(edge, points);
        if (type.isPresent()) {
            return new EdgeView(type.get(), points);
        }
        return this.randomEdgeLocator.getEdgeView(edge);
    }

    public Optional<EdgeType> figureOutType(Edge edge, List<NPoint> points) {
        if (edge.getPk().equals(edge.getFk())) {
            if (points.size() == 4) {
                return Optional.of(EdgeType.SELF_4_CP);
            }
            if (points.size() == 5) {
                return Optional.of(EdgeType.SELF_5_CP);
            }
        }
        if (points.size() == 2) {
            if ((int)points.get(0).getX() == (int)points.get(1).getX()) {
                return Optional.of(EdgeType.VERTICAL_2_CP);
            }
            return Optional.of(EdgeType.HORIZONTAL_2_CP);
        }
        if (points.size() == 3) {
            return Optional.of(EdgeType.CROSS_3_CP);
        }
        if (points.size() == 4) {
            if ((int)points.get(0).getX() == (int)points.get(1).getX()) {
                return Optional.of(EdgeType.VERTICAL_4_CP);
            }
            return Optional.of(EdgeType.HORIZONTAL_4_CP);
        }
        return Optional.empty();
    }
}

