/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.algorithm;

import com.vertabelo.autolayout_tool.graph.Edge;
import com.vertabelo.autolayout_tool.graph.EdgeType;
import com.vertabelo.autolayout_tool.graph.EdgeView;
import com.vertabelo.autolayout_tool.graph.Graph;
import com.vertabelo.autolayout_tool.graph.NPoint;
import com.vertabelo.autolayout_tool.graph.NodeView;
import com.vertabelo.autolayout_tool.util.TimeManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class RandomEdgeLocator {
    private static final int PADDING = 10;
    private final TimeManager timeManager;

    public RandomEdgeLocator(TimeManager timeManager) {
        this.timeManager = timeManager;
    }

    public Map<String, EdgeView> relocateEdges(Graph graph) {
        HashMap<String, EdgeView> edgeViews = new HashMap<String, EdgeView>();
        for (Edge edge : graph.getEdges()) {
            edgeViews.put(edge.getId(), this.getEdgeView(edge));
        }
        return edgeViews;
    }

    public EdgeView getEdgeView(Edge edge) {
        EdgeView edgeView;
        if (edge.getPk().equals(edge.getFk())) {
            NodeView view = edge.getPk().nodeView();
            NPoint middlePoint = view.getMiddle();
            ArrayList<NPoint> controlPoints = new ArrayList<NPoint>();
            NPoint[] points = new NPoint[5];
            for (int i = 0; i < points.length; ++i) {
                points[i] = new NPoint();
                controlPoints.add(points[i]);
            }
            int PADDING = 15;
            points[0].setX(middlePoint.getX());
            points[0].setY(middlePoint.getY() - 5.0);
            points[1].setX(view.getX() + (double)view.getWidth() + (double)PADDING);
            points[1].setY(points[0].getY());
            points[2].setX(points[1].getX());
            points[2].setY(view.getY() - (double)PADDING);
            points[3].setX(middlePoint.getX());
            points[3].setY(points[2].getY());
            points[4].setX(middlePoint.getX());
            points[4].setY(middlePoint.getY() + 5.0);
            return new EdgeView(EdgeType.SELF_5_CP, controlPoints);
        }
        NodeView pkNodeView = edge.getPk().nodeView();
        NodeView fkNodeView = edge.getFk().nodeView();
        double pkMinX = pkNodeView.getX();
        double pkMaxX = pkNodeView.getX() + (double)pkNodeView.getWidth();
        double pkMinY = pkNodeView.getY();
        double pkMaxY = pkNodeView.getY() + (double)pkNodeView.getHeight();
        double fkMinX = fkNodeView.getX();
        double fkMaxX = fkNodeView.getX() + (double)fkNodeView.getWidth();
        double fkMinY = fkNodeView.getY();
        double fkMaxY = fkNodeView.getY() + (double)fkNodeView.getHeight();
        Random random = new Random(this.timeManager.getCurrentTimeMillis());
        ArrayList<NPoint> controlPoints = new ArrayList<NPoint>();
        if (Math.max(fkMinX, pkMinX) + 10.0 < Math.min(fkMaxX, pkMaxX)) {
            double startX = Math.max(fkMinX, pkMinX);
            double endX = Math.min(fkMaxX, pkMaxX);
            double x = (double)random.nextInt((int)(endX - startX)) + startX;
            if (this.isIntegral(x)) {
                x += 0.5;
            }
            this.make2CPForX(pkNodeView, fkNodeView, controlPoints, x);
            edgeView = new EdgeView(EdgeType.VERTICAL_2_CP, controlPoints);
        } else if (Math.max(fkMinY, pkMinY) + 10.0 < Math.min(fkMaxY, pkMaxY)) {
            double startY = Math.max(fkMinY, pkMinY);
            double endY = Math.min(fkMaxY, pkMaxY);
            double y = (double)random.nextInt((int)(endY - startY)) + startY;
            if (this.isIntegral(y)) {
                y += 0.5;
            }
            this.make2CPForY(pkNodeView, fkNodeView, controlPoints, y);
            edgeView = new EdgeView(EdgeType.HORIZONTAL_2_CP, controlPoints);
        } else {
            NPoint fkPoint = new NPoint();
            NPoint pkPoint = new NPoint();
            NPoint middlePoint = new NPoint();
            pkPoint.setX(pkNodeView.getX() + (double)random.nextInt(pkNodeView.getWidth()));
            pkPoint.setY(pkNodeView.getY() + (double)random.nextInt(pkNodeView.getHeight()));
            fkPoint.setX(fkNodeView.getX() + (double)random.nextInt(fkNodeView.getWidth()));
            fkPoint.setY(fkNodeView.getY() + (double)random.nextInt(fkNodeView.getHeight()));
            middlePoint.setX(fkPoint.getX());
            middlePoint.setY(pkPoint.getY());
            controlPoints.add(pkPoint);
            controlPoints.add(middlePoint);
            controlPoints.add(fkPoint);
            edgeView = new EdgeView(EdgeType.CROSS_3_CP, controlPoints);
        }
        return edgeView;
    }

    private boolean isIntegral(double val) {
        return val == Math.floor(val) && !Double.isInfinite(val);
    }

    private void make2CPForX(NodeView pkNode, NodeView fkNode, List<NPoint> controlPoints, double x) {
        NPoint fkPoint = new NPoint();
        NPoint pkPoint = new NPoint();
        fkPoint.setX(x);
        fkPoint.setY(fkNode.getY() + (double)fkNode.getHeight() / 2.0);
        pkPoint.setX(x);
        pkPoint.setY(pkNode.getY() + (double)pkNode.getHeight() / 2.0);
        controlPoints.add(pkPoint);
        controlPoints.add(fkPoint);
    }

    private void make2CPForY(NodeView pkNode, NodeView fkNode, List<NPoint> controlPoints, double y) {
        NPoint fkPoint = new NPoint();
        NPoint pkPoint = new NPoint();
        fkPoint.setX(fkNode.getX() + (double)fkNode.getWidth() / 2.0);
        fkPoint.setY(y);
        pkPoint.setX(pkNode.getX() + (double)pkNode.getWidth() / 2.0);
        pkPoint.setY(y);
        controlPoints.add(pkPoint);
        controlPoints.add(fkPoint);
    }
}

