/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.algorithm.mps;

import com.vertabelo.autolayout_tool.algorithm.EdgeViewGenerator;
import com.vertabelo.autolayout_tool.algorithm.NodeAutolayout;
import com.vertabelo.autolayout_tool.graph.Edge;
import com.vertabelo.autolayout_tool.graph.EdgeView;
import com.vertabelo.autolayout_tool.graph.NPoint;
import com.vertabelo.autolayout_tool.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.com.google.common.base.Preconditions;
import com.vertabelo.autolayout_tool.repackaged.javaslang.Tuple;
import com.vertabelo.autolayout_tool.repackaged.javaslang.Tuple2;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.flowOrthogonalLayout.OrthogonalFlowLayouter;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.IEdge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.INode;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.GraphLayout;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.LayoutInfo;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Dimension;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Point;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;

public class MpsLayout
implements NodeAutolayout {
    public static final int PADDING = 10;

    @Override
    public com.vertabelo.autolayout_tool.graph.Graph relocate(com.vertabelo.autolayout_tool.graph.Graph graph) {
        Graph converted = new Graph();
        HashMap<String, Integer> nodeIdToIndex = new HashMap<String, Integer>();
        for (Node node : graph.getNodes()) {
            com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node node2 = converted.createNode();
            int index = node2.getIndex();
            nodeIdToIndex.put(node.getId(), index);
        }
        ArrayList<Node> selfLoopsNodes = new ArrayList<Node>();
        for (Edge edge : graph.getEdges()) {
            if (this.isSelfLoopEdge(edge)) {
                selfLoopsNodes.add(edge.getFk());
                continue;
            }
            com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node source = converted.getNode((Integer)nodeIdToIndex.get(edge.getPk().getId()));
            com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node target = converted.getNode((Integer)nodeIdToIndex.get(edge.getFk().getId()));
            converted.connect(source, target);
        }
        LayoutInfo layoutInfo = new LayoutInfo(converted);
        for (Node node : graph.getNodes()) {
            layoutInfo.setNodeSize(converted.getNode((Integer)nodeIdToIndex.get(node.getId())), new Dimension(node.nodeView().getWidth() - 20, node.nodeView().getHeight() - 20));
        }
        for (com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge edge : converted.getEdges()) {
            layoutInfo.setLabelSize(edge, new Dimension(20, 20));
        }
        OrthogonalFlowLayouter orthogonalFlowLayouter = new OrthogonalFlowLayouter();
        GraphLayout graphLayout = orthogonalFlowLayouter.doLayout(layoutInfo);
        Map<IEdge, List<Point>> edgeMap = graphLayout.getEdgeLayout();
        Map<INode, Rectangle> nodeMap = graphLayout.getNodeLayout();
        for (Node node : graph.getNodes()) {
            Integer inodeIndex = (Integer)nodeIdToIndex.get(node.getId());
            com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node iNode = converted.getNode(inodeIndex);
            Rectangle rectangle = nodeMap.get(iNode);
            node.nodeView().setHeight(rectangle.height + 20);
            node.nodeView().setWidth(rectangle.width + 20);
            node.nodeView().setX((double)rectangle.x - 10.0);
            node.nodeView().setY((double)rectangle.y - 10.0);
        }
        Preconditions.checkArgument(edgeMap.size() + selfLoopsNodes.size() == graph.getEdges().size());
        EdgeViewGenerator generator = new EdgeViewGenerator();
        HashMap<Tuple2<Integer, Integer>, LinkedList<List<Point>>> sourceTargetEdges = new HashMap<Tuple2<Integer, Integer>, LinkedList<List<Point>>>();
        for (Map.Entry<IEdge, List<Point>> entry : edgeMap.entrySet()) {
            com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node sourceNode = (com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node)entry.getKey().getSource();
            com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node targetNode = (com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node)entry.getKey().getTarget();
            Tuple2<Integer, Integer> index = Tuple.of(sourceNode.getIndex(), targetNode.getIndex());
            LinkedList<List<Point>> list = (LinkedList<List<Point>>)sourceTargetEdges.get(index);
            if (list == null) {
                list = new LinkedList<List<Point>>();
                sourceTargetEdges.put(index, list);
            }
            list.add(entry.getValue());
        }
        for (Edge edge : graph.getEdges()) {
            List<NPoint> points = new ArrayList<NPoint>();
            if (!this.isSelfLoopEdge(edge)) {
                com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node sourceNode = converted.getNode((Integer)nodeIdToIndex.get(edge.getPk().getId()));
                com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node targetNode = converted.getNode((Integer)nodeIdToIndex.get(edge.getFk().getId()));
                Tuple2<Integer, Integer> key = Tuple.of(sourceNode.getIndex(), targetNode.getIndex());
                Queue listOfpoints = (Queue)sourceTargetEdges.get(key);
                List layoutPoints = (List)listOfpoints.poll();
                points = layoutPoints.stream().map(point -> new NPoint(point.x, point.y)).toList();
            }
            EdgeView edgeView = generator.findView(edge, points);
            edge.setEdgeView(edgeView);
        }
        return graph;
    }

    private boolean isSelfLoopEdge(Edge edge) {
        return edge.getFk().equals(edge.getPk());
    }

    @Override
    public String name() {
        return "mps";
    }
}

