/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.graph;

import com.vertabelo.autolayout_tool.graph.Edge;
import com.vertabelo.autolayout_tool.graph.EdgeView;
import com.vertabelo.autolayout_tool.graph.NPoint;
import com.vertabelo.autolayout_tool.graph.Node;
import com.vertabelo.autolayout_tool.graph.NodeView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Graph {
    private Map<String, Node> nodes;
    private Map<String, Edge> edges;

    Graph(Collection<Node> nodes, Collection<Edge> edges) {
        HashMap<String, Node> nodesMap = new HashMap<String, Node>();
        for (Node node : nodes) {
            nodesMap.put(node.getId(), node);
        }
        this.nodes = nodesMap;
        this.edges = new HashMap<String, Edge>();
        for (Edge edge : edges) {
            this.edges.put(edge.getId(), edge);
        }
    }

    public List<Node> getNodes() {
        return new ArrayList<Node>(this.nodes.values());
    }

    public Node findNode(String id) {
        return this.nodes.get(id);
    }

    public Edge findEdge(String uId, String vId) {
        for (Edge edge : this.getEdges()) {
            if (!edge.getPk().getId().equals(uId) || !edge.getFk().getId().equals(vId)) continue;
            return edge;
        }
        return null;
    }

    public double minX() {
        double res = Double.MAX_VALUE;
        for (Node node : this.nodes.values()) {
            NodeView view = node.nodeView();
            res = Math.min(view.getX(), res);
        }
        return res;
    }

    public double minY() {
        double res = Double.MAX_VALUE;
        for (Node node : this.nodes.values()) {
            NodeView view = node.nodeView();
            res = Math.min(view.getY(), res);
        }
        return res;
    }

    public double maxX() {
        double res = -1.7976931348623157E308;
        for (Node node : this.nodes.values()) {
            NodeView view = node.nodeView();
            res = Math.max(view.getX() + (double)view.getWidth(), res);
        }
        return res;
    }

    public double maxY() {
        double res = -1.7976931348623157E308;
        for (Node node : this.nodes.values()) {
            NodeView view = node.nodeView();
            res = Math.max(view.getY() + (double)view.getHeight(), res);
        }
        return res;
    }

    public double width() {
        return this.maxX() - this.minX();
    }

    public double height() {
        return this.maxY() - this.minY();
    }

    public Collection<Edge> getEdges() {
        return this.edges.values();
    }

    public Edge getEdgeById(String id) {
        return this.edges.get(id);
    }

    public String toString() {
        return "Graph{nodes=" + String.valueOf(this.nodes) + ", edges=" + String.valueOf(this.edges) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Graph graph = (Graph)o;
        if (this.nodes != null ? !this.nodes.equals(graph.nodes) : graph.nodes != null) {
            return false;
        }
        return this.edges != null ? this.edges.equals(graph.edges) : graph.edges == null;
    }

    public int hashCode() {
        int result = this.nodes != null ? this.nodes.hashCode() : 0;
        result = 31 * result + (this.edges != null ? this.edges.hashCode() : 0);
        return result;
    }

    public void translate(int x, int y) {
        double _minX = this.minX();
        double _minY = this.minY();
        double diffX = (double)x - _minX;
        double diffY = (double)y - _minY;
        for (Node node : this.nodes.values()) {
            NodeView view = node.nodeView();
            view.setX(view.getX() + diffX);
            view.setY(view.getY() + diffY);
        }
        for (Edge edge : this.getEdges()) {
            EdgeView edgeView = edge.getEdgeView();
            for (NPoint point : edgeView.getPoints()) {
                point.setX(point.getX() + diffX);
                point.setY(point.getY() + diffY);
            }
        }
    }

    public void scale(double x, double y) {
        double _minX = this.minX();
        double _minY = this.minY();
        for (Node node : this.nodes.values()) {
            NodeView view = node.nodeView();
            view.setX((view.getX() - _minX) * x + _minX);
            view.setY((view.getY() - _minY) * y + _minY);
        }
        for (Edge edge : this.getEdges()) {
            EdgeView edgeView = edge.getEdgeView();
            for (NPoint point : edgeView.getPoints()) {
                point.setX((point.getX() - _minX) * x + _minX);
                point.setY((point.getY() - _minY) * y + _minY);
            }
        }
    }
}

