/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.graph;

import com.vertabelo.autolayout_tool.graph.ConnectedGraph;
import com.vertabelo.autolayout_tool.graph.Edge;
import com.vertabelo.autolayout_tool.graph.Graph;
import com.vertabelo.autolayout_tool.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class GraphBuilder {
    Collection<Node> nodes;
    Collection<Edge> edges;

    public GraphBuilder nodes(Collection<Node> nodes) {
        this.nodes = nodes;
        return this;
    }

    public GraphBuilder edges(Collection<Edge> edges) {
        this.edges = edges;
        return this;
    }

    public GraphBuilder graph(Graph graph) {
        this.nodes = graph.getNodes();
        this.edges = graph.getEdges();
        return this;
    }

    public Graph buildNormal() {
        Preconditions.checkNotNull(this.nodes);
        Preconditions.checkNotNull(this.edges);
        return new Graph(this.nodes, this.edges);
    }

    public List<ConnectedGraph> buildConnected() {
        return this.findConnected();
    }

    private List<ConnectedGraph> findConnected() {
        HashMap<String, List<Edge>> edgesFromNode = new HashMap<String, List<Edge>>();
        for (Node node : this.nodes) {
            edgesFromNode.put(node.getId(), new ArrayList());
        }
        for (Edge edge : this.edges) {
            this.addEdge(edgesFromNode, edge, edge.getFk());
            this.addEdge(edgesFromNode, edge, edge.getPk());
        }
        HashMap<String, Boolean> visited = new HashMap<String, Boolean>();
        for (Node node : this.nodes) {
            visited.put(node.getId(), false);
        }
        ArrayList<ConnectedGraph> arrayList = new ArrayList<ConnectedGraph>();
        for (Node node : this.nodes) {
            if (((Boolean)visited.get(node.getId())).booleanValue()) continue;
            LinkedList<Node> candidates = new LinkedList<Node>();
            candidates.add(node);
            visited.put(node.getId(), true);
            ArrayList<Node> componentNodes = new ArrayList<Node>();
            ArrayList<Edge> componentEdges = new ArrayList<Edge>();
            while (!candidates.isEmpty()) {
                Node top = (Node)candidates.removeFirst();
                componentNodes.add(top);
                for (Edge edge : (List)edgesFromNode.get(top.getId())) {
                    Node to;
                    Node node2 = to = top.equals(edge.getPk()) ? edge.getFk() : edge.getPk();
                    if (edge.getPk().equals(top)) {
                        componentEdges.add(edge);
                    }
                    if (((Boolean)visited.get(to.getId())).booleanValue()) continue;
                    visited.put(to.getId(), true);
                    candidates.addLast(to);
                }
            }
            arrayList.add(new ConnectedGraph((Collection<Node>)componentNodes, (List<Edge>)componentEdges));
        }
        return arrayList;
    }

    private void addEdge(Map<String, List<Edge>> edgesFromNode, Edge edge, Node to) {
        List<Edge> edgesFromNodeU = edgesFromNode.get(to.getId());
        edgesFromNodeU.add(edge);
    }
}

