/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.javaslang;

import com.vertabelo.autolayout_tool.repackaged.javaslang.Tuple2;
import com.vertabelo.autolayout_tool.repackaged.javaslang.ValueModule;
import com.vertabelo.autolayout_tool.repackaged.javaslang.collection.Array;
import com.vertabelo.autolayout_tool.repackaged.javaslang.collection.CharSeq;
import com.vertabelo.autolayout_tool.repackaged.javaslang.collection.HashMap;
import com.vertabelo.autolayout_tool.repackaged.javaslang.collection.HashSet;
import com.vertabelo.autolayout_tool.repackaged.javaslang.collection.Iterator;
import com.vertabelo.autolayout_tool.repackaged.javaslang.collection.List;
import com.vertabelo.autolayout_tool.repackaged.javaslang.collection.Map;
import com.vertabelo.autolayout_tool.repackaged.javaslang.collection.Queue;
import com.vertabelo.autolayout_tool.repackaged.javaslang.collection.Set;
import com.vertabelo.autolayout_tool.repackaged.javaslang.collection.Stack;
import com.vertabelo.autolayout_tool.repackaged.javaslang.collection.Stream;
import com.vertabelo.autolayout_tool.repackaged.javaslang.collection.Tree;
import com.vertabelo.autolayout_tool.repackaged.javaslang.collection.Vector;
import com.vertabelo.autolayout_tool.repackaged.javaslang.control.Either;
import com.vertabelo.autolayout_tool.repackaged.javaslang.control.Option;
import com.vertabelo.autolayout_tool.repackaged.javaslang.control.Try;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;

public interface Value<T>
extends Iterable<T> {
    public static <T> Value<T> narrow(Value<? extends T> value) {
        return value;
    }

    default public boolean contains(T element) {
        return this.exists(e -> Objects.equals(e, element));
    }

    default public <U> boolean corresponds(Iterable<U> that, BiPredicate<? super T, ? super U> predicate) {
        java.util.Iterator it1 = this.iterator();
        java.util.Iterator<U> it2 = that.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            if (predicate.test(it1.next(), it2.next())) continue;
            return false;
        }
        return !it1.hasNext() && !it2.hasNext();
    }

    default public boolean eq(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Value) {
            Value that = (Value)o;
            return this.iterator().corresponds((Iterable)((Object)that.iterator()), (BiPredicate)(o1, o2) -> {
                if (o1 instanceof Value) {
                    return ((Value)o1).eq(o2);
                }
                if (o2 instanceof Value) {
                    return ((Value)o2).eq(o1);
                }
                return Objects.equals(o1, o2);
            });
        }
        if (o instanceof Iterable) {
            Iterator that = Iterator.ofAll((Iterable)o);
            return this.eq(that);
        }
        return false;
    }

    default public boolean exists(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        for (Object t : this) {
            if (!predicate.test(t)) continue;
            return true;
        }
        return false;
    }

    default public boolean forAll(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return !this.exists(predicate.negate());
    }

    @Override
    default public void forEach(Consumer<? super T> action) {
        Objects.requireNonNull(action, "action is null");
        for (Object t : this) {
            action.accept(t);
        }
    }

    public T get();

    default public Option<T> getOption() {
        return this.isEmpty() ? Option.none() : Option.some(this.get());
    }

    default public T getOrElse(T other) {
        return this.isEmpty() ? other : this.get();
    }

    default public T getOrElse(Supplier<? extends T> supplier) {
        Objects.requireNonNull(supplier, "supplier is null");
        return this.isEmpty() ? supplier.get() : this.get();
    }

    default public <X extends Throwable> T getOrElseThrow(Supplier<X> supplier) throws X {
        Objects.requireNonNull(supplier, "supplier is null");
        if (this.isEmpty()) {
            throw (Throwable)supplier.get();
        }
        return this.get();
    }

    default public T getOrElseTry(Try.CheckedSupplier<? extends T> supplier) {
        Objects.requireNonNull(supplier, "supplier is null");
        return this.isEmpty() ? Try.of(supplier).get() : this.get();
    }

    public boolean isEmpty();

    public boolean isSingleValued();

    public <U> Value<U> map(Function<? super T, ? extends U> var1);

    public Value<T> peek(Consumer<? super T> var1);

    public String stringPrefix();

    default public void out(PrintStream out) {
        for (Object t : this) {
            out.println(String.valueOf(t));
            if (!out.checkError()) continue;
            throw new IllegalStateException("Error writing to PrintStream");
        }
    }

    default public void out(PrintWriter writer) {
        for (Object t : this) {
            writer.println(String.valueOf(t));
            if (!writer.checkError()) continue;
            throw new IllegalStateException("Error writing to PrintWriter");
        }
    }

    default public void stderr() {
        this.out(System.err);
    }

    default public void stdout() {
        this.out(System.out);
    }

    @Override
    public Iterator<T> iterator();

    default public Array<T> toArray() {
        return ValueModule.toTraversable(this, Array.empty(), Array::of, Array::ofAll);
    }

    default public CharSeq toCharSeq() {
        if (this instanceof CharSeq) {
            return (CharSeq)this;
        }
        if (this.isEmpty()) {
            return CharSeq.empty();
        }
        return CharSeq.of(this.iterator().mkString());
    }

    default public <C extends Collection<T>> C toJavaCollection(Supplier<C> factory) {
        return (C)ValueModule.toJavaCollection(this, (Collection)factory.get());
    }

    default public Object[] toJavaArray() {
        return this.toJavaList().toArray();
    }

    default public T[] toJavaArray(Class<T> componentType) {
        Objects.requireNonNull(componentType, "componentType is null");
        if (componentType.isPrimitive()) {
            Class<Boolean> boxedType = componentType == Boolean.TYPE ? Boolean.class : (componentType == Byte.TYPE ? Byte.class : (componentType == Character.TYPE ? Character.class : (componentType == Double.TYPE ? Double.class : (componentType == Float.TYPE ? Float.class : (componentType == Integer.TYPE ? Integer.class : (componentType == Long.TYPE ? Long.class : (componentType == Short.TYPE ? Short.class : (componentType == Void.TYPE ? Void.class : null))))))));
            return this.toJavaArray(boxedType);
        }
        java.util.List<Object> list = this.toJavaList();
        return list.toArray((Object[])java.lang.reflect.Array.newInstance(componentType, list.size()));
    }

    default public java.util.List<T> toJavaList() {
        return ValueModule.toJavaCollection(this, new ArrayList());
    }

    default public <LIST extends java.util.List<T>> LIST toJavaList(Supplier<LIST> factory) {
        return (LIST)ValueModule.toJavaCollection(this, (java.util.List)factory.get());
    }

    default public <K, V> java.util.Map<K, V> toJavaMap(Function<? super T, ? extends Tuple2<? extends K, ? extends V>> f) {
        return this.toJavaMap(java.util.HashMap::new, f);
    }

    default public <K, V, MAP extends java.util.Map<K, V>> MAP toJavaMap(Supplier<MAP> factory, Function<? super T, ? extends Tuple2<? extends K, ? extends V>> f) {
        Objects.requireNonNull(f, "f is null");
        java.util.Map map = (java.util.Map)factory.get();
        if (!this.isEmpty()) {
            if (this.isSingleValued()) {
                Tuple2<? extends K, ? extends V> entry = f.apply(this.get());
                map.put(entry._1, entry._2);
            } else {
                for (Object a : this) {
                    Tuple2<? extends K, ? extends V> entry = f.apply(a);
                    map.put(entry._1, entry._2);
                }
            }
        }
        return (MAP)map;
    }

    default public Optional<T> toJavaOptional() {
        return this.isEmpty() ? Optional.empty() : Optional.ofNullable(this.get());
    }

    default public java.util.Set<T> toJavaSet() {
        return ValueModule.toJavaCollection(this, new java.util.HashSet());
    }

    default public <SET extends java.util.Set<T>> SET toJavaSet(Supplier<SET> factory) {
        return (SET)ValueModule.toJavaCollection(this, (java.util.Set)factory.get());
    }

    default public java.util.stream.Stream<T> toJavaStream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    default public <R> Either<T, R> toLeft(Supplier<? extends R> right) {
        Objects.requireNonNull(right, "right is null");
        return this.isEmpty() ? Either.right(right.get()) : Either.left(this.get());
    }

    default public <R> Either<T, R> toLeft(R right) {
        return this.isEmpty() ? Either.right(right) : Either.left(this.get());
    }

    default public List<T> toList() {
        return ValueModule.toTraversable(this, List.empty(), List::of, List::ofAll);
    }

    default public <K, V> Map<K, V> toMap(Function<? super T, ? extends Tuple2<? extends K, ? extends V>> f) {
        Objects.requireNonNull(f, "f is null");
        if (this.isEmpty()) {
            return HashMap.empty();
        }
        if (this.isSingleValued()) {
            return HashMap.of(f.apply(this.get()));
        }
        return HashMap.ofEntries(Iterator.ofAll(this).map(f));
    }

    default public Option<T> toOption() {
        if (this instanceof Option) {
            return (Option)this;
        }
        return this.getOption();
    }

    default public Queue<T> toQueue() {
        return ValueModule.toTraversable(this, Queue.empty(), Queue::of, Queue::ofAll);
    }

    default public <L> Either<L, T> toRight(Supplier<? extends L> left) {
        Objects.requireNonNull(left, "left is null");
        return this.isEmpty() ? Either.left(left.get()) : Either.right(this.get());
    }

    default public <L> Either<L, T> toRight(L left) {
        return this.isEmpty() ? Either.left(left) : Either.right(this.get());
    }

    default public Set<T> toSet() {
        return ValueModule.toTraversable(this, HashSet.empty(), HashSet::of, HashSet::ofAll);
    }

    default public Stack<T> toStack() {
        return this.toList();
    }

    default public Stream<T> toStream() {
        return ValueModule.toTraversable(this, Stream.empty(), Stream::of, Stream::ofAll);
    }

    default public Try<T> toTry() {
        if (this instanceof Try) {
            return (Try)this;
        }
        return Try.of(this::get);
    }

    default public Try<T> toTry(Supplier<? extends Throwable> ifEmpty) {
        Objects.requireNonNull(ifEmpty, "ifEmpty is null");
        return this.isEmpty() ? Try.failure(ifEmpty.get()) : this.toTry();
    }

    default public Tree<T> toTree() {
        return ValueModule.toTraversable(this, Tree.empty(), Tree::of, Tree::ofAll);
    }

    default public Vector<T> toVector() {
        return ValueModule.toTraversable(this, Vector.empty(), Vector::of, Vector::ofAll);
    }

    public boolean equals(Object var1);

    public int hashCode();

    public String toString();
}

