/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.javaslang.collection;

import com.vertabelo.autolayout_tool.repackaged.javaslang.Lazy;
import com.vertabelo.autolayout_tool.repackaged.javaslang.collection.AbstractIterator;
import com.vertabelo.autolayout_tool.repackaged.javaslang.collection.Array;
import com.vertabelo.autolayout_tool.repackaged.javaslang.collection.Iterator;
import com.vertabelo.autolayout_tool.repackaged.javaslang.collection.Seq;
import com.vertabelo.autolayout_tool.repackaged.javaslang.collection.Set;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.NoSuchElementException;
import java.util.function.Function;

interface IteratorModule {

    public static final class BigDecimalHelper {
        private static final Lazy<BigDecimal> INFINITY_DISTANCE = Lazy.of(() -> {
            BigDecimal supremum;
            BigDecimal two = BigDecimal.valueOf(2L);
            BigDecimal lowerBound = supremum = BigDecimal.valueOf(Math.nextDown(Double.POSITIVE_INFINITY));
            BigDecimal upperBound = two.pow(1024);
            while (true) {
                BigDecimal magicValue;
                if (Double.isInfinite((magicValue = lowerBound.add(upperBound).divide(two, RoundingMode.HALF_UP)).doubleValue())) {
                    if (BigDecimalHelper.areEqual(magicValue, upperBound)) {
                        return magicValue.subtract(supremum);
                    }
                    upperBound = magicValue;
                    continue;
                }
                lowerBound = magicValue;
            }
        });

        static boolean areEqual(BigDecimal from, BigDecimal toExclusive) {
            return from.compareTo(toExclusive) == 0;
        }

        static BigDecimal asDecimal(double number) {
            if (number == Double.NEGATIVE_INFINITY) {
                BigDecimal result = BigDecimal.valueOf(Math.nextUp(Double.NEGATIVE_INFINITY));
                return result.subtract(INFINITY_DISTANCE.get());
            }
            if (number == Double.POSITIVE_INFINITY) {
                BigDecimal result = BigDecimal.valueOf(Math.nextDown(Double.POSITIVE_INFINITY));
                return result.add(INFINITY_DISTANCE.get());
            }
            return BigDecimal.valueOf(number);
        }
    }

    public static final class GroupedIterator<T>
    implements Iterator<Seq<T>> {
        private final Iterator<T> that;
        private final int size;
        private final int step;
        private final int gap;
        private final int preserve;
        private Object[] buffer;

        GroupedIterator(Iterator<T> that, int size, int step) {
            if (size < 1 || step < 1) {
                throw new IllegalArgumentException("size (" + size + ") and step (" + step + ") must both be positive");
            }
            this.that = that;
            this.size = size;
            this.step = step;
            this.gap = Math.max(step - size, 0);
            this.preserve = Math.max(size - step, 0);
            this.buffer = GroupedIterator.take(that, new Object[size], 0, size);
        }

        @Override
        public boolean hasNext() {
            return this.buffer.length > 0;
        }

        @Override
        public Seq<T> next() {
            if (this.buffer.length == 0) {
                throw new NoSuchElementException();
            }
            Object[] result = this.buffer;
            if (this.that.hasNext()) {
                this.buffer = new Object[this.size];
                if (this.preserve > 0) {
                    System.arraycopy(result, this.step, this.buffer, 0, this.preserve);
                }
                if (this.gap > 0) {
                    GroupedIterator.drop(this.that, this.gap);
                    this.buffer = GroupedIterator.take(this.that, this.buffer, this.preserve, this.size);
                } else {
                    this.buffer = GroupedIterator.take(this.that, this.buffer, this.preserve, this.step);
                }
            } else {
                this.buffer = new Object[0];
            }
            return Array.wrap(result);
        }

        private static void drop(Iterator<?> source, int count) {
            for (int i = 0; i < count && source.hasNext(); ++i) {
                source.next();
            }
        }

        private static Object[] take(Iterator<?> source, Object[] target, int offset, int count) {
            int i;
            for (i = offset; i < count + offset && source.hasNext(); ++i) {
                target[i] = source.next();
            }
            if (i < target.length) {
                Object[] result = new Object[i];
                System.arraycopy(target, 0, result, 0, i);
                return result;
            }
            return target;
        }
    }

    public static final class EmptyIterator
    implements Iterator<Object> {
        static final EmptyIterator INSTANCE = new EmptyIterator();

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException(this.stringPrefix() + ".next()");
        }

        @Override
        public void remove() {
            throw new IllegalStateException(this.stringPrefix() + ".remove()");
        }

        @Override
        public String stringPrefix() {
            return "EmptyIterator";
        }

        @Override
        public String toString() {
            return this.stringPrefix() + "()";
        }
    }

    public static final class DistinctIterator<T, U>
    extends AbstractIterator<T> {
        private final Iterator<? extends T> that;
        private Set<U> known;
        private final Function<? super T, ? extends U> keyExtractor;
        private T next;

        DistinctIterator(Iterator<? extends T> that, Set<U> set, Function<? super T, ? extends U> keyExtractor) {
            this.that = that;
            this.known = set;
            this.keyExtractor = keyExtractor;
        }

        @Override
        public boolean hasNext() {
            while (this.next == null && this.that.hasNext()) {
                Object elem = this.that.next();
                U key = this.keyExtractor.apply(elem);
                if (this.known.contains(key)) continue;
                this.known = this.known.add(key);
                this.next = elem;
            }
            return this.next != null;
        }

        @Override
        public T getNext() {
            T result = this.next;
            this.next = null;
            return result;
        }
    }

    public static final class ConcatIterator<T>
    extends AbstractIterator<T> {
        private final Iterator<? extends Iterator<? extends T>> iterators;
        private Iterator<? extends T> current = Iterator.empty();

        ConcatIterator(Iterator<? extends Iterator<? extends T>> iterators) {
            this.iterators = iterators;
        }

        @Override
        public boolean hasNext() {
            while (!this.current.hasNext() && !this.iterators.isEmpty()) {
                this.current = (Iterator)this.iterators.next();
            }
            return this.current.hasNext();
        }

        @Override
        public T getNext() {
            return (T)this.current.next();
        }
    }
}

