/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.javaslang.collection;

import com.vertabelo.autolayout_tool.repackaged.javaslang.Tuple;
import com.vertabelo.autolayout_tool.repackaged.javaslang.Tuple2;
import com.vertabelo.autolayout_tool.repackaged.javaslang.Tuple3;
import com.vertabelo.autolayout_tool.repackaged.javaslang.collection.LinearSeq;
import com.vertabelo.autolayout_tool.repackaged.javaslang.collection.List;
import com.vertabelo.autolayout_tool.repackaged.javaslang.collection.Stream;
import com.vertabelo.autolayout_tool.repackaged.javaslang.collection.Traversable;
import com.vertabelo.autolayout_tool.repackaged.javaslang.collection.Tree;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.function.Function;

interface TreeModule {

    public static final class ZipAll {
        static <T, U> Tree<Tuple2<T, U>> apply(Tree.Node<T> node, Iterator<? extends U> that, U thatElem) {
            if (!that.hasNext()) {
                return node.map(value -> Tuple.of(value, thatElem));
            }
            Tuple2<T, U> value2 = Tuple.of(node.getValue(), that.next());
            List children = (List)node.getChildren().map(child -> ZipAll.apply(child, that, thatElem)).filter(Traversable::nonEmpty);
            return new Tree.Node<Tuple2<T, U>>(value2, children);
        }
    }

    public static final class Zip {
        static <T, U> Tree<Tuple2<T, U>> apply(Tree.Node<T> node, Iterator<? extends U> that) {
            if (!that.hasNext()) {
                return Tree.Empty.instance();
            }
            Tuple2<T, U> value = Tuple.of(node.getValue(), that.next());
            List children = (List)node.getChildren().map(child -> Zip.apply(child, that)).filter(Traversable::nonEmpty);
            return new Tree.Node<Tuple2<T, U>>(value, children);
        }
    }

    public static final class Unzip {
        static <T, T1, T2> Tuple2<Tree.Node<T1>, Tree.Node<T2>> apply(Tree.Node<T> node, Function<? super T, Tuple2<? extends T1, ? extends T2>> unzipper) {
            Tuple2<? extends T1, ? extends T2> value = unzipper.apply(node.getValue());
            LinearSeq children = node.getChildren().map(child -> Unzip.apply(child, unzipper));
            Tree.Node node1 = new Tree.Node(value._1, children.map(t -> (Tree.Node)t._1));
            Tree.Node node2 = new Tree.Node(value._2, children.map(t -> (Tree.Node)t._2));
            return Tuple.of(node1, node2);
        }

        static <T, T1, T2, T3> Tuple3<Tree.Node<T1>, Tree.Node<T2>, Tree.Node<T3>> apply3(Tree.Node<T> node, Function<? super T, Tuple3<? extends T1, ? extends T2, ? extends T3>> unzipper) {
            Tuple3<? extends T1, ? extends T2, ? extends T3> value = unzipper.apply(node.getValue());
            LinearSeq children = node.getChildren().map(child -> Unzip.apply3(child, unzipper));
            Tree.Node node1 = new Tree.Node(value._1, children.map(t -> (Tree.Node)t._1));
            Tree.Node node2 = new Tree.Node(value._2, children.map(t -> (Tree.Node)t._2));
            Tree.Node node3 = new Tree.Node(value._3, children.map(t -> (Tree.Node)t._3));
            return Tuple.of(node1, node2, node3);
        }
    }

    public static final class Traversal {
        static <T> Stream<Tree.Node<T>> preOrder(Tree.Node<T> node) {
            return node.getChildren().foldLeft(Stream.of(node), (acc, child) -> acc.appendAll((Iterable)Traversal.preOrder(child)));
        }

        static <T> Stream<Tree.Node<T>> inOrder(Tree.Node<T> node) {
            if (node.isLeaf()) {
                return Stream.of(node);
            }
            List<Tree.Node<T>> children = node.getChildren();
            return children.tail().foldLeft(Stream.empty(), (acc, child) -> acc.appendAll((Iterable)Traversal.inOrder(child))).prepend(node).prependAll(Traversal.inOrder((Tree.Node)children.head()));
        }

        static <T> Stream<Tree.Node<T>> postOrder(Tree.Node<T> node) {
            return node.getChildren().foldLeft(Stream.empty(), (acc, child) -> acc.appendAll((Iterable)Traversal.postOrder(child))).append(node);
        }

        static <T> Stream<Tree.Node<T>> levelOrder(Tree.Node<T> node) {
            LinearSeq result = Stream.empty();
            LinkedList<Tree.Node<T>> queue = new LinkedList<Tree.Node<T>>();
            queue.add(node);
            while (!queue.isEmpty()) {
                Tree.Node next = (Tree.Node)queue.remove();
                result = result.prepend(next);
                queue.addAll(next.getChildren().toJavaList());
            }
            return result.reverse();
        }
    }

    public static final class Replace {
        static <T> Tree.Node<T> apply(Tree.Node<T> node, T currentElement, T newElement) {
            if (Objects.equals(node.getValue(), currentElement)) {
                return new Tree.Node<T>(newElement, node.getChildren());
            }
            for (Tree.Node node2 : node.getChildren()) {
                Tree.Node<T> newChild = Replace.apply(node2, currentElement, newElement);
                boolean found = newChild != node2;
                if (!found) continue;
                LinearSeq newChildren = node.getChildren().replace((Object)node2, newChild);
                return new Tree.Node<T>(node.getValue(), newChildren);
            }
            return node;
        }
    }

    public static final class Map {
        static <T, U> Tree.Node<U> apply(Tree.Node<T> node, Function<? super T, ? extends U> mapper) {
            U value = mapper.apply(node.getValue());
            LinearSeq children = node.getChildren().map(child -> Map.apply(child, mapper));
            return new Tree.Node<U>(value, children);
        }
    }

    public static final class FlatMap {
        static <T, U> Tree<U> apply(Tree.Node<T> node, Function<? super T, ? extends Iterable<? extends U>> mapper) {
            Tree<U> mapped = Tree.ofAll(mapper.apply(node.getValue()));
            if (mapped.isEmpty()) {
                return Tree.empty();
            }
            List children = (List)node.getChildren().map(child -> FlatMap.apply(child, mapper)).filter(Traversable::nonEmpty);
            return Tree.of(mapped.getValue(), children.prependAll(mapped.getChildren()));
        }
    }
}

