/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.javaslang.concurrent;

import com.vertabelo.autolayout_tool.repackaged.javaslang.collection.Queue;
import com.vertabelo.autolayout_tool.repackaged.javaslang.concurrent.Future;
import com.vertabelo.autolayout_tool.repackaged.javaslang.control.Option;
import com.vertabelo.autolayout_tool.repackaged.javaslang.control.Try;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;

final class FutureImpl<T>
implements Future<T> {
    private final ExecutorService executorService;
    private final Object lock = new Object();
    private volatile Option<Try<T>> value = Option.none();
    private Queue<Consumer<? super Try<T>>> actions = Queue.empty();
    private java.util.concurrent.Future<Try<T>> job;

    FutureImpl(ExecutorService executorService) {
        Objects.requireNonNull(executorService, "executorService is null");
        this.executorService = executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void await() {
        Object monitor = new Object();
        this.onComplete(ignored -> {
            Object object = monitor;
            synchronized (object) {
                monitor.notify();
            }
        });
        Object object = monitor;
        synchronized (object) {
            if (!this.isCompleted()) {
                Try.run(monitor::wait);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isCompleted()) {
                return false;
            }
            return Try.of(() -> this.job == null || this.job.cancel(mayInterruptIfRunning)).onSuccess(cancelled -> {
                if (cancelled.booleanValue()) {
                    this.value = Option.some(Try.failure(new CancellationException()));
                    this.actions = null;
                    this.job = null;
                }
            }).getOrElse(false);
        }
    }

    @Override
    public ExecutorService executorService() {
        return this.executorService;
    }

    @Override
    public Option<Try<T>> getValue() {
        return this.value;
    }

    @Override
    public boolean isCompleted() {
        return this.value.isDefined();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<T> onComplete(Consumer<? super Try<T>> action) {
        Objects.requireNonNull(action, "action is null");
        if (this.isCompleted()) {
            this.perform(action);
        } else {
            Object object = this.lock;
            synchronized (object) {
                if (this.isCompleted()) {
                    this.perform(action);
                } else {
                    this.actions = this.actions.enqueue(action);
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run(Try.CheckedSupplier<? extends T> computation) {
        Objects.requireNonNull(computation, "computation is null");
        Object object = this.lock;
        synchronized (object) {
            block8: {
                if (this.job != null) {
                    throw new IllegalStateException("The Future is already running.");
                }
                if (this.isCompleted()) {
                    throw new IllegalStateException("The Future is completed.");
                }
                try {
                    java.util.concurrent.Future<Try> tmpJob = this.executorService.submit(() -> this.complete(Try.of(computation)));
                    if (!this.isCompleted()) {
                        this.job = tmpJob;
                    }
                }
                catch (Throwable t) {
                    if (this.isCompleted()) break block8;
                    this.complete(Try.failure(t));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Try<T> complete(Try<? extends T> value) {
        Queue<Consumer<Try<Consumer>>> actions;
        Objects.requireNonNull(value, "value is null");
        Object object = this.lock;
        synchronized (object) {
            if (this.isCompleted()) {
                throw new IllegalStateException("The Future is completed.");
            }
            actions = this.actions;
            this.value = Option.some(value);
            this.actions = null;
            this.job = null;
        }
        actions.forEach(this::perform);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean tryComplete(Try<? extends T> value) {
        Objects.requireNonNull(value, "value is null");
        Object object = this.lock;
        synchronized (object) {
            if (this.isCompleted()) {
                return false;
            }
            this.complete(value);
            return true;
        }
    }

    private void perform(Consumer<? super Try<T>> action) {
        Try.run(() -> this.executorService.execute(() -> action.accept(this.value.get())));
    }

    @Override
    public String toString() {
        return this.stringPrefix() + "(" + this.value.map(String::valueOf).getOrElse("?") + ")";
    }
}

