/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms.BiconnectedComponent;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms.Dfs;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.util.NodeMap;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISetSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.SetSequence;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BiconnectAugmentation {
    private static int SHOW_LOG = 0;

    public static Set<Edge> makeBiconnected(Graph graph) {
        return new MyDfs().doDfs(graph, (Node)ListSequence.fromList(graph.getNodes()).getElement(0));
    }

    public static Set<Edge> smartMakeBiconnected(Graph graph) {
        ISetSequence<Edge> addedEdges = SetSequence.fromSet(new LinkedHashSet());
        BiconnectedComponent root = BiconnectedComponent.createTree(graph);
        if (SHOW_LOG > 0) {
            System.out.println(root.toString(""));
        }
        if (ListSequence.fromList(root.getChildren()).count() > 0) {
            IListSequence<Node> toConnect = ListSequence.fromList(new ArrayList());
            BiconnectAugmentation.collectListNodes(root, toConnect, null);
            if (SetSequence.fromSet(root.getNodes()).count() == 1) {
                ListSequence.fromList(toConnect).addElement((Node)SetSequence.fromSet(root.getNodes()).first());
            } else {
                Node cutpoint = root.getCutpoint((BiconnectedComponent)ListSequence.fromList(root.getChildren()).first());
                ListSequence.fromList(toConnect).addElement(SetSequence.fromSet(root.getNodes()).findFirst(it -> it != cutpoint));
            }
            Node prev = null;
            for (Node node : ListSequence.fromList(toConnect)) {
                if (prev != null) {
                    SetSequence.fromSet(addedEdges).addElement(graph.connect(prev, node));
                }
                prev = node;
            }
        }
        return addedEdges;
    }

    private static void collectListNodes(BiconnectedComponent component, List<Node> nodes, Node cutpoint) {
        if (ListSequence.fromList(component.getChildren()).count() == 0) {
            Set<Node> componentNodes = component.getNodes();
            if (SetSequence.fromSet(componentNodes).count() == 1) {
                ListSequence.fromList(nodes).addElement((Node)SetSequence.fromSet(componentNodes).first());
            } else {
                ListSequence.fromList(nodes).addElement(SetSequence.fromSet(componentNodes).findFirst(it -> it != cutpoint));
            }
        } else {
            for (BiconnectedComponent child : ListSequence.fromList(component.getChildren())) {
                BiconnectAugmentation.collectListNodes(child, nodes, component.getChildCutpoint(child));
            }
        }
    }

    public static class MyDfs
    extends Dfs {
        private Map<Node, Node> myLow;
        private Map<Node, Integer> myNum;
        private int myCurNum;
        private Node myNewNode;
        private Node mySource;
        private Set<Node> myConnectToNew;

        public Set<Edge> doDfs(Graph graph, Node source) {
            this.myLow = new NodeMap<Node>(graph);
            this.myNum = new NodeMap<Integer>(graph);
            this.myCurNum = 0;
            this.mySource = source;
            this.myConnectToNew = SetSequence.fromSet(new LinkedHashSet());
            this.init(graph, Edge.Direction.BOTH);
            this.dfs(source, null);
            ISetSequence<Edge> result = SetSequence.fromSet(new LinkedHashSet());
            for (Node node : SetSequence.fromSet(this.myConnectToNew)) {
                SetSequence.fromSet(result).addElement(graph.connect(this.myNewNode, node));
            }
            return result;
        }

        @Override
        protected void preprocess(Node node, Edge from) {
            MapSequence.fromMap(this.myNum).put(node, this.myCurNum++);
            MapSequence.fromMap(this.myLow).put(node, node);
        }

        @Override
        protected void processEdge(Edge edge, Node source) {
            Node next = edge.getOpposite(source);
            if ((Integer)MapSequence.fromMap(this.getDfsState()).get(next) == Dfs.DURING) {
                this.changeLow(source, next);
            }
        }

        @Override
        protected void postprocess(Node node, Edge from) {
            if (from != null) {
                Node prev = from.getOpposite(node);
                if ((Integer)MapSequence.fromMap(this.myNum).get(prev) <= (Integer)MapSequence.fromMap(this.myNum).get(MapSequence.fromMap(this.myLow).get(node))) {
                    if (this.myNewNode == null) {
                        this.createNewNode();
                    }
                    SetSequence.fromSet(this.myConnectToNew).addElement(node);
                    MapSequence.fromMap(this.myLow).put(node, this.myNewNode);
                }
                this.changeLow(prev, (Node)MapSequence.fromMap(this.myLow).get(node));
            }
        }

        private void changeLow(Node node, Node newLow) {
            Node oldLow = (Node)MapSequence.fromMap(this.myLow).get(node);
            if ((Integer)MapSequence.fromMap(this.myNum).get(oldLow) > (Integer)MapSequence.fromMap(this.myNum).get(newLow)) {
                MapSequence.fromMap(this.myLow).put(node, newLow);
            }
        }

        public void createNewNode() {
            this.myNewNode = this.getGraph().createNode();
            MapSequence.fromMap(this.myNum).put(this.myNewNode, -1);
            SetSequence.fromSet(this.myConnectToNew).addElement(this.mySource);
        }
    }
}

