/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms.BiconnectedComponents;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms.Dfs;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.SetSequence;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BiconnectedComponent {
    private Set<Node> myNodes = SetSequence.fromSet(new LinkedHashSet());
    private List<BiconnectedComponent> myChildren = ListSequence.fromList(new ArrayList());
    private Map<BiconnectedComponent, Edge> myBridges = MapSequence.fromMap(new HashMap());
    private Map<BiconnectedComponent, Node> myCutpoints = MapSequence.fromMap(new HashMap());

    private BiconnectedComponent() {
    }

    public void addComponent(BiconnectedComponent component, Node node) {
        ListSequence.fromList(this.myChildren).addElement(component);
        MapSequence.fromMap(this.myCutpoints).put(component, node);
    }

    public void addComponent(BiconnectedComponent component, Edge edge) {
        ListSequence.fromList(this.myChildren).addElement(component);
        MapSequence.fromMap(this.myBridges).put(component, edge);
    }

    public void addNode(Node node) {
        SetSequence.fromSet(this.myNodes).addElement(node);
    }

    public List<BiconnectedComponent> getChildren() {
        return this.myChildren;
    }

    public Set<Node> getNodes() {
        return this.myNodes;
    }

    public Object getConnection(BiconnectedComponent child) {
        if (MapSequence.fromMap(this.myBridges).containsKey(child)) {
            return MapSequence.fromMap(this.myBridges).get(child);
        }
        return MapSequence.fromMap(this.myCutpoints).get(child);
    }

    public Node getChildCutpoint(BiconnectedComponent child) {
        if (MapSequence.fromMap(this.myBridges).containsKey(child)) {
            Edge bridge = (Edge)MapSequence.fromMap(this.myBridges).get(child);
            Node cutpoint = bridge.getSource();
            if (SetSequence.fromSet(this.getNodes()).contains(cutpoint)) {
                cutpoint = bridge.getTarget();
            }
            return cutpoint;
        }
        return (Node)MapSequence.fromMap(this.myCutpoints).get(child);
    }

    public Node getCutpoint(BiconnectedComponent child) {
        if (MapSequence.fromMap(this.myBridges).containsKey(child)) {
            Edge bridge = (Edge)MapSequence.fromMap(this.myBridges).get(child);
            Node cutpoint = bridge.getSource();
            if (!SetSequence.fromSet(this.getNodes()).contains(cutpoint)) {
                cutpoint = bridge.getTarget();
            }
            return cutpoint;
        }
        return (Node)MapSequence.fromMap(this.myCutpoints).get(child);
    }

    public String toString(String prefix) {
        StringBuilder builder = new StringBuilder();
        builder.append(prefix + " C: " + String.valueOf(this.getNodes()) + " has " + ListSequence.fromList(this.getChildren()).count() + " children\n");
        for (BiconnectedComponent child : ListSequence.fromList(this.getChildren())) {
            builder.append(prefix + " from " + String.valueOf(this.getConnection(child)) + ":\n");
            builder.append(child.toString(prefix + "  "));
        }
        return builder.toString();
    }

    public static BiconnectedComponent createTree(Graph graph) {
        BiconnectedComponent tree = new BiconnectedComponent();
        BiconnectedComponents components = new BiconnectedComponents();
        components.doDfs(graph);
        new TreeMaker(components.getLow(), components.getNum()).doDfs(graph, tree);
        BiconnectedComponent treeCandidate = (BiconnectedComponent)ListSequence.fromList(tree.getChildren()).first();
        if (ListSequence.fromList(tree.getChildren()).count() == 1 && tree.getConnection(treeCandidate) instanceof Node) {
            tree = treeCandidate;
        }
        return tree;
    }

    private static class TreeMaker
    extends Dfs {
        private Map<Node, Node> myLow;
        private Map<Node, Integer> myNum;

        public TreeMaker(Map<Node, Node> low, Map<Node, Integer> num) {
            this.myLow = low;
            this.myNum = num;
        }

        public void doDfs(Graph graph, BiconnectedComponent component) {
            this.init(graph, Edge.Direction.BOTH);
            this.dfs((Node)ListSequence.fromList(graph.getNodes()).first(), null, component);
        }

        private void dfs(Node node, Edge from, BiconnectedComponent component) {
            MapSequence.fromMap(this.myDfsState).put(node, DURING);
            BiconnectedComponent nextComponent = component;
            if (from != null) {
                int lowNum = (Integer)MapSequence.fromMap(this.myNum).get(MapSequence.fromMap(this.myLow).get(node));
                Node source = from.getOpposite(node);
                int sourceNum = (Integer)MapSequence.fromMap(this.myNum).get(source);
                if (lowNum < sourceNum) {
                    component.addNode(node);
                } else if (lowNum == sourceNum) {
                    nextComponent = new BiconnectedComponent();
                    nextComponent.addNode(source);
                    nextComponent.addNode(node);
                    component.addComponent(nextComponent, source);
                } else {
                    nextComponent = new BiconnectedComponent();
                    nextComponent.addNode(node);
                    component.addComponent(nextComponent, from);
                }
            } else {
                component.addNode(node);
            }
            for (Edge edge : ListSequence.fromList(node.getEdges())) {
                Node next = edge.getOpposite(node);
                if ((Integer)MapSequence.fromMap(this.myDfsState).get(next) != BEFORE) continue;
                this.dfs(next, edge, nextComponent);
            }
        }
    }
}

