/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms.Dfs;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.util.NodeMap;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import java.util.Map;

public class BiconnectedComponents
extends Dfs {
    private Map<Node, Node> myLow;
    private Map<Node, Integer> myNum;
    private int myCurNum;

    @Override
    public void doDfs(Graph graph) {
        this.myLow = new NodeMap<Node>(graph);
        this.myNum = new NodeMap<Integer>(graph);
        this.init(graph, Edge.Direction.BOTH);
        this.myCurNum = 0;
        this.dfs((Node)ListSequence.fromList(graph.getNodes()).first(), null);
    }

    public void doDfs(Graph graph, Node source, Edge stEdge) {
        this.myLow = new NodeMap<Node>(graph);
        this.myNum = new NodeMap<Integer>(graph);
        this.init(graph, Edge.Direction.BOTH);
        MapSequence.fromMap(this.getDfsState()).put(source, DURING);
        MapSequence.fromMap(this.myLow).put(source, source);
        MapSequence.fromMap(this.myNum).put(source, 0);
        this.myCurNum = 1;
        this.dfs(stEdge.getOpposite(source), stEdge);
    }

    @Override
    protected void preprocess(Node node, Edge from) {
        MapSequence.fromMap(this.myNum).put(node, this.myCurNum++);
        MapSequence.fromMap(this.myLow).put(node, node);
    }

    @Override
    protected void processEdge(Edge edge, Node source) {
        Node next = edge.getOpposite(source);
        if ((Integer)MapSequence.fromMap(this.getDfsState()).get(next) == DURING) {
            this.changeLow(source, next);
        }
    }

    @Override
    protected void postprocess(Node node, Edge from) {
        if (from != null) {
            Node prev = from.getOpposite(node);
            this.changeLow(prev, (Node)MapSequence.fromMap(this.myLow).get(node));
        }
    }

    private void changeLow(Node node, Node newLow) {
        Node oldLow = (Node)MapSequence.fromMap(this.myLow).get(node);
        if ((Integer)MapSequence.fromMap(this.myNum).get(oldLow) > (Integer)MapSequence.fromMap(this.myNum).get(newLow)) {
            MapSequence.fromMap(this.myLow).put(node, newLow);
        }
    }

    public Map<Node, Node> getLow() {
        return this.myLow;
    }

    public Map<Node, Integer> getNum() {
        return this.myNum;
    }
}

