/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms.Dfs;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISetSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.LinkedListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.SetSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.backports.LinkedList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public class ConnectivityComponents {
    public static Map<Node, Integer> getComponents(Graph graph) {
        return ConnectivityComponents.getComponents(graph, edge -> true);
    }

    public static Map<Node, Integer> getComponents(Graph graph, Predicate<? super Edge> filter) {
        MyDfs dfs = new MyDfs();
        dfs.doDfs(graph, Edge.Direction.BOTH, filter);
        return dfs.getComponents();
    }

    public static boolean isConnected(Graph graph) {
        Map<Node, Integer> component = ConnectivityComponents.getComponents(graph);
        for (Node node : ListSequence.fromList(graph.getNodes())) {
            if ((Integer)MapSequence.fromMap(component).get(node) <= 0) continue;
            return false;
        }
        return true;
    }

    public static List<List<Node>> getComponentsList(Map<Node, Integer> components) {
        int componentsNum = ConnectivityComponents.getComponentsNum(components);
        IListSequence<List<Node>> componentsList = ListSequence.fromList(new ArrayList(componentsNum));
        for (int i = 0; i < componentsNum; ++i) {
            ListSequence.fromList(componentsList).addElement(LinkedListSequence.fromLinkedList(new LinkedList()));
        }
        for (Node node : SetSequence.fromSet(MapSequence.fromMap(components).keySet())) {
            ListSequence.fromList(ListSequence.fromList(componentsList).getElement((Integer)MapSequence.fromMap(components).get(node))).addElement(node);
        }
        return componentsList;
    }

    private static int getComponentsNum(Map<Node, Integer> components) {
        int componentsNum = 0;
        for (Node node : SetSequence.fromSet(MapSequence.fromMap(components).keySet())) {
            componentsNum = Math.max(componentsNum, (Integer)MapSequence.fromMap(components).get(node) + 1);
        }
        return componentsNum;
    }

    public static Set<Edge> makeConnected(Graph graph) {
        ISetSequence<Edge> addedEdges = SetSequence.fromSet(new HashSet());
        Map<Node, Integer> components = ConnectivityComponents.getComponents(graph);
        int num = ConnectivityComponents.getComponentsNum(components);
        Node[] nodes = new Node[num];
        Iterator iterator = ListSequence.fromList(graph.getNodes()).iterator();
        while (iterator.hasNext()) {
            Node node;
            nodes[((Integer)MapSequence.fromMap(components).get((Object)node)).intValue()] = node = (Node)iterator.next();
        }
        Node prev = null;
        for (Node node : nodes) {
            if (prev != null) {
                Edge edge = graph.connect(prev, node);
                SetSequence.fromSet(addedEdges).addElement(edge);
            }
            prev = node;
        }
        return addedEdges;
    }

    private static class MyDfs
    extends Dfs {
        private Map<Node, Integer> myComponents;
        private int myCurrentComponent;

        @Override
        public void doDfs(Graph graph, Edge.Direction direction, Predicate<? super Edge> filter) {
            this.myComponents = MapSequence.fromMap(new HashMap());
            this.myCurrentComponent = -1;
            super.doDfs(graph, Edge.Direction.BOTH, filter);
        }

        @Override
        protected void preprocessRoot(Node root) {
            ++this.myCurrentComponent;
        }

        @Override
        protected void preprocess(Node node, Edge from) {
            MapSequence.fromMap(this.myComponents).put(node, this.myCurrentComponent);
        }

        public Map<Node, Integer> getComponents() {
            return this.myComponents;
        }
    }
}

