/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.util.NodeMap;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import java.util.Map;
import java.util.function.Predicate;

public abstract class Dfs {
    public static int BEFORE = 0;
    public static int DURING = 1;
    public static int AFTER = 2;
    private Graph myGraph;
    private Edge.Direction myDirection;
    protected Map<Node, Integer> myDfsState;
    private Predicate<? super Edge> myEdgeFilter;

    public void doDfs(Graph graph) {
        this.doDfs(graph, Edge.Direction.FRONT);
    }

    public void doDfs(Graph graph, Edge.Direction direction) {
        this.doDfs(graph, direction, edge -> true);
    }

    public void doDfs(Graph graph, Edge.Direction direction, Predicate<? super Edge> edgeFilter) {
        this.init(graph, direction, edgeFilter);
        for (Node node : ListSequence.fromList(this.myGraph.getNodes())) {
            if ((Integer)MapSequence.fromMap(this.myDfsState).get(node) != BEFORE) continue;
            this.preprocessRoot(node);
            this.dfs(node, null);
            this.postprocessRoot(node);
        }
    }

    public void init(Graph graph, Edge.Direction direction) {
        this.init(graph, direction, edge -> true);
    }

    public void init(Graph graph, Edge.Direction direction, Predicate<? super Edge> edgeFilter) {
        this.myGraph = graph;
        this.myEdgeFilter = edgeFilter;
        this.myDfsState = new NodeMap<Integer>(graph);
        this.myDirection = direction;
        for (Node node : ListSequence.fromList(this.myGraph.getNodes())) {
            MapSequence.fromMap(this.myDfsState).put(node, BEFORE);
        }
    }

    protected void dfs(Node node, Edge from) {
        MapSequence.fromMap(this.myDfsState).put(node, DURING);
        this.preprocess(node, from);
        for (Edge edge : ListSequence.fromList(node.getEdges(this.myDirection)).where(this.myEdgeFilter)) {
            if (edge == from) continue;
            this.processEdge(edge, node);
            Node target = edge.getOpposite(node);
            if ((Integer)MapSequence.fromMap(this.myDfsState).get(target) != BEFORE) continue;
            this.dfs(target, edge);
        }
        this.postprocess(node, from);
        MapSequence.fromMap(this.myDfsState).put(node, AFTER);
    }

    protected void preprocessRoot(Node root) {
    }

    protected void postprocessRoot(Node root) {
    }

    protected void preprocess(Node node, Edge from) {
    }

    protected void processEdge(Edge edge, Node source) {
    }

    protected void postprocess(Node node, Edge from) {
    }

    protected Map<Node, Integer> getDfsState() {
        return this.myDfsState;
    }

    public Graph getGraph() {
        return this.myGraph;
    }
}

