/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.backports.LinkedList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Predicate;

public class Dijkstra {
    private Graph myGraph;
    private Node mySource;
    private Map<Edge, Integer> myWeights;
    private Map<Node, Integer> myDist;
    private Map<Node, Edge> myPrev;
    private TreeSet<Node> mySet;

    public Dijkstra(Graph graph, Node source, Map<Edge, Integer> weights) {
        this.myGraph = graph;
        this.mySource = source;
        this.myWeights = weights;
    }

    public void doAlgorithm() {
        this.doAlgorithm(edge -> true, Edge.Direction.FRONT);
    }

    public void doAlgorithm(Predicate<? super Edge> filter, Edge.Direction direction) {
        this.init();
        while (!this.mySet.isEmpty()) {
            Node first = this.mySet.first();
            if ((Integer)MapSequence.fromMap(this.myDist).get(first) == 0x3FFFFFFF) break;
            this.mySet.remove(first);
            for (Edge edge : ListSequence.fromList(first.getEdges(direction)).where(it -> filter.test((Edge)it))) {
                if ((Integer)MapSequence.fromMap(this.myWeights).get(edge) < 0) {
                    throw new RuntimeException("dijkstra with negative weights");
                }
                Node opposite = edge.getOpposite(first);
                if ((Integer)MapSequence.fromMap(this.myDist).get(opposite) <= (Integer)MapSequence.fromMap(this.myDist).get(first) + (Integer)MapSequence.fromMap(this.myWeights).get(edge)) continue;
                this.mySet.remove(opposite);
                MapSequence.fromMap(this.myDist).put(opposite, (Integer)MapSequence.fromMap(this.myDist).get(first) + (Integer)MapSequence.fromMap(this.myWeights).get(edge));
                MapSequence.fromMap(this.myPrev).put(opposite, edge);
                this.mySet.add(opposite);
            }
        }
    }

    private void init() {
        this.myDist = MapSequence.fromMap(new HashMap());
        this.myPrev = MapSequence.fromMap(new HashMap());
        this.mySet = new TreeSet<Node>(new NodeComparator());
        for (Node node : ListSequence.fromList(this.myGraph.getNodes())) {
            MapSequence.fromMap(this.myDist).put(node, 0x3FFFFFFF);
        }
        MapSequence.fromMap(this.myDist).put(this.mySource, 0);
        for (Node node : ListSequence.fromList(this.myGraph.getNodes())) {
            this.mySet.add(node);
        }
    }

    public List<Edge> getShortestPath(Node target) {
        IListSequence<Edge> path = ListSequence.fromList(new LinkedList());
        if ((Integer)MapSequence.fromMap(this.myDist).get(target) == 0x3FFFFFFF) {
            return null;
        }
        Node cur = target;
        while (cur != this.mySource) {
            Edge prev = (Edge)MapSequence.fromMap(this.myPrev).get(cur);
            ListSequence.fromList(path).insertElement(0, prev);
            cur = prev.getOpposite(cur);
        }
        return path;
    }

    public Map<Node, Integer> getDistance() {
        return this.myDist;
    }

    private class NodeComparator
    implements Comparator<Node> {
        @Override
        public int compare(Node first, Node second) {
            int distCompare = ((Integer)MapSequence.fromMap(Dijkstra.this.myDist).get(first)).compareTo((Integer)MapSequence.fromMap(Dijkstra.this.myDist).get(second));
            if (distCompare != 0) {
                return distCompare;
            }
            return first.getIndex() - second.getIndex();
        }
    }
}

