/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.util.NodeMap;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISetSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.SetSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.backports.LinkedList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class FordBellman {
    private Graph myGraph;
    private Node mySource;
    private Edge.Direction myDirection;
    private Predicate<? super Edge> myFilter;
    private Map<Edge, Integer> myWeights;
    private Map<Node, Edge> myPrev;
    private Map<Node, Integer> myDist;

    public FordBellman(Graph graph, Node source, Map<Edge, Integer> weights) {
        this.myGraph = graph;
        this.mySource = source;
        this.myWeights = weights;
    }

    public void doAlgorithm(Predicate<? super Edge> edgeFilter, Edge.Direction direction) {
        this.init(direction, edgeFilter);
        for (int iter = 0; iter < this.myGraph.getNumNodes() - 1; ++iter) {
            for (Node node : ListSequence.fromList(this.myGraph.getNodes())) {
                int sourceDist = (Integer)MapSequence.fromMap(this.myDist).get(node);
                if (sourceDist == 0x3FFFFFFF) continue;
                for (Edge edge : ListSequence.fromList(node.getEdges(direction)).where(it -> edgeFilter.test((Edge)it))) {
                    Node target = edge.getOpposite(node);
                    int targetDist = (Integer)MapSequence.fromMap(this.myDist).get(target);
                    if (sourceDist + (Integer)MapSequence.fromMap(this.myWeights).get(edge) >= targetDist) continue;
                    MapSequence.fromMap(this.myDist).put(target, sourceDist + (Integer)MapSequence.fromMap(this.myWeights).get(edge));
                    MapSequence.fromMap(this.myPrev).put(target, edge);
                }
            }
        }
    }

    public void doAlgorithm() {
        this.doAlgorithm(edge -> true, Edge.Direction.FRONT);
    }

    private void init(Edge.Direction direction, Predicate<? super Edge> filter) {
        this.myDirection = direction;
        this.myFilter = filter;
        this.myPrev = new NodeMap<Edge>(this.myGraph);
        this.myDist = new NodeMap<Integer>(this.myGraph);
        for (Node node : ListSequence.fromList(this.myGraph.getNodes())) {
            MapSequence.fromMap(this.myDist).put(node, 0x3FFFFFFF);
        }
        MapSequence.fromMap(this.myDist).put(this.mySource, 0);
    }

    public List<Edge> getShortestPath(Node target) {
        IListSequence<Edge> path = ListSequence.fromList(new LinkedList());
        if ((Integer)MapSequence.fromMap(this.myDist).get(target) == 0x3FFFFFFF) {
            return null;
        }
        Node cur = target;
        while (cur != this.mySource) {
            Edge prev = (Edge)MapSequence.fromMap(this.myPrev).get(cur);
            ListSequence.fromList(path).insertElement(0, prev);
            cur = prev.getOpposite(cur);
        }
        return path;
    }

    public List<Edge> getNegativeCycleReachableFromSource() {
        for (Node node : ListSequence.fromList(this.myGraph.getNodes())) {
            int sourceDist = (Integer)MapSequence.fromMap(this.myDist).get(node);
            if (sourceDist == 0x3FFFFFFF) continue;
            for (Edge edge : ListSequence.fromList(node.getEdges(this.myDirection)).where(it -> this.myFilter.test((Edge)it))) {
                Node target = edge.getOpposite(node);
                int targetDist = (Integer)MapSequence.fromMap(this.myDist).get(target);
                if (sourceDist + (Integer)MapSequence.fromMap(this.myWeights).get(edge) >= targetDist) continue;
                IListSequence<Edge> cycle = ListSequence.fromList(new LinkedList());
                ISetSequence visited = SetSequence.fromSet(new HashSet());
                ListSequence.fromList(cycle).insertElement(0, edge);
                SetSequence.fromSet(visited).addElement(target);
                Node cur = node;
                while (!SetSequence.fromSet(visited).contains(cur)) {
                    SetSequence.fromSet(visited).addElement(cur);
                    Edge next = (Edge)MapSequence.fromMap(this.myPrev).get(cur);
                    ListSequence.fromList(cycle).insertElement(0, next);
                    cur = next.getOpposite(cur);
                }
                Node first = cur;
                Edge last = null;
                for (Edge cycleEdge : ListSequence.fromList(cycle)) {
                    cur = cycleEdge.getOpposite(cur);
                    if (cur != first) continue;
                    last = cycleEdge;
                    break;
                }
                while (ListSequence.fromList(cycle).last() != last) {
                    ListSequence.fromList(cycle).removeLastElement();
                }
                return cycle;
            }
        }
        return null;
    }

    public boolean isReachableFromSource(Node target) {
        return (Integer)MapSequence.fromMap(this.myDist).get(target) != 0x3FFFFFFF;
    }

    public static List<Edge> getNegativeCycle(Graph graph, Map<Edge, Integer> weights, Predicate<? super Edge> filter, Edge.Direction direction) {
        ISetSequence visited = SetSequence.fromSet(new HashSet());
        for (Node node : ListSequence.fromList(graph.getNodes())) {
            if (SetSequence.fromSet(visited).contains(node)) continue;
            FordBellman bellman = new FordBellman(graph, node, weights);
            bellman.doAlgorithm(filter, direction);
            List<Edge> negativeCycle = bellman.getNegativeCycleReachableFromSource();
            if (negativeCycle != null) {
                return negativeCycle;
            }
            for (Node anotherNode : ListSequence.fromList(graph.getNodes())) {
                if (!bellman.isReachableFromSource(anotherNode)) continue;
                SetSequence.fromSet(visited).addElement(anotherNode);
            }
        }
        return null;
    }
}

