/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms.MinCostMaxFlow;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms.MinCostMaxFlowWithPotentials;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IMapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import java.util.HashMap;
import java.util.Map;

public class MinCostCirculation {
    private static int TEST_MODE = 1;

    public static Map<Edge, Integer> getCirculation(Graph graph, Map<Edge, Integer> low, Map<Edge, Integer> initialCapacity, Map<Edge, Integer> cost) {
        IMapSequence<Edge, Integer> capacity = MapSequence.fromMap(new HashMap());
        Node source = graph.createNode();
        Node target = graph.createNode();
        for (Edge edge : ListSequence.fromList(graph.getEdges())) {
            MapSequence.fromMap(capacity).put(edge, (Integer)MapSequence.fromMap(initialCapacity).get(edge) - (Integer)MapSequence.fromMap(low).get(edge));
        }
        for (Node node : ListSequence.fromList(graph.getNodes())) {
            if (node == source || node == target) continue;
            int diff = 0;
            for (Edge edge : ListSequence.fromList(node.getInEdges())) {
                diff += ((Integer)MapSequence.fromMap(low).get(edge)).intValue();
            }
            for (Edge edge : ListSequence.fromList(node.getOutEdges())) {
                diff -= ((Integer)MapSequence.fromMap(low).get(edge)).intValue();
            }
            Edge newEdge = null;
            if (diff > 0) {
                newEdge = graph.connect(source, node);
            }
            if (diff < 0) {
                newEdge = graph.connect(node, target);
            }
            if (newEdge == null) continue;
            MapSequence.fromMap(capacity).put(newEdge, Math.abs(diff));
            MapSequence.fromMap(cost).put(newEdge, 0);
        }
        Map<Edge, Integer> flow = TEST_MODE > 0 ? MinCostMaxFlowWithPotentials.getFlow(graph, source, target, capacity, cost) : MinCostMaxFlow.getFlow(graph, source, target, capacity, cost);
        for (Edge edge : ListSequence.fromList(source.getEdges()).concat(ListSequence.fromList(target.getEdges()))) {
            MapSequence.fromMap(flow).removeKey(edge);
        }
        graph.deleteNode(source);
        graph.deleteNode(target);
        for (Edge edge : ListSequence.fromList(graph.getEdges())) {
            MapSequence.fromMap(flow).put(edge, (Integer)MapSequence.fromMap(flow).get(edge) + (Integer)MapSequence.fromMap(low).get(edge));
        }
        return flow;
    }
}

