/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms.FordBellman;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms.MaxFlow;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IMapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISetSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.SetSequence;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class MinCostMaxFlowCycleCancelling {
    private static int SHOW_TIME = 1;

    public static Map<Edge, Integer> getFlow(Graph graph, Node source, Node target, Map<Edge, Integer> initialCapacity, Map<Edge, Integer> cost) {
        double time = System.currentTimeMillis();
        Map<Edge, Integer> flow = MaxFlow.getFlow(graph, source, target, initialCapacity);
        IMapSequence opposite = MapSequence.fromMap(new HashMap());
        IMapSequence capacity = MapSequence.fromMap(new HashMap());
        ISetSequence dummyEdges = SetSequence.fromSet(new HashSet());
        for (Edge edge2 : ListSequence.fromList(graph.getEdges())) {
            MapSequence.fromMap(capacity).put(edge2, (Integer)MapSequence.fromMap(initialCapacity).get(edge2) - (Integer)MapSequence.fromMap(flow).get(edge2));
            Edge oppositeEdge = graph.connect(edge2.getTarget(), edge2.getSource());
            MapSequence.fromMap(opposite).put(edge2, oppositeEdge);
            MapSequence.fromMap(opposite).put(oppositeEdge, edge2);
            MapSequence.fromMap(capacity).put(oppositeEdge, (Integer)MapSequence.fromMap(flow).get(edge2));
            MapSequence.fromMap(cost).put(oppositeEdge, -((Integer)MapSequence.fromMap(cost).get(edge2)).intValue());
            SetSequence.fromSet(dummyEdges).addElement(oppositeEdge);
        }
        boolean hasNegativeCycle = true;
        while (hasNegativeCycle) {
            FordBellman cycleFinder = new FordBellman(graph, target, cost);
            cycleFinder.doAlgorithm(edge -> (Integer)MapSequence.fromMap(capacity).get(edge) > 0, Edge.Direction.FRONT);
            List<Edge> cycle = cycleFinder.getNegativeCycleReachableFromSource();
            if (cycle == null) {
                hasNegativeCycle = false;
                continue;
            }
            int minCapacity = Integer.MAX_VALUE;
            for (Edge edge3 : ListSequence.fromList(cycle)) {
                minCapacity = Math.min(minCapacity, (Integer)MapSequence.fromMap(capacity).get(edge3));
            }
            for (Edge edge2 : ListSequence.fromList(cycle)) {
                if (SetSequence.fromSet(dummyEdges).contains(edge2)) {
                    Edge realEdge = (Edge)MapSequence.fromMap(opposite).get(edge2);
                    MapSequence.fromMap(flow).put(realEdge, (Integer)MapSequence.fromMap(flow).get(realEdge) - minCapacity);
                    MapSequence.fromMap(capacity).put(realEdge, (Integer)MapSequence.fromMap(capacity).get(realEdge) + minCapacity);
                    MapSequence.fromMap(capacity).put(edge2, (Integer)MapSequence.fromMap(flow).get(realEdge));
                    continue;
                }
                MapSequence.fromMap(flow).put(edge2, (Integer)MapSequence.fromMap(flow).get(edge2) + minCapacity);
                MapSequence.fromMap(capacity).put(edge2, (Integer)MapSequence.fromMap(capacity).get(edge2) - minCapacity);
                MapSequence.fromMap(capacity).put((Edge)MapSequence.fromMap(opposite).get(edge2), (Integer)MapSequence.fromMap(flow).get(edge2));
            }
        }
        for (Edge edge4 : SetSequence.fromSet(dummyEdges)) {
            graph.removeEdge(edge4);
        }
        if (SHOW_TIME > 0) {
            System.out.println("Min cost max flow algorithm on network with " + ListSequence.fromList(graph.getNodes()).count() + " nodes and " + ListSequence.fromList(graph.getEdges()).count() + " edges");
            System.out.println("working time is " + ((double)System.currentTimeMillis() - time) / 1000.0 + " seconds");
        }
        return flow;
    }
}

