/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms.Dijkstra;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IMapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISetSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.SetSequence;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class MinCostMaxFlowWithPotentials {
    private static int SHOW_TIME = 0;

    public static Map<Edge, Integer> getFlow(Graph graph, Node source, Node target, Map<Edge, Integer> initialCapacity, Map<Edge, Integer> initialCost) {
        double time = System.currentTimeMillis();
        IMapSequence<Edge, Integer> flow = MapSequence.fromMap(new HashMap());
        IMapSequence opposite = MapSequence.fromMap(new HashMap());
        IMapSequence capacity = MapSequence.fromMap(new HashMap());
        IMapSequence<Edge, Integer> cost = MapSequence.fromMap(new HashMap());
        ISetSequence dummyEdges = SetSequence.fromSet(new HashSet());
        for (Edge edge2 : ListSequence.fromList(graph.getEdges())) {
            MapSequence.fromMap(capacity).put(edge2, (Integer)MapSequence.fromMap(initialCapacity).get(edge2));
            MapSequence.fromMap(cost).put(edge2, (Integer)MapSequence.fromMap(initialCost).get(edge2));
            MapSequence.fromMap(flow).put(edge2, 0);
            Edge oppositeEdge = graph.connect(edge2.getTarget(), edge2.getSource());
            MapSequence.fromMap(opposite).put(edge2, oppositeEdge);
            MapSequence.fromMap(opposite).put(oppositeEdge, edge2);
            MapSequence.fromMap(capacity).put(oppositeEdge, 0);
            MapSequence.fromMap(cost).put(oppositeEdge, -((Integer)MapSequence.fromMap(cost).get(edge2)).intValue());
            SetSequence.fromSet(dummyEdges).addElement(oppositeEdge);
        }
        boolean hasPath = true;
        int numIter = 0;
        while (hasPath) {
            ++numIter;
            Dijkstra shortestPathFinder = new Dijkstra(graph, source, cost);
            shortestPathFinder.doAlgorithm(edge -> (Integer)MapSequence.fromMap(capacity).get(edge) > 0, Edge.Direction.FRONT);
            List<Edge> path = shortestPathFinder.getShortestPath(target);
            if (path == null) {
                hasPath = false;
                continue;
            }
            int minCapacity = Integer.MAX_VALUE;
            for (Edge edge3 : ListSequence.fromList(path)) {
                minCapacity = Math.min(minCapacity, (Integer)MapSequence.fromMap(capacity).get(edge3));
            }
            for (Edge edge2 : ListSequence.fromList(path)) {
                if (SetSequence.fromSet(dummyEdges).contains(edge2)) {
                    Edge realEdge = (Edge)MapSequence.fromMap(opposite).get(edge2);
                    MapSequence.fromMap(flow).put(realEdge, (Integer)MapSequence.fromMap(flow).get(realEdge) - minCapacity);
                    MapSequence.fromMap(capacity).put(realEdge, (Integer)MapSequence.fromMap(capacity).get(realEdge) + minCapacity);
                    MapSequence.fromMap(capacity).put(edge2, (Integer)MapSequence.fromMap(flow).get(realEdge));
                    continue;
                }
                MapSequence.fromMap(flow).put(edge2, (Integer)MapSequence.fromMap(flow).get(edge2) + minCapacity);
                MapSequence.fromMap(capacity).put(edge2, (Integer)MapSequence.fromMap(capacity).get(edge2) - minCapacity);
                MapSequence.fromMap(capacity).put((Edge)MapSequence.fromMap(opposite).get(edge2), (Integer)MapSequence.fromMap(flow).get(edge2));
            }
            Map<Node, Integer> distance = shortestPathFinder.getDistance();
            for (Edge edge4 : ListSequence.fromList(graph.getEdges())) {
                if ((Integer)MapSequence.fromMap(distance).get(edge4.getSource()) == 0x3FFFFFFF) continue;
                MapSequence.fromMap(cost).put(edge4, (Integer)MapSequence.fromMap(cost).get(edge4) + (Integer)MapSequence.fromMap(distance).get(edge4.getSource()) - (Integer)MapSequence.fromMap(distance).get(edge4.getTarget()));
                if ((Integer)MapSequence.fromMap(cost).get(edge4) >= 0 || (Integer)MapSequence.fromMap(capacity).get(edge4) <= 0) continue;
                throw new RuntimeException("wrong ponetials");
            }
        }
        for (Edge edge5 : SetSequence.fromSet(dummyEdges)) {
            graph.removeEdge(edge5);
        }
        if (SHOW_TIME > 0) {
            System.out.println("Min cost max flow algorithm on network with " + ListSequence.fromList(graph.getNodes()).count() + " nodes and " + ListSequence.fromList(graph.getEdges()).count() + " edges");
            System.out.println("flow found in " + numIter + " iterations");
            System.out.println("working time is " + ((double)System.currentTimeMillis() - time) / 1000.0 + " seconds");
        }
        return flow;
    }
}

