/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms.BiconnectedComponents;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms.Dfs;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.util.NodeMap;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class STNumbering {
    public static Map<Node, Integer> number(Graph graph, Node source, Node target) {
        Edge stEdge = null;
        boolean deleteAfter = false;
        for (Edge edge : ListSequence.fromList(source.getEdges())) {
            if (edge.getOpposite(source) != target) continue;
            stEdge = edge;
        }
        if (stEdge == null) {
            stEdge = graph.connect(source, target);
            deleteAfter = true;
        }
        BiconnectedComponents biconnectedComponents = new BiconnectedComponents();
        biconnectedComponents.doDfs(graph, source, stEdge);
        Map<Node, Node> low = biconnectedComponents.getLow();
        Numbering numbering = new Numbering();
        numbering.doDfs(graph, source, stEdge, low);
        NodeMap<Integer> res = new NodeMap<Integer>(graph);
        int curNum = 0;
        for (Node node : ListSequence.fromList(numbering.getList())) {
            MapSequence.fromMap(res).put(node, curNum++);
        }
        if (deleteAfter) {
            graph.removeEdge(stEdge);
        }
        return res;
    }

    public static class Numbering
    extends Dfs {
        private Map<Node, Integer> mySign;
        private Map<Node, Node> myLow;
        private List<Node> myList;
        private Node myTarget;

        public void doDfs(Graph graph, Node source, Edge stEdge, Map<Node, Node> low) {
            Node target;
            this.init(graph, Edge.Direction.BOTH);
            this.myLow = low;
            this.mySign = new NodeMap<Integer>(graph);
            MapSequence.fromMap(this.getDfsState()).put(source, DURING);
            this.myTarget = target = stEdge.getOpposite(source);
            MapSequence.fromMap(this.mySign).put(source, -1);
            this.myList = ListSequence.fromListAndArray(new ArrayList(), source, target);
            this.dfs(target, stEdge);
        }

        @Override
        protected void preprocess(Node node, Edge from) {
            if (node != this.myTarget) {
                int prevIndex;
                Node prev = from.getOpposite(node);
                int nodeIndex = prevIndex = ListSequence.fromList(this.myList).indexOf(prev);
                if ((Integer)MapSequence.fromMap(this.mySign).get(MapSequence.fromMap(this.myLow).get(node)) > 0) {
                    nodeIndex = prevIndex + 1;
                }
                ListSequence.fromList(this.myList).insertElement(nodeIndex, node);
                MapSequence.fromMap(this.mySign).put(prev, -((Integer)MapSequence.fromMap(this.mySign).get(MapSequence.fromMap(this.myLow).get(node))).intValue());
            }
        }

        public List<Node> getList() {
            return this.myList;
        }
    }
}

