/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.util.NodeMap;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IQueueSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.QueueSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.backports.LinkedList;
import java.util.List;
import java.util.function.Predicate;

public class ShortestPath {
    public static final int INF = 0x3FFFFFFF;

    public static List<Edge> getPath(Graph graph, Node source, Node target, Edge.Direction direction) {
        return ShortestPath.getPath(graph, source, target, direction, edge -> true);
    }

    public static List<Edge> getPath(Graph graph, Node source, Node target, Edge.Direction direction, Predicate<? super Edge> filter) {
        NodeMap dist = new NodeMap(graph);
        NodeMap prev = new NodeMap(graph);
        IQueueSequence queue = QueueSequence.fromQueue(new LinkedList());
        MapSequence.fromMap(dist).put(source, 0);
        MapSequence.fromMap(prev).put(source, null);
        QueueSequence.fromQueue(queue).addLastElement(source);
        boolean found = false;
        while (QueueSequence.fromQueue(queue).count() > 0) {
            Node cur = (Node)QueueSequence.fromQueue(queue).removeFirstElement();
            if (cur == target) {
                found = true;
                break;
            }
            for (Edge edge : ListSequence.fromList(cur.getEdges(direction))) {
                if (!filter.test(edge)) continue;
                Node next = edge.getOpposite(cur);
                if (MapSequence.fromMap(dist).get(next) != null) continue;
                QueueSequence.fromQueue(queue).addLastElement(next);
                MapSequence.fromMap(dist).put(next, (Integer)MapSequence.fromMap(dist).get(cur) + 1);
                MapSequence.fromMap(prev).put(next, edge);
            }
        }
        if (!found) {
            return null;
        }
        IListSequence<Edge> path = ListSequence.fromList(new LinkedList());
        Node cur = target;
        while (MapSequence.fromMap(prev).get(cur) != null) {
            ListSequence.fromList(path).insertElement(0, (Edge)MapSequence.fromMap(prev).get(cur));
            cur = ((Edge)MapSequence.fromMap(prev).get(cur)).getOpposite(cur);
        }
        return path;
    }
}

