/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms.Dfs;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.backports.LinkedList;
import java.util.List;

public class TopologicalSorting
extends Dfs {
    private List<Node> myOrder;
    private boolean myHasCycles;

    private TopologicalSorting() {
    }

    @Override
    public void doDfs(Graph graph) {
        this.myOrder = ListSequence.fromList(new LinkedList());
        this.myHasCycles = false;
        super.doDfs(graph);
    }

    @Override
    protected void postprocess(Node node, Edge from) {
        ListSequence.fromList(this.myOrder).insertElement(0, node);
    }

    private List<Node> getOrder() {
        return this.myOrder;
    }

    private boolean getHasCycles() {
        return this.myHasCycles;
    }

    @Override
    protected void processEdge(Edge edge, Node source) {
        if ((Integer)MapSequence.fromMap(this.getDfsState()).get(edge.getTarget()) == DURING) {
            this.myHasCycles = true;
        }
    }

    public static List<Node> sort(Graph graph) {
        TopologicalSorting sorter = new TopologicalSorting();
        sorter.doDfs(graph);
        if (sorter.getHasCycles()) {
            return null;
        }
        return sorter.getOrder();
    }

    public static boolean hasCycles(Graph graph) {
        TopologicalSorting sorter = new TopologicalSorting();
        sorter.doDfs(graph);
        return sorter.getHasCycles();
    }
}

