/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms.TopologicalSorting;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.util.NodeMap;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import java.util.List;
import java.util.Map;

public class WeightedTopologicalNumbering {
    public static Map<Node, Integer> number(Graph graph, Map<Edge, Integer> weights) throws IllegalArgumentException {
        List<Node> sorting = TopologicalSorting.sort(graph);
        if (sorting == null) {
            throw new IllegalArgumentException("input graph has cycles");
        }
        NodeMap<Integer> numbering = new NodeMap<Integer>(graph);
        for (Node node : ListSequence.fromList(graph.getNodes())) {
            MapSequence.fromMap(numbering).put(node, 0);
        }
        for (Node node : ListSequence.fromList(sorting)) {
            for (Edge edge : ListSequence.fromList(node.getOutEdges())) {
                Node target = edge.getTarget();
                MapSequence.fromMap(numbering).put(target, Math.max((Integer)MapSequence.fromMap(numbering).get(target), (Integer)MapSequence.fromMap(numbering).get(node) + (Integer)MapSequence.fromMap(weights).get(edge)));
            }
        }
        return numbering;
    }
}

