/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.flowOrthogonalLayout;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms.BiconnectAugmentation;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.flowOrthogonalLayout.QuasiRepresentationModifier;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.CreationStageManager;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.EdgesHistoryManager;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.IEdge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.BasicLayouter;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.GraphLayout;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.GraphLayoutFactory;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.LayoutInfo;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.LayoutInfoCopier;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Dimension;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Direction2D;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.OrthogonalUtil;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Point;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Rectangle;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.Dart;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.EmbeddedGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.Face;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization.EmbeddingFinderFactory;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization.IEmbeddingFinder;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IMapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISetSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.SetSequence;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractOrthogonalFlowLayouter
extends BasicLayouter {
    protected static int SHOW_INFO = 0;
    private boolean myAvoidLabelCrossings = true;
    private boolean myUseRepresentationOptimizations = true;
    protected Set<Edge> myRealEdges;
    protected Set<Node> myRealNodes;
    protected Set<Edge> myStraightEdges;

    @Override
    public GraphLayout doLayoutConnectedGraph(LayoutInfo layoutInfo) {
        LayoutInfoCopier copier = new LayoutInfoCopier(layoutInfo);
        copier.copy();
        LayoutInfo copyInfo = copier.getLayoutInfoCopy();
        GraphLayout copyLayout = this.getLayoutCorruptGraph(copyInfo);
        GraphLayout layout = copier.restoreLayout(copyLayout);
        Rectangle rect = layout.getContainingRectangle();
        layout = layout.shift(-rect.x, -rect.y);
        this.refineLayout(layout);
        return layout;
    }

    private void refineLayout(GraphLayout layout) {
        for (IEdge edge : SetSequence.fromSet(MapSequence.fromMap(layout.getEdgeLayout()).keySet())) {
            layout.setLayoutFor(edge, OrthogonalUtil.refinePolyline((List<Point>)layout.getEdgeLayout(edge)));
        }
    }

    private GraphLayout getLayoutCorruptGraph(LayoutInfo layoutInfo) {
        this.myStraightEdges = null;
        Graph graph = layoutInfo.getGraph();
        if (graph.getNumNodes() == 1) {
            GraphLayout layout = this.getSingleNodeLayout(graph, layoutInfo);
            return layout;
        }
        CreationStageManager stageManager = new CreationStageManager(graph);
        EdgesHistoryManager historyManager = new EdgesHistoryManager(graph);
        ISetSequence<Node> initialNodes = SetSequence.fromSet(new LinkedHashSet());
        SetSequence.fromSet(initialNodes).addSequence((ISequence)ListSequence.fromList(graph.getNodes()));
        this.myRealNodes = SetSequence.fromSet(new HashSet());
        SetSequence.fromSet(this.myRealNodes).addSequence((ISequence)ListSequence.fromList(graph.getNodes()));
        ISetSequence<Edge> initialEdges = SetSequence.fromSet(new LinkedHashSet());
        SetSequence.fromSet(initialEdges).addSequence((ISequence)ListSequence.fromList(graph.getEdges()));
        ISetSequence<Edge> loops = SetSequence.fromSet(new LinkedHashSet());
        this.removeLoops(graph, loops);
        BiconnectAugmentation.smartMakeBiconnected(graph);
        stageManager.nextStage();
        EmbeddedGraph embeddedGraph = this.getEmbedding(graph);
        this.addLoops(loops, embeddedGraph);
        this.myRealEdges = SetSequence.fromSet(new HashSet());
        IMapSequence<Edge, List<Edge>> history = MapSequence.fromMap(new HashMap());
        for (Edge edge : SetSequence.fromSet(initialEdges)) {
            Iterator historyEdges = historyManager.getHistory(edge);
            MapSequence.fromMap(history).put(edge, (List<Edge>)((Object)historyEdges));
            SetSequence.fromSet(this.myRealEdges).addSequence(ListSequence.fromList(historyEdges));
        }
        for (Edge edge : ListSequence.fromList(graph.getEdges())) {
            MapSequence.fromMap(history).put(edge, historyManager.getHistory(edge));
        }
        IMapSequence<Edge, Edge> labeledEdges = MapSequence.fromMap(new HashMap());
        LayoutInfo newInfo = new LayoutInfo(graph);
        for (Node node : SetSequence.fromSet(layoutInfo.getNodesWithSize())) {
            Dimension size = layoutInfo.getNodeSize(node);
            if (size == null) continue;
            newInfo.setNodeSize(node, size);
        }
        for (Edge edge : SetSequence.fromSet(layoutInfo.getLabeledEdges())) {
            Edge labeledEdge = this.getLabeledEdge((List)MapSequence.fromMap(history).get(edge));
            MapSequence.fromMap(labeledEdges).put(edge, labeledEdge);
            newInfo.setLabelSize(labeledEdge, layoutInfo.getLabelSize(edge));
        }
        GraphLayout layout = this.getLayoutFromEmbeddedGraph(embeddedGraph, newInfo);
        GraphLayout initialLayout = this.refineLayout(graph, initialNodes, layout, initialEdges, history, labeledEdges);
        return initialLayout;
    }

    protected GraphLayout getSingleNodeLayout(Graph graph, LayoutInfo layoutInfo) {
        GraphLayout layout = new GraphLayout(graph);
        Node node = (Node)ListSequence.fromList(graph.getNodes()).first();
        Dimension size = layoutInfo.getNodeSize(node);
        Rectangle rect = new Rectangle(0, 0, size.width, size.height);
        layout.setLayoutFor(node, rect);
        return layout;
    }

    private void removeLoops(Graph graph, Set<Edge> loops) {
        for (Edge edge : ListSequence.fromList(graph.getEdges())) {
            if (edge.getSource() != edge.getTarget()) continue;
            SetSequence.fromSet(loops).addElement(edge);
            graph.removeEdge(edge);
        }
    }

    protected GraphLayout refineLayout(Graph graph, Set<Node> initialNodes, GraphLayout layout, Set<Edge> initialEdges, Map<Edge, List<Edge>> history, Map<Edge, Edge> labeledEdges) {
        GraphLayout initialLayout = GraphLayoutFactory.createGraphLayout(graph);
        for (Node node : SetSequence.fromSet(initialNodes)) {
            initialLayout.setLayoutFor(node, layout.getNodeLayout(node));
        }
        for (Edge edge : SetSequence.fromSet(initialEdges)) {
            IListSequence<Point> edgeLayout = ListSequence.fromList(new ArrayList());
            Node cur = edge.getSource();
            for (Edge historyEdge : ListSequence.fromList((List)MapSequence.fromMap(history).get(edge))) {
                IListSequence historyLayout = layout.getEdgeLayout(historyEdge);
                if (historyEdge.getSource() != cur) {
                    historyLayout = ListSequence.fromList(historyLayout).reversedList();
                }
                ListSequence.fromList(edgeLayout).addSequence((ISequence)ListSequence.fromList(historyLayout));
                cur = historyEdge.getOpposite(cur);
            }
            initialLayout.setLayoutFor(edge, edgeLayout);
        }
        for (Edge edge : SetSequence.fromSet(MapSequence.fromMap(labeledEdges).keySet())) {
            initialLayout.setLabelLayout(edge, layout.getLabelLayout((IEdge)MapSequence.fromMap(labeledEdges).get(edge)));
        }
        return initialLayout;
    }

    private void addLoops(Set<Edge> loops, EmbeddedGraph embeddedGraph) {
        IMapSequence facesMap = MapSequence.fromMap(new HashMap());
        for (Edge edge : SetSequence.fromSet(loops)) {
            Node node = edge.getSource();
            Face face = (Face)MapSequence.fromMap(facesMap).get(node);
            if (face == null) {
                Face outerFace = embeddedGraph.getOuterFace();
                if (outerFace.contains(ListSequence.fromListAndArray(new ArrayList(), node))) {
                    face = outerFace;
                } else {
                    Edge nodeEdge = (Edge)ListSequence.fromList(node.getEdges()).first();
                    face = (Face)ListSequence.fromList(embeddedGraph.getAdjacentFaces(nodeEdge)).first();
                }
            }
            List<Edge> newEdges = embeddedGraph.getGraph().splitEdge(edge);
            Face newFace = embeddedGraph.makeLoop(face, newEdges, node);
            MapSequence.fromMap(facesMap).put(node, newFace);
        }
    }

    protected EmbeddedGraph getEmbedding(Graph graph) {
        IEmbeddingFinder embeddingFinder = EmbeddingFinderFactory.getFinderForGraph(graph);
        return embeddingFinder.find(graph);
    }

    public abstract Edge getLabeledEdge(List<Edge> var1);

    public abstract GraphLayout getLayoutFromEmbeddedGraph(EmbeddedGraph var1, LayoutInfo var2);

    protected Map<Node, Map<Direction2D, Integer>> getNodeDirectionSizes(List<Node> oldNodes, Map<Node, Dimension> nodeSizes) {
        IMapSequence<Node, Map<Direction2D, Integer>> nodeDirectionSizes = MapSequence.fromMap(new HashMap());
        for (Node node : ListSequence.fromList(oldNodes)) {
            IMapSequence directionSizes = MapSequence.fromMap(new HashMap());
            Dimension size = (Dimension)MapSequence.fromMap(nodeSizes).get(node);
            int horSize = size.height;
            MapSequence.fromMap(directionSizes).put(Direction2D.UP, horSize / 2);
            MapSequence.fromMap(directionSizes).put(Direction2D.DOWN, horSize - (Integer)MapSequence.fromMap(directionSizes).get((Object)Direction2D.UP));
            int verSize = size.width;
            MapSequence.fromMap(directionSizes).put(Direction2D.LEFT, verSize / 2);
            MapSequence.fromMap(directionSizes).put(Direction2D.RIGHT, verSize - (Integer)MapSequence.fromMap(directionSizes).get((Object)Direction2D.LEFT));
            MapSequence.fromMap(nodeDirectionSizes).put(node, directionSizes);
        }
        return nodeDirectionSizes;
    }

    protected Map<Edge, Integer> getEdgesShifts(List<QuasiRepresentationModifier.Modification> modifications, Map<Dart, Direction2D> directions, Map<Node, Dimension> nodeSizes) {
        IMapSequence<Edge, Integer> edgeShifts = MapSequence.fromMap(new HashMap());
        for (QuasiRepresentationModifier.Modification modification : ListSequence.fromList(modifications)) {
            List<Edge> edges = modification.getNewEdges();
            Node node = modification.getSource();
            Direction2D dir = (Direction2D)((Object)MapSequence.fromMap(directions).get(modification.getSourceDart()));
            int nodeLength = dir.isVertical() ? ((Dimension)MapSequence.fromMap(nodeSizes).get((Object)node)).width / 2 : ((Dimension)MapSequence.fromMap(nodeSizes).get((Object)node)).height / 2;
            int unitShift = nodeLength / ListSequence.fromList(edges).count();
            int curShift = 0;
            for (Edge edge : ListSequence.fromList(edges)) {
                MapSequence.fromMap(edgeShifts).put(edge, curShift);
                curShift += unitShift;
            }
        }
        return edgeShifts;
    }

    protected void splitEdges(GraphLayout layout, QuasiRepresentationModifier.Modification modification, Map<Edge, Integer> edgeShifts) {
        Direction2D dartsDir;
        List<Edge> edges = modification.getModifiedEdges();
        Edge firstEdge = (Edge)ListSequence.fromList(edges).first();
        Iterable path = layout.getEdgeLayout(firstEdge);
        Node node = modification.getSource();
        if (firstEdge.getSource() == node) {
            dartsDir = OrthogonalUtil.getDirection((Point)ListSequence.fromList(path).getElement(0), (Point)ListSequence.fromList(path).getElement(1));
        } else {
            int last = ListSequence.fromList(path).count() - 1;
            dartsDir = OrthogonalUtil.getDirection((Point)ListSequence.fromList(path).getElement(last), (Point)ListSequence.fromList(path).getElement(last - 1));
        }
        Direction2D shiftDir = dartsDir.turnClockwise(3);
        int dx = shiftDir.dx();
        int dy = shiftDir.dy();
        Iterator newEdgeItr = ListSequence.fromList(modification.getNewEdges()).iterator();
        for (Edge edge : ListSequence.fromList(edges)) {
            IListSequence<Point> pointsToShift;
            layout.removeStraightBends(edge);
            Iterable edgeLayout = layout.getEdgeLayout(edge);
            if (edge.getSource() == node) {
                pointsToShift = ListSequence.fromListAndArray(new ArrayList(), (Point)ListSequence.fromList(edgeLayout).getElement(0), (Point)ListSequence.fromList(edgeLayout).getElement(1));
            } else {
                int last = ListSequence.fromList(edgeLayout).count() - 1;
                pointsToShift = ListSequence.fromListAndArray(new ArrayList(), (Point)ListSequence.fromList(edgeLayout).getElement(last), (Point)ListSequence.fromList(edgeLayout).getElement(last - 1));
            }
            Edge newEdge = (Edge)newEdgeItr.next();
            for (Point point : ListSequence.fromList(pointsToShift)) {
                point.translate(dx * (Integer)MapSequence.fromMap(edgeShifts).get(newEdge), dy * (Integer)MapSequence.fromMap(edgeShifts).get(newEdge));
            }
        }
    }

    public boolean getAvoidLabelCrossings() {
        return this.myAvoidLabelCrossings;
    }

    public void setAvoidLabelCrossings(boolean avoidLabelCrossings) {
        this.myAvoidLabelCrossings = avoidLabelCrossings;
    }

    public boolean getUseRepresentationOptimizations() {
        return this.myUseRepresentationOptimizations;
    }

    public void setUseRepresentationOptimizations(boolean useRepresentationOptimizations) {
        this.myUseRepresentationOptimizations = useRepresentationOptimizations;
    }
}

