/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.flowOrthogonalLayout;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.flowOrthogonalLayout.OrthogonalFlowLayouter;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.ClusteredGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.EdgesHistoryManager;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.IGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.ClusteredGraphLayout;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.GraphLayout;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.ILayoutInfo;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.LayoutInfo;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Point;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.EmbeddedGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization.ClusteredGraphEmbeddingFinder;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.Sequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.SetSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.backports.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClusterOrthogonalFlowLayouter
extends OrthogonalFlowLayouter {
    private Map<Node, List<Edge>> myClusterBorderMap;
    private EdgesHistoryManager myHistoryManager;

    @Override
    public GraphLayout doLayout(ILayoutInfo layoutInfo) {
        IGraph graph = layoutInfo.getGraph();
        if (!(graph instanceof ClusteredGraph)) {
            throw new RuntimeException("can layout clustered graph only!!!");
        }
        this.setUseRepresentationOptimizations(false);
        return super.doLayout(layoutInfo);
    }

    @Override
    protected GraphLayout doLayoutCopy(LayoutInfo patchInfo) {
        return this.doLayoutConnectedGraph(patchInfo);
    }

    @Override
    protected GraphLayout refineLayout(Graph graph, Set<Node> initialNodes, GraphLayout layout, Set<Edge> initialEdges, Map<Edge, List<Edge>> history, Map<Edge, Edge> labeledEdges) {
        ClusteredGraphLayout refinedLayout = (ClusteredGraphLayout)super.refineLayout(graph, initialNodes, layout, initialEdges, history, labeledEdges);
        for (Node cluster : SetSequence.fromSet(MapSequence.fromMap(this.myClusterBorderMap).keySet())) {
            List border = (List)MapSequence.fromMap(this.myClusterBorderMap).get(cluster);
            IListSequence<Point> borderLayout = ListSequence.fromList(new LinkedList());
            for (Edge borderEdge : ListSequence.fromList(border)) {
                List borderEdgeHistory = (List)MapSequence.fromMap(history).get(borderEdge);
                for (Edge historyEdge : ListSequence.fromList(borderEdgeHistory)) {
                    Iterable copyEdgeLayout = layout.getEdgeLayout(historyEdge);
                    ListSequence.fromList(borderLayout).addSequence((ISequence)ListSequence.fromList(copyEdgeLayout));
                }
            }
            refinedLayout.setClusterLayout(cluster, borderLayout);
        }
        return refinedLayout;
    }

    @Override
    public Edge getLabeledEdge(List<Edge> edges) {
        return super.getLabeledEdge(edges);
    }

    @Override
    protected EmbeddedGraph getEmbedding(Graph graph) {
        EdgesHistoryManager historyManager = new EdgesHistoryManager(graph);
        ClusteredGraphEmbeddingFinder embeddingFinder = new ClusteredGraphEmbeddingFinder();
        EmbeddedGraph embeddedGraph = embeddingFinder.find(graph);
        this.myClusterBorderMap = embeddingFinder.getClusterBorderMap();
        this.checkClusterBorder(historyManager);
        this.myHistoryManager = historyManager;
        return embeddedGraph;
    }

    private void checkClusterBorder(EdgesHistoryManager historyManager) {
        for (List border : Sequence.fromIterable(MapSequence.fromMap(this.myClusterBorderMap).values())) {
            for (Edge edge : ListSequence.fromList(border)) {
                if (ListSequence.fromList(historyManager.getHistory(edge)).count() <= 1) continue;
                throw new RuntimeException("wrong border!!!");
            }
        }
    }
}

