/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.flowOrthogonalLayout;

import com.vertabelo.autolayout_tool.repackaged.mps.baseLanguage.closures.runtime.Wrappers;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms.ConnectivityComponents;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms.ShortestPath;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms.TopologicalSorting;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms.WeightedTopologicalNumbering;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Direction2D;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Point;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.Dart;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.EmbeddedGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.Face;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IMapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISetSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.Sequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.SetSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.backports.LinkedList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public class ConstraintsGraph {
    private static int SHOW_INFO = 0;
    private static int DEBUG = 0;
    private static int DEFAULT_UNIT_LENGTH = 20;
    private Graph myGraph;
    private EmbeddedGraph myEmbeddedGraph;
    private Map<Dart, Direction2D> myDirections;
    private Graph myHorConstraintsGraph;
    private Graph myVerConstraintsGraph;
    private Map<Node, Node> myHorNodeMap;
    private Map<Node, Node> myVerNodeMap;
    private Map<Edge, Edge> myEdgeMap;
    private int myUnitLength = DEFAULT_UNIT_LENGTH;

    public ConstraintsGraph(EmbeddedGraph embeddedGraph, Map<Dart, Direction2D> directions) {
        this.myEmbeddedGraph = embeddedGraph;
        this.myGraph = embeddedGraph.getGraph();
        this.myDirections = directions;
    }

    public void constructGraph(Set<Face> facesToSkip) {
        this.getShape();
        for (Face face : ListSequence.fromList(this.myEmbeddedGraph.getFaces())) {
            if (this.myEmbeddedGraph.isOuterFace(face) || SetSequence.fromSet(facesToSkip).contains(face)) continue;
            this.makeShapeComplete(face);
        }
        if (DEBUG > 0) {
            if (TopologicalSorting.sort(this.myHorConstraintsGraph) == null) {
                throw new RuntimeException("horizontal constraints graph has cycles");
            }
            if (TopologicalSorting.sort(this.myVerConstraintsGraph) == null) {
                throw new RuntimeException("vertical constraints graph has cycles");
            }
        }
    }

    public Map<Node, Point> getCoordinates(Map<Edge, Integer> predefinedEdgeLengths, Map<Edge, Integer> constraintEdgeLengths) {
        IMapSequence<Edge, Integer> edgeLengths = MapSequence.fromMap(new HashMap());
        for (Edge edge : ListSequence.fromList(this.myHorConstraintsGraph.getEdges())) {
            MapSequence.fromMap(edgeLengths).put(edge, this.myUnitLength);
        }
        for (Edge edge : ListSequence.fromList(this.myVerConstraintsGraph.getEdges())) {
            MapSequence.fromMap(edgeLengths).put(edge, this.myUnitLength);
        }
        for (Edge edge : SetSequence.fromSet(MapSequence.fromMap(predefinedEdgeLengths).keySet())) {
            Edge constraintEdge = (Edge)MapSequence.fromMap(this.myEdgeMap).get(edge);
            MapSequence.fromMap(edgeLengths).put(constraintEdge, (Integer)MapSequence.fromMap(predefinedEdgeLengths).get(edge));
        }
        for (Edge edge : SetSequence.fromSet(MapSequence.fromMap(constraintEdgeLengths).keySet())) {
            MapSequence.fromMap(edgeLengths).put(edge, (Integer)MapSequence.fromMap(constraintEdgeLengths).get(edge));
        }
        Map<Node, Integer> horNumbering = WeightedTopologicalNumbering.number(this.myHorConstraintsGraph, edgeLengths);
        Map<Node, Integer> verNumbering = WeightedTopologicalNumbering.number(this.myVerConstraintsGraph, edgeLengths);
        IMapSequence<Node, Point> coordinates = MapSequence.fromMap(new HashMap());
        for (Node node : ListSequence.fromList(this.myGraph.getNodes())) {
            Node horSeg = (Node)MapSequence.fromMap(this.myHorNodeMap).get(node);
            Node verSeg = (Node)MapSequence.fromMap(this.myVerNodeMap).get(node);
            MapSequence.fromMap(coordinates).put(node, new Point((Integer)MapSequence.fromMap(verNumbering).get(verSeg), (Integer)MapSequence.fromMap(horNumbering).get(horSeg)));
        }
        return coordinates;
    }

    private void makeShapeComplete(Face face) {
        IListSequence<Node> segments = ListSequence.fromList(new LinkedList());
        IListSequence<Direction2D> directions = ListSequence.fromList(new LinkedList());
        IListSequence rotations = ListSequence.fromList(new LinkedList());
        Node prevSeg = null;
        for (Dart dart : ListSequence.fromList(face.getDarts())) {
            Direction2D dir = (Direction2D)((Object)MapSequence.fromMap(this.myDirections).get(dart));
            Node source = dart.getSource();
            Node seg = dir.isHorizontal() ? (Node)MapSequence.fromMap(this.myHorNodeMap).get(source) : (Node)MapSequence.fromMap(this.myVerNodeMap).get(source);
            if (seg != prevSeg) {
                if (prevSeg != null) {
                    ListSequence.fromList(rotations).addElement(((Direction2D)((Object)ListSequence.fromList(directions).last())).getTurn(dir));
                }
                ListSequence.fromList(segments).addElement(seg);
                ListSequence.fromList(directions).addElement(dir);
            }
            prevSeg = seg;
        }
        if (prevSeg != ListSequence.fromList(segments).first()) {
            ListSequence.fromList(rotations).addElement(((Direction2D)((Object)ListSequence.fromList(directions).last())).getTurn((Direction2D)((Object)ListSequence.fromList(directions).first())));
        } else {
            ListSequence.fromList(directions).removeLastElement();
            ListSequence.fromList(segments).removeLastElement();
        }
        if (SHOW_INFO > 0) {
            System.out.println(face);
            for (int i = 0; i < ListSequence.fromList(segments).count(); ++i) {
                System.out.println(String.valueOf(ListSequence.fromList(segments).getElement(i)) + " dir = " + String.valueOf((Object)ListSequence.fromList(directions).getElement(i)) + " rot = " + String.valueOf(ListSequence.fromList(rotations).getElement(i)));
            }
        }
        int numShifts = 0;
        while (ListSequence.fromList(segments).count() > 4) {
            if ((Integer)ListSequence.fromList(rotations).getElement(0) == -1 && (Integer)ListSequence.fromList(rotations).getElement(1) == 1 && (Integer)ListSequence.fromList(rotations).getElement(2) == 1) {
                this.connectPattern(segments, directions);
                for (int i = 0; i < 2; ++i) {
                    ListSequence.fromList(segments).removeElementAt(1);
                    ListSequence.fromList(rotations).removeElementAt(1);
                    ListSequence.fromList(directions).removeElementAt(1);
                }
                ListSequence.fromList(rotations).setElement(0, 1);
                numShifts = 0;
                continue;
            }
            ListSequence.fromList(segments).insertElement(0, ListSequence.fromList(segments).removeLastElement());
            ListSequence.fromList(rotations).insertElement(0, (Integer)ListSequence.fromList(rotations).removeLastElement());
            ListSequence.fromList(directions).insertElement(0, ListSequence.fromList(directions).removeLastElement());
            if (++numShifts <= 2 * ListSequence.fromList(segments).count()) continue;
            throw new RuntimeException("error in segments");
        }
        if (DEBUG > 0) {
            Iterator iterator = ListSequence.fromList(rotations).iterator();
            while (iterator.hasNext()) {
                int rotation = (Integer)iterator.next();
                if (rotation == 1) continue;
                throw new RuntimeException("bad face completion result!");
            }
        }
        this.connectPattern(segments, directions);
    }

    private void connectConstraintsNodes(Node node1, Node node2, Direction2D direction) {
        Graph graph = node1.getGraph();
        Edge connectingEdge = ListSequence.fromList(node1.getEdges()).findFirst(edge -> edge.getOpposite(node1) == node2);
        if (connectingEdge != null) {
            return;
        }
        Edge edge2 = direction == Direction2D.UP || direction == Direction2D.RIGHT ? graph.connect(node1, node2) : graph.connect(node2, node1);
        if (SHOW_INFO > 0) {
            if (direction.isHorizontal()) {
                System.out.println("added " + String.valueOf(edge2) + " to ver");
            } else {
                System.out.println("added " + String.valueOf(edge2) + " to hor");
            }
        }
    }

    private void connectPattern(List<Node> nodes, List<Direction2D> directions) {
        this.connectConstraintsNodes(ListSequence.fromList(nodes).getElement(0), ListSequence.fromList(nodes).getElement(2), ListSequence.fromList(directions).getElement(1));
        this.connectConstraintsNodes(ListSequence.fromList(nodes).getElement(1), ListSequence.fromList(nodes).getElement(3), ListSequence.fromList(directions).getElement(2));
    }

    private void getShape() {
        IMapSequence<Node, Node> horNodeMap = MapSequence.fromMap(new HashMap());
        Graph horConstraintsGraph = this.getDirectionConstraintsGraph(dir -> dir.isHorizontal(), horNodeMap);
        IMapSequence<Node, Node> verNodeMap = MapSequence.fromMap(new HashMap());
        Graph verConstraintsGraph = this.getDirectionConstraintsGraph(dir -> dir.isVertical(), verNodeMap);
        IMapSequence edgeMap = MapSequence.fromMap(new HashMap());
        for (Edge edge : ListSequence.fromList(this.myGraph.getEdges())) {
            Edge newEdge = this.connect(edge, Direction2D.RIGHT, verNodeMap);
            if (newEdge != null) {
                MapSequence.fromMap(edgeMap).put(edge, newEdge);
                continue;
            }
            MapSequence.fromMap(edgeMap).put(edge, this.connect(edge, Direction2D.UP, horNodeMap));
        }
        this.myHorConstraintsGraph = horConstraintsGraph;
        this.myVerConstraintsGraph = verConstraintsGraph;
        this.myHorNodeMap = horNodeMap;
        this.myVerNodeMap = verNodeMap;
        this.myEdgeMap = edgeMap;
        if (SHOW_INFO > 0) {
            System.out.println("constaints graph:");
            for (Node node : ListSequence.fromList(this.myGraph.getNodes())) {
                System.out.println("node " + String.valueOf(node));
                System.out.println("hor = " + String.valueOf(MapSequence.fromMap(horNodeMap).get(node)) + ", ver = " + String.valueOf(MapSequence.fromMap(verNodeMap).get(node)));
            }
            System.out.println("horizontal constraints graph: " + String.valueOf(horConstraintsGraph));
            System.out.println("vertical constraints graph: " + String.valueOf(verConstraintsGraph));
        }
    }

    private Edge connect(Edge realEdge, Direction2D direction, Map<Node, Node> nodeMap) {
        Dart dart = ListSequence.fromList(this.myEmbeddedGraph.getDarts(realEdge)).findFirst(it -> MapSequence.fromMap(this.myDirections).get(it) == direction);
        if (dart != null) {
            Node sourceNode = (Node)MapSequence.fromMap(nodeMap).get(dart.getSource());
            Node targetNode = (Node)MapSequence.fromMap(nodeMap).get(dart.getTarget());
            Graph graph = sourceNode.getGraph();
            return graph.connect(sourceNode, targetNode);
        }
        return null;
    }

    private Graph getDirectionConstraintsGraph(Predicate<? super Direction2D> directionFilter, Map<Node, Node> nodeMap) {
        Map<Node, Integer> components = ConnectivityComponents.getComponents(this.myGraph, edge -> {
            Dart dart = ListSequence.fromList(this.myEmbeddedGraph.getDarts((Edge)edge)).getElement(0);
            return directionFilter.test((Direction2D)((Object)((Object)MapSequence.fromMap(this.myDirections).get(dart))));
        });
        List<List<Node>> componentsList = ConnectivityComponents.getComponentsList(components);
        Graph constraintsCraph = new Graph();
        for (List list : ListSequence.fromList(componentsList)) {
            Node componentNode = constraintsCraph.createNode();
            for (Node node : ListSequence.fromList(list)) {
                MapSequence.fromMap(nodeMap).put(node, componentNode);
            }
        }
        return constraintsCraph;
    }

    private void checkCompleteness() {
        for (Node horSeg : ListSequence.fromList(this.myHorConstraintsGraph.getNodes())) {
            for (Node verSeg : ListSequence.fromList(this.myVerConstraintsGraph.getNodes())) {
                if (this.isSegmentsIntersect(horSeg, verSeg)) continue;
                if (SHOW_INFO > 0) {
                    System.out.println("found separated pair: hor = " + String.valueOf(horSeg) + ", ver = " + String.valueOf(verSeg));
                }
                Object[] horEnds = this.getSegmentEndSegments(horSeg, Direction2D.RIGHT);
                Object[] verEnds = this.getSegmentEndSegments(verSeg, Direction2D.UP);
                if (SHOW_INFO > 0) {
                    System.out.println("hor ends: " + Arrays.toString(horEnds));
                    System.out.println("ver ends: " + Arrays.toString(verEnds));
                }
                boolean isSeparated = false;
                isSeparated |= this.hasPath(this.myHorConstraintsGraph, horSeg, (Node[])verEnds);
                if (isSeparated |= this.hasPath(this.myVerConstraintsGraph, verSeg, (Node[])horEnds)) continue;
                throw new RuntimeException("pair is not separated in constraints graph!!!");
            }
        }
    }

    private boolean hasPath(Graph graph, Node node, Node[] ends) {
        if (ShortestPath.getPath(graph, node, ends[0], Edge.Direction.FRONT) != null) {
            return true;
        }
        return ShortestPath.getPath(graph, ends[1], node, Edge.Direction.FRONT) != null;
    }

    private boolean isSegmentsIntersect(Node horSegment, Node verSegment) {
        ISequence<Node> horNodes = SetSequence.fromSet(MapSequence.fromMap(this.myHorNodeMap).keySet()).where(key -> MapSequence.fromMap(this.myHorNodeMap).get(key) == horSegment);
        ISequence<Node> verNodes = SetSequence.fromSet(MapSequence.fromMap(this.myVerNodeMap).keySet()).where(key -> MapSequence.fromMap(this.myVerNodeMap).get(key) == verSegment);
        boolean intersects = false;
        for (Node node : Sequence.fromIterable(horNodes)) {
            intersects |= Sequence.fromIterable(verNodes).contains(node);
        }
        return intersects;
    }

    private Node[] getSegmentEndSegments(Node segment, Direction2D direction) {
        Node[] ends = this.getSegmentEnds(segment, direction);
        Map<Node, Node> nodeMap = direction.isHorizontal() ? this.myVerNodeMap : this.myHorNodeMap;
        for (int i = 0; i < ends.length; ++i) {
            ends[i] = (Node)MapSequence.fromMap(nodeMap).get(ends[i]);
        }
        return ends;
    }

    private Node[] getSegmentEnds(Node segment, Direction2D direction) {
        Wrappers._T nodeMap = new Wrappers._T();
        nodeMap.value = direction.isHorizontal() ? this.myHorNodeMap : this.myVerNodeMap;
        ISequence<Node> nodes = SetSequence.fromSet(MapSequence.fromMap((Map)nodeMap.value).keySet()).where(key -> MapSequence.fromMap((Map)nodeMap.value).get(key) == segment);
        ISetSequence firstCandidates = SetSequence.fromSet(new HashSet());
        SetSequence.fromSet(firstCandidates).addSequence(Sequence.fromIterable(nodes));
        Node[] ends = new Node[2];
        for (Node node : Sequence.fromIterable(nodes)) {
            Dart dart = ListSequence.fromList(this.myEmbeddedGraph.getDartWithSource(node)).findFirst(it -> MapSequence.fromMap(this.myDirections).get(it) == direction);
            if (dart == null) {
                if (DEBUG > 0 && ends[1] != null) {
                    throw new RuntimeException("found two last nodes for seg " + String.valueOf(segment) + " by dir " + String.valueOf((Object)direction));
                }
                ends[1] = node;
                continue;
            }
            SetSequence.fromSet(firstCandidates).removeElement(dart.getTarget());
        }
        if (SetSequence.fromSet(firstCandidates).count() != 1) {
            throw new RuntimeException("failed to find first node for seg " + String.valueOf(segment) + " by dir " + String.valueOf((Object)direction));
        }
        if (ends[1] == null) {
            throw new RuntimeException("failed to find last node for seg " + String.valueOf(segment) + " by dir " + String.valueOf((Object)direction));
        }
        ends[0] = (Node)SetSequence.fromSet(firstCandidates).first();
        return ends;
    }

    public int getUnitLength() {
        return this.myUnitLength;
    }

    public void setUnitLength(int unitLength) {
        this.myUnitLength = unitLength;
    }

    public Edge addConstraintEdge(Node first, Node second, Direction2D direction) {
        Node target;
        Node source;
        Map<Node, Node> constraintsMap = direction.isHorizontal() ? this.myVerNodeMap : this.myHorNodeMap;
        if (direction == Direction2D.RIGHT || direction == Direction2D.UP) {
            source = (Node)MapSequence.fromMap(constraintsMap).get(first);
            target = (Node)MapSequence.fromMap(constraintsMap).get(second);
        } else {
            source = (Node)MapSequence.fromMap(constraintsMap).get(second);
            target = (Node)MapSequence.fromMap(constraintsMap).get(first);
        }
        Graph graph = source.getGraph();
        return graph.connect(source, target);
    }
}

