/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.flowOrthogonalLayout;

import com.vertabelo.autolayout_tool.repackaged.mps.baseLanguage.closures.runtime.Wrappers;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.INode;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Direction2D;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.Dart;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.EmbeddedGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.Face;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IMapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISetSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ITranslator2;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.Sequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.SetSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.backports.LinkedList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EmbeddedGraphModifier {
    private static int SHOW_LOG = 0;
    private Graph myGraph;
    private EmbeddedGraph myEmbeddedGraph;
    private Map<Dart, Direction2D> myDartDirections;
    private Map<Node, Node[]> myCornerNodes;
    private Map<Node, Face> myNodeFaces;

    public EmbeddedGraphModifier(EmbeddedGraph embeddedGraph) {
        this.myGraph = embeddedGraph.getGraph();
        this.myEmbeddedGraph = embeddedGraph;
        this.myCornerNodes = MapSequence.fromMap(new HashMap());
        this.myNodeFaces = MapSequence.fromMap(new HashMap());
    }

    public void setDartDirections(Map<Dart, Direction2D> dartDirections) {
        this.myDartDirections = dartDirections;
    }

    public Map<Edge, Edge> makeRectanglesForNodes(Iterable<Node> nodesToProcess) {
        IMapSequence<Edge, Edge> modifiedEdges = MapSequence.fromMap(new HashMap());
        for (Node node : Sequence.fromIterable(nodesToProcess)) {
            MapSequence.fromMap(this.myCornerNodes).put(node, new Node[4]);
            this.makeRectangleForSingleNode(node, modifiedEdges);
            if (SHOW_LOG <= 0) continue;
            System.out.println("corner nodes for node " + String.valueOf(node) + ":");
            for (Direction2D dir : Direction2D.values()) {
                System.out.println(String.valueOf((Object)dir) + " = " + String.valueOf(((Node[])MapSequence.fromMap(this.myCornerNodes).get(node))[dir.ordinal()]));
            }
        }
        return modifiedEdges;
    }

    public Map<Edge, Edge> makeRectanglesForNodes(Map<Node, List<Node>> nodesToProcess) {
        IMapSequence<Edge, Edge> modifiedEdges = MapSequence.fromMap(new HashMap());
        for (Node node : SetSequence.fromSet(MapSequence.fromMap(nodesToProcess).keySet())) {
            MapSequence.fromMap(this.myCornerNodes).put(node, new Node[4]);
            List nodes = (List)MapSequence.fromMap(nodesToProcess).get(node);
            if (ListSequence.fromList(nodes).count() == 0) {
                this.makeRectangleForSingleNode(node, modifiedEdges);
            } else {
                this.makeRectangleForSplittedNode(node, (List)MapSequence.fromMap(nodesToProcess).get(node));
            }
            if (SHOW_LOG <= 0) continue;
            System.out.println("corner nodes for node " + String.valueOf(node) + ":");
            for (Direction2D dir : Direction2D.values()) {
                System.out.println(String.valueOf((Object)dir) + " = " + String.valueOf(((Node[])MapSequence.fromMap(this.myCornerNodes).get(node))[dir.ordinal()]));
            }
        }
        return modifiedEdges;
    }

    public void makerInnerFaces() {
        for (Node node : SetSequence.fromSet(MapSequence.fromMap(this.myCornerNodes).keySet())) {
            this.makeInnerFace(node);
        }
    }

    private void makeInnerFace(Node node) {
        Node[] nodes = (Node[])MapSequence.fromMap(this.myCornerNodes).get(node);
        Face face = (Face)MapSequence.fromMap(this.myNodeFaces).get(node);
        for (int intDir = 0; intDir < 4; ++intDir) {
            Node cur = nodes[intDir];
            Node next = intDir == 3 ? nodes[0] : nodes[intDir + 1];
            Edge newEdge = this.myGraph.connect(cur, next);
            this.myEmbeddedGraph.splitFace(face, ListSequence.fromListAndArray(new ArrayList(), newEdge), cur, next);
            Dart dart = this.myEmbeddedGraph.getSourceDart(newEdge, cur);
            MapSequence.fromMap(this.myDartDirections).put(dart, Direction2D.get(intDir));
            MapSequence.fromMap(this.myDartDirections).put(this.myEmbeddedGraph.getOpposite(dart), Direction2D.get(intDir).opposite());
            face = this.myEmbeddedGraph.getFace(dart);
        }
        MapSequence.fromMap(this.myNodeFaces).put(node, face);
    }

    public void makeRectangleForSplittedNode(Node node, List<Node> nodes) {
        Wrappers._T<Node> prev = new Wrappers._T<Node>(ListSequence.fromList(nodes).getElement(ListSequence.fromList(nodes).count() - 2));
        Wrappers._T<Node> cur = new Wrappers._T<Node>(ListSequence.fromList(nodes).getElement(ListSequence.fromList(nodes).count() - 1));
        Edge prevToCurEdge = ListSequence.fromList(((Node)prev.value).getEdges()).findFirst(edge -> edge.getOpposite((INode)prev.value) == cur.value);
        IMapSequence toSplit = MapSequence.fromMap(new HashMap());
        for (Node next : ListSequence.fromList(nodes)) {
            Direction2D curToNextDir;
            Direction2D prevToCurDir;
            Edge curToNextEdge = ListSequence.fromList(((Node)cur.value).getEdges()).findFirst(edge -> edge.getOpposite((INode)cur.value) == next);
            Dart prevToCurDart = this.myEmbeddedGraph.getSourceDart(prevToCurEdge, (Node)prev.value);
            Dart curToNextDart = this.myEmbeddedGraph.getSourceDart(curToNextEdge, (Node)cur.value);
            if (!MapSequence.fromMap(this.myNodeFaces).containsKey(node)) {
                MapSequence.fromMap(this.myNodeFaces).put(node, this.myEmbeddedGraph.getFace(prevToCurDart));
            }
            if ((prevToCurDir = (Direction2D)((Object)MapSequence.fromMap(this.myDartDirections).get(prevToCurDart))) != (curToNextDir = (Direction2D)((Object)MapSequence.fromMap(this.myDartDirections).get(curToNextDart)))) {
                Edge curRealEdge = ListSequence.fromList(((Node)cur.value).getEdges()).findFirst(edge -> !ListSequence.fromList(nodes).contains(edge.getOpposite((INode)cur.value)));
                Dart curRealDart = this.myEmbeddedGraph.getSourceDart(curRealEdge, (Node)cur.value);
                Edge edgeToSplit = MapSequence.fromMap(this.myDartDirections).get(curRealDart) == prevToCurDir ? prevToCurEdge : curToNextEdge;
                if (MapSequence.fromMap(toSplit).containsKey(edgeToSplit)) {
                    MapSequence.fromMap(toSplit).put(edgeToSplit, (Integer)MapSequence.fromMap(toSplit).get(edgeToSplit) + 1);
                } else {
                    MapSequence.fromMap(toSplit).put(edgeToSplit, 1);
                }
            }
            prev.value = cur.value;
            cur.value = next;
            prevToCurEdge = curToNextEdge;
        }
        for (Edge edge2 : SetSequence.fromSet(MapSequence.fromMap(toSplit).keySet())) {
            int splitNum = (Integer)MapSequence.fromMap(toSplit).get(edge2);
            Wrappers._T<Edge> curEdge = new Wrappers._T<Edge>(edge2);
            Direction2D curDirection = null;
            for (int i = 0; i < splitNum; ++i) {
                IListSequence toRemove = ListSequence.fromList(new ArrayList());
                ListSequence.fromList(toRemove).addSequence(ListSequence.fromList(this.myEmbeddedGraph.getDarts((Edge)curEdge.value)));
                if (curDirection == null) {
                    Node curSource = ((Edge)curEdge.value).getSource();
                    Edge realEdge = ListSequence.fromList(curSource.getEdges()).findFirst(_edge -> !ListSequence.fromList(nodes).contains(_edge.getOpposite(curSource)));
                    curDirection = ((Direction2D)((Object)MapSequence.fromMap(this.myDartDirections).get(this.myEmbeddedGraph.getSourceDart(realEdge, curSource)))).turnClockwise(1);
                }
                IListSequence<Edge> newEdges = ListSequence.fromList(new ArrayList());
                Node newNode = this.myEmbeddedGraph.splitEdge((Edge)curEdge.value, newEdges);
                Dart firstDart = ListSequence.fromList(this.myEmbeddedGraph.getDarts(ListSequence.fromList(newEdges).getElement(0))).findFirst(dart -> dart.getSource() == ((Edge)curEdge.value).getSource());
                MapSequence.fromMap(this.myDartDirections).put(firstDart, curDirection);
                MapSequence.fromMap(this.myDartDirections).put(this.myEmbeddedGraph.getOpposite(firstDart), curDirection.opposite());
                Dart secondDart = ListSequence.fromList(this.myEmbeddedGraph.getDarts(ListSequence.fromList(newEdges).getElement(1))).findFirst(dart -> dart.getTarget() == ((Edge)curEdge.value).getTarget());
                Direction2D nextDirection = curDirection.turnClockwise(1);
                ((Node[])MapSequence.fromMap(this.myCornerNodes).get((Object)node))[nextDirection.ordinal()] = newNode;
                MapSequence.fromMap(this.myDartDirections).put(secondDart, nextDirection);
                MapSequence.fromMap(this.myDartDirections).put(this.myEmbeddedGraph.getOpposite(secondDart), nextDirection.opposite());
                for (Dart dartToRemove : ListSequence.fromList(toRemove)) {
                    MapSequence.fromMap(this.myDartDirections).removeKey(dartToRemove);
                }
                curEdge.value = ListSequence.fromList(newEdges).getElement(1);
                curDirection = nextDirection;
            }
        }
    }

    public void makeRectangleForSingleNode(Node node, Map<Edge, Edge> modifiedEdges) {
        Node firstCornerNode;
        List<Direction2D> allDirections = List.of(Direction2D.values());
        List<Dart> darts = this.myEmbeddedGraph.getDartWithSource(node);
        Face nodeInnerFace = new Face(this.myGraph);
        Node curCornerNode = firstCornerNode = this.myGraph.createDummyNode();
        IMapSequence edgesFromNode = MapSequence.fromMap(new HashMap());
        IListSequence<Dart> nodeOuterDarts = ListSequence.fromList(new LinkedList());
        for (Direction2D dir : ListSequence.fromList(allDirections)) {
            ((Node[])MapSequence.fromMap(this.myCornerNodes).get((Object)node))[dir.turnClockwise((int)1).ordinal()] = curCornerNode;
            Node nextCornerNode = dir == ListSequence.fromList(allDirections).last() ? firstCornerNode : this.myGraph.createDummyNode();
            Dart dirDart = ListSequence.fromList(darts).findFirst(dart -> MapSequence.fromMap(this.myDartDirections).get(dart) == dir);
            if (dirDart == null) {
                this.addToNodeFace(nodeInnerFace, this.myGraph.connect(curCornerNode, nextCornerNode), dir, nodeOuterDarts);
            } else {
                Node newNode = this.myGraph.createDummyNode();
                MapSequence.fromMap(edgesFromNode).put(dirDart, this.myGraph.connect(newNode, dirDart.getTarget()));
                this.addToNodeFace(nodeInnerFace, this.myGraph.connect(curCornerNode, newNode), dir, nodeOuterDarts);
                this.addToNodeFace(nodeInnerFace, this.myGraph.connect(newNode, nextCornerNode), dir, nodeOuterDarts);
            }
            curCornerNode = nextCornerNode;
        }
        IMapSequence endEdges = MapSequence.fromMap(new HashMap());
        for (Dart dart2 : ListSequence.fromList(darts)) {
            MapSequence.fromMap(modifiedEdges).put(dart2.getEdge(), (Edge)MapSequence.fromMap(edgesFromNode).get(dart2));
            List<Dart> faceDarts = this.myEmbeddedGraph.getFace(dart2).getDarts();
            int prevIndex = ListSequence.fromList(faceDarts).indexOf(dart2) - 1;
            if (prevIndex == -1) {
                prevIndex = ListSequence.fromList(faceDarts).count() - 1;
            }
            MapSequence.fromMap(endEdges).put(dart2, (Edge)MapSequence.fromMap(edgesFromNode).get(this.myEmbeddedGraph.getOpposite(ListSequence.fromList(faceDarts).getElement(prevIndex))));
        }
        for (Dart dart2 : ListSequence.fromList(darts)) {
            Dart cur;
            Face face = this.myEmbeddedGraph.getFace(dart2);
            List<Dart> faceDarts = face.getDarts();
            int dartIndex = ListSequence.fromList(faceDarts).indexOf(dart2);
            int prevIndex = dartIndex - 1;
            if (prevIndex == -1) {
                prevIndex = ListSequence.fromList(faceDarts).count() - 1;
            }
            Dart prevDart = ListSequence.fromList(faceDarts).getElement(prevIndex);
            Edge startEdge = (Edge)MapSequence.fromMap(edgesFromNode).get(dart2);
            Edge endEdge = (Edge)MapSequence.fromMap(endEdges).get(dart2);
            Node start = startEdge.getSource();
            Node end = endEdge.getSource();
            IListSequence newDarts = ListSequence.fromList(new LinkedList());
            Iterator dartItr = ListSequence.fromList(nodeOuterDarts).iterator();
            while ((cur = (Dart)dartItr.next()).getTarget() != start) {
            }
            do {
                ListSequence.fromList(newDarts).insertElement(0, cur);
                if (dartItr.hasNext()) continue;
                dartItr = ListSequence.fromList(nodeOuterDarts).iterator();
            } while ((cur = (Dart)dartItr.next()).getTarget() != end);
            Dart newStartDart = new Dart(startEdge, start);
            ListSequence.fromList(newDarts).addElement(newStartDart);
            MapSequence.fromMap(this.myDartDirections).put(newStartDart, (Direction2D)((Object)MapSequence.fromMap(this.myDartDirections).get(dart2)));
            Dart newEndDart = new Dart(endEdge, endEdge.getTarget());
            ListSequence.fromList(newDarts).insertElement(0, newEndDart);
            MapSequence.fromMap(this.myDartDirections).put(newEndDart, (Direction2D)((Object)MapSequence.fromMap(this.myDartDirections).get(prevDart)));
            this.myEmbeddedGraph.removeDart(face, dart2);
            face.makeEndsWith(prevDart);
            this.myEmbeddedGraph.removeDart(face, prevDart);
            for (Dart newDart : ListSequence.fromList(newDarts)) {
                this.myEmbeddedGraph.addLastDart(face, newDart);
            }
            MapSequence.fromMap(this.myDartDirections).removeKey(dart2);
            MapSequence.fromMap(this.myDartDirections).removeKey(prevDart);
        }
        MapSequence.fromMap(this.myNodeFaces).put(node, nodeInnerFace);
        this.myEmbeddedGraph.addFace(nodeInnerFace);
        this.myGraph.deleteNode(node);
    }

    private void addToNodeFace(Face nodeFace, Edge edge, Direction2D dir, List<Dart> outerDarts) {
        Dart innerDart = new Dart(edge, edge.getSource());
        nodeFace.addLast(innerDart);
        MapSequence.fromMap(this.myDartDirections).put(innerDart, dir.turnClockwise(1));
        Dart outerDart = new Dart(edge, edge.getTarget());
        MapSequence.fromMap(this.myDartDirections).put(outerDart, ((Direction2D)((Object)MapSequence.fromMap(this.myDartDirections).get(innerDart))).opposite());
        ListSequence.fromList(outerDarts).addElement(outerDart);
    }

    public Set<Edge> reduceNodesDegree(Map<Node, List<Node>> nodeMap, Map<Edge, Edge> edgeMap) {
        return this.reduceNodesDegree(nodeMap, edgeMap, false);
    }

    public Set<Edge> reduceNodesDegree(Map<Node, List<Node>> nodeMap, Map<Edge, Edge> edgeMap, boolean splitAllNodes) {
        ISetSequence<Edge> addedEdges = SetSequence.fromSet(new HashSet());
        IListSequence realNodes = ListSequence.fromList(new ArrayList());
        ListSequence.fromList(realNodes).addSequence((ISequence)ListSequence.fromList(this.myGraph.getNodes()));
        for (Node node : ListSequence.fromList(realNodes)) {
            Node firstNewNode;
            Dart firstDart;
            Iterable edges = node.getEdges();
            if (!splitAllNodes && ListSequence.fromList(edges).count() <= 4) continue;
            IListSequence newNodes = ListSequence.fromList(new ArrayList());
            MapSequence.fromMap(nodeMap).put(node, newNodes);
            Edge firstEdge = (Edge)ListSequence.fromList(edges).first();
            Dart curDart = firstDart = ListSequence.fromList(this.myEmbeddedGraph.getDarts(firstEdge)).findFirst(dart -> dart.getSource() == node);
            Node curNewNode = firstNewNode = this.myGraph.createDummyNode();
            Edge firstNewEdge = this.myGraph.connect(firstNewNode, firstEdge.getOpposite(node));
            if (firstEdge.getSource() == node) {
                this.myGraph.removeEdge(firstEdge);
            }
            ListSequence.fromList(newNodes).addElement(firstNewNode);
            MapSequence.fromMap(edgeMap).put(firstEdge, firstNewEdge);
            Edge curNewEdge = firstNewEdge;
            Face newFace = new Face(this.myGraph);
            do {
                Edge nextNewEdge;
                Node nextNewNode;
                Dart nextDart;
                Face curFace;
                List<Dart> darts;
                int curPos;
                int nextPos;
                if ((nextPos = (curPos = ListSequence.fromList(darts = (curFace = this.myEmbeddedGraph.getFace(curDart)).getDarts()).indexOf(curDart)) - 1) == -1) {
                    nextPos = ListSequence.fromList(darts).count() - 1;
                }
                if ((nextDart = this.myEmbeddedGraph.getOpposite(ListSequence.fromList(darts).getElement(nextPos))) == null) {
                    nextDart = firstDart;
                }
                Node oppositeNode = nextDart.getEdge().getOpposite(node);
                if (nextDart == firstDart) {
                    nextNewNode = firstNewNode;
                } else {
                    nextNewNode = this.myGraph.createDummyNode();
                    ListSequence.fromList(newNodes).addElement(nextNewNode);
                }
                if (nextDart == firstDart) {
                    nextNewEdge = firstNewEdge;
                } else {
                    nextNewEdge = this.myGraph.connect(nextNewNode, oppositeNode);
                    if (firstEdge.getSource() == node) {
                        this.myGraph.removeEdge(firstEdge);
                    }
                    MapSequence.fromMap(edgeMap).put(nextDart.getEdge(), nextNewEdge);
                }
                Edge edgeBetweenNewNodes = this.myGraph.connect(curNewNode, nextNewNode);
                SetSequence.fromSet(addedEdges).addElement(edgeBetweenNewNodes);
                newFace.addLast(new Dart(edgeBetweenNewNodes, curNewNode));
                this.myEmbeddedGraph.setDart(curFace, nextPos, new Dart(nextNewEdge, oppositeNode));
                this.myEmbeddedGraph.setDart(curFace, curPos, new Dart(curNewEdge, curNewNode));
                this.myEmbeddedGraph.insertDart(curFace, nextPos + 1, new Dart(edgeBetweenNewNodes, nextNewNode));
                curDart = nextDart;
                curNewNode = nextNewNode;
                curNewEdge = nextNewEdge;
            } while (curDart != firstDart);
            this.myEmbeddedGraph.addFace(newFace);
            this.myGraph.deleteNode(node);
        }
        for (Edge edge : SetSequence.fromSet(MapSequence.fromMap(edgeMap).keySet())) {
            Edge newEdge = (Edge)MapSequence.fromMap(edgeMap).get(edge);
            if (!MapSequence.fromMap(edgeMap).containsKey(newEdge)) continue;
            MapSequence.fromMap(edgeMap).put(edge, (Edge)MapSequence.fromMap(edgeMap).get(newEdge));
        }
        return addedEdges;
    }

    public void makeRectangularFaces() {
        IListSequence faces = ListSequence.fromList(new ArrayList());
        ListSequence.fromList(faces).addSequence(ListSequence.fromList(this.myEmbeddedGraph.getFaces()));
        for (Face face : ListSequence.fromList(faces)) {
            if (this.myEmbeddedGraph.isOuterFace(face)) continue;
            this.makeFaceRectangle(face);
        }
    }

    public void makeFaceRectangle(Face face) {
        Dart cur;
        Dart badDart = null;
        List<Dart> darts = face.getDarts();
        Iterator dartItr = ListSequence.fromList(darts).iterator();
        Dart prev = (Dart)ListSequence.fromList(darts).last();
        int sum = 0;
        while (dartItr.hasNext() && badDart == null) {
            cur = (Dart)dartItr.next();
            int turn = ((Direction2D)((Object)MapSequence.fromMap(this.myDartDirections).get(prev))).getTurn((Direction2D)((Object)MapSequence.fromMap(this.myDartDirections).get(cur)));
            if (turn < 0) {
                badDart = prev;
                sum = turn;
            }
            prev = cur;
        }
        while (sum != 1) {
            if (!dartItr.hasNext()) {
                dartItr = ListSequence.fromList(darts).iterator();
            }
            cur = (Dart)dartItr.next();
            sum += ((Direction2D)((Object)MapSequence.fromMap(this.myDartDirections).get(prev))).getTurn((Direction2D)((Object)MapSequence.fromMap(this.myDartDirections).get(cur)));
            prev = cur;
        }
        if (badDart != null) {
            IListSequence<Edge> newEdges = ListSequence.fromList(new ArrayList());
            Dart prevOpposite = this.myEmbeddedGraph.getOpposite(prev);
            Node newNode = this.myEmbeddedGraph.splitEdge(prev.getEdge(), newEdges);
            for (Edge newEdge : ListSequence.fromList(newEdges)) {
                for (Dart newDart : ListSequence.fromList(this.myEmbeddedGraph.getDarts(newEdge))) {
                    if (this.myEmbeddedGraph.getFace(newDart) == face) {
                        MapSequence.fromMap(this.myDartDirections).put(newDart, (Direction2D)((Object)MapSequence.fromMap(this.myDartDirections).get(prev)));
                        continue;
                    }
                    MapSequence.fromMap(this.myDartDirections).put(newDart, ((Direction2D)((Object)MapSequence.fromMap(this.myDartDirections).get(prev))).opposite());
                }
            }
            MapSequence.fromMap(this.myDartDirections).removeKey(prev);
            MapSequence.fromMap(this.myDartDirections).removeKey(prevOpposite);
            Node badCorner = badDart.getTarget();
            Edge splitEdge = this.myGraph.connect(badCorner, newNode);
            List<Face> newFaces = this.myEmbeddedGraph.splitFace(face, ListSequence.fromListAndArray(new ArrayList(), splitEdge), badCorner, newNode);
            for (Dart dart : ListSequence.fromList(this.myEmbeddedGraph.getDarts(splitEdge))) {
                if (dart.getSource() == badCorner) {
                    MapSequence.fromMap(this.myDartDirections).put(dart, (Direction2D)((Object)MapSequence.fromMap(this.myDartDirections).get(badDart)));
                    continue;
                }
                MapSequence.fromMap(this.myDartDirections).put(dart, ((Direction2D)((Object)MapSequence.fromMap(this.myDartDirections).get(badDart))).opposite());
            }
            for (Face newFace : ListSequence.fromList(newFaces)) {
                this.makeFaceRectangle(newFace);
            }
        }
    }

    public void connectSpecialNodes(Iterable<Node> specialNodes) {
        IListSequence oldFaces = ListSequence.fromList(new ArrayList());
        ListSequence.fromList(oldFaces).addSequence(ListSequence.fromList(this.myEmbeddedGraph.getFaces()));
        ListSequence.fromList(oldFaces).removeElement(this.myEmbeddedGraph.getOuterFace());
        for (Face face : ListSequence.fromList(oldFaces)) {
            this.connectSpecialNodesInFace(face, specialNodes);
        }
    }

    private void connectSpecialNodesInFace(Face face, Iterable<Node> specialNodes) {
        List<Dart> darts = face.getDarts();
        Direction2D prevDir = (Direction2D)((Object)MapSequence.fromMap(this.myDartDirections).get(ListSequence.fromList(darts).last()));
        Node node = null;
        Direction2D dir = null;
        Dart dartToSplit = null;
        for (Dart dart : ListSequence.fromList(darts)) {
            Direction2D opposite;
            Object oppositeDarts;
            node = dart.getSource();
            dir = (Direction2D)((Object)MapSequence.fromMap(this.myDartDirections).get(dart));
            if (Sequence.fromIterable(specialNodes).contains(node) && prevDir == dir && ListSequence.fromList(oppositeDarts = this.getDirectionDarts(face, opposite = ((Direction2D)((Object)MapSequence.fromMap(this.myDartDirections).get(dart))).opposite())).count() == 1) {
                dartToSplit = (Dart)ListSequence.fromList(oppositeDarts).first();
                break;
            }
            prevDir = dir;
        }
        if (dartToSplit != null) {
            Edge edgeToSplit = dartToSplit.getEdge();
            for (Dart dart : ListSequence.fromList(this.myEmbeddedGraph.getDarts(edgeToSplit))) {
                MapSequence.fromMap(this.myDartDirections).removeKey(dart);
            }
            IListSequence<Edge> iListSequence = ListSequence.fromList(new ArrayList());
            Node newNode = this.myEmbeddedGraph.splitEdge(edgeToSplit, iListSequence);
            for (Dart dart : ListSequence.fromList(iListSequence).translate(new ITranslator2<Edge, Dart>(){

                @Override
                public Iterable<Dart> translate(Edge it) {
                    return EmbeddedGraphModifier.this.myEmbeddedGraph.getDarts(it);
                }
            })) {
                if (this.myEmbeddedGraph.getFace(dart) == face) {
                    MapSequence.fromMap(this.myDartDirections).put(dart, dir.opposite());
                    continue;
                }
                MapSequence.fromMap(this.myDartDirections).put(dart, dir);
            }
            Edge splittingEdge = this.myGraph.connect(node, newNode);
            List<Face> newFaces = this.myEmbeddedGraph.splitFace(face, ListSequence.fromListAndArray(new ArrayList(), splittingEdge), node, newNode);
            for (Dart dart : ListSequence.fromList(this.myEmbeddedGraph.getDarts(splittingEdge))) {
                if (dart.getSource() == node) {
                    MapSequence.fromMap(this.myDartDirections).put(dart, dir.turnClockwise(1));
                    continue;
                }
                MapSequence.fromMap(this.myDartDirections).put(dart, dir.turnClockwise(1).opposite());
            }
            for (Face newFace : ListSequence.fromList(newFaces)) {
                this.connectSpecialNodesInFace(newFace, specialNodes);
            }
        }
    }

    private List<Dart> getDirectionDarts(Face face, Direction2D direction) {
        IListSequence<Dart> directionDarts = ListSequence.fromList(new LinkedList());
        List<Dart> darts = face.getDarts();
        Iterator dartItr = ListSequence.fromList(darts).iterator();
        Dart cur = (Dart)dartItr.next();
        while (dartItr.hasNext() && MapSequence.fromMap(this.myDartDirections).get(cur) != direction) {
            cur = (Dart)dartItr.next();
        }
        while (MapSequence.fromMap(this.myDartDirections).get(cur) == direction) {
            ListSequence.fromList(directionDarts).addElement(cur);
            if (!dartItr.hasNext()) {
                dartItr = ListSequence.fromList(darts).iterator();
            }
            cur = (Dart)dartItr.next();
        }
        return directionDarts;
    }

    public EmbeddedGraph getEmbeddedGraph() {
        return this.myEmbeddedGraph;
    }

    public Map<Dart, Direction2D> getDartDirections() {
        return this.myDartDirections;
    }

    public Face getNodeFace(Node node) {
        return (Face)MapSequence.fromMap(this.myNodeFaces).get(node);
    }

    public Node[] getCornerNodes(Node node) {
        return (Node[])MapSequence.fromMap(this.myCornerNodes).get(node);
    }

    public Map<Node, Face> getNodeFaces() {
        return this.myNodeFaces;
    }
}

