/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.flowOrthogonalLayout;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Dimension;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Direction2D;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.Dart;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.EmbeddedGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.Face;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IMapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.SetSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.backports.LinkedList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NodeBoxesMaker {
    private static int SHOW_INFO = 0;
    private Graph myGraph;
    private EmbeddedGraph myEmbeddedGraph;
    private Map<Dart, Direction2D> myDirections;
    private Set<Face> myBoxFaces;
    private Map<Edge, Integer> myBoxEdgeLengths;

    public NodeBoxesMaker(EmbeddedGraph embeddedGraph, Map<Dart, Direction2D> directions) {
        this.myGraph = embeddedGraph.getGraph();
        this.myEmbeddedGraph = embeddedGraph;
        this.myDirections = directions;
        this.myBoxFaces = SetSequence.fromSet(new HashSet());
        this.myBoxEdgeLengths = MapSequence.fromMap(new HashMap());
    }

    public void makeBoxes(Map<Node, Dimension> nodeSizes) {
        if (SHOW_INFO > 0) {
            System.out.println("Making boxes for nodes");
            System.out.println("initial graph: ");
            this.printEmbeddedGraph();
        }
        IListSequence nodes = ListSequence.fromList(new ArrayList());
        ListSequence.fromList(nodes).addSequence((ISequence)SetSequence.fromSet(MapSequence.fromMap(nodeSizes).keySet()));
        for (Node node : ListSequence.fromList(nodes)) {
            IListSequence oldEdges = ListSequence.fromList(new ArrayList());
            ListSequence.fromList(oldEdges).addSequence((ISequence)ListSequence.fromList(node.getEdges()));
            for (Edge oldEdge : ListSequence.fromList(oldEdges)) {
                this.splitEdge(oldEdge);
            }
            Map<Direction2D, List<Edge>> rectEdges = this.makeRectangleForNode(node);
            for (Direction2D dir : Direction2D.values()) {
                int length = ((Dimension)MapSequence.fromMap(nodeSizes).get((Object)node)).width;
                if (dir.isVertical()) {
                    length = ((Dimension)MapSequence.fromMap(nodeSizes).get((Object)node)).height;
                }
                List edges = (List)MapSequence.fromMap(rectEdges).get((Object)dir);
                int edgeLength = length / ListSequence.fromList(edges).count();
                for (Edge edge : ListSequence.fromList(edges)) {
                    if (edge == ListSequence.fromList(edges).last()) {
                        MapSequence.fromMap(this.myBoxEdgeLengths).put(edge, length - edgeLength * (ListSequence.fromList(edges).count() - 1));
                        continue;
                    }
                    MapSequence.fromMap(this.myBoxEdgeLengths).put(edge, edgeLength);
                }
            }
        }
        if (SHOW_INFO > 0) {
            System.out.println("after modification: ");
            this.printEmbeddedGraph();
        }
    }

    private Node splitEdge(Edge oldEdge) {
        Node source = oldEdge.getSource();
        Node target = oldEdge.getTarget();
        Dart sourceDart = this.myEmbeddedGraph.getSourceDart(oldEdge, source);
        Dart targetDart = this.myEmbeddedGraph.getSourceDart(oldEdge, target);
        IListSequence<Edge> edges = ListSequence.fromList(new ArrayList());
        Node node = this.myEmbeddedGraph.splitEdge(oldEdge, edges);
        for (Edge edge : ListSequence.fromList(edges)) {
            for (Dart dart : ListSequence.fromList(this.myEmbeddedGraph.getDarts(edge))) {
                if (dart.getSource() == source || dart.getTarget() == target) {
                    MapSequence.fromMap(this.myDirections).put(dart, (Direction2D)((Object)MapSequence.fromMap(this.myDirections).get(sourceDart)));
                    continue;
                }
                MapSequence.fromMap(this.myDirections).put(dart, (Direction2D)((Object)MapSequence.fromMap(this.myDirections).get(targetDart)));
            }
        }
        MapSequence.fromMap(this.myDirections).removeKey(sourceDart);
        MapSequence.fromMap(this.myDirections).removeKey(targetDart);
        return node;
    }

    private Map<Direction2D, List<Edge>> makeRectangleForNode(Node node) {
        List<Dart> darts = this.myEmbeddedGraph.getDartWithSource(node);
        IMapSequence<Direction2D, List<Edge>> edgesInDirection = MapSequence.fromMap(new HashMap());
        for (Direction2D dir : Direction2D.values()) {
            MapSequence.fromMap(edgesInDirection).put(dir, ListSequence.fromList(new ArrayList()));
        }
        Dart cur = (Dart)ListSequence.fromList(darts).first();
        for (int step = 0; step < ListSequence.fromList(darts).count(); ++step) {
            Face face = this.myEmbeddedGraph.getFace(cur);
            Dart next = this.myEmbeddedGraph.getNextSourceDart(cur);
            int turn = ((Direction2D)((Object)MapSequence.fromMap(this.myDirections).get(cur))).getClockwiseTurn((Direction2D)((Object)MapSequence.fromMap(this.myDirections).get(next)));
            if (turn == 0) {
                turn = 4;
            }
            IListSequence<Edge> newEdges = ListSequence.fromList(new LinkedList());
            Node pathSource = cur.getTarget();
            Node pathTarget = next.getTarget();
            Node curNode = pathSource;
            for (int i = 0; i <= turn; ++i) {
                Node nextNode = i == turn ? pathTarget : this.myGraph.createNode();
                ListSequence.fromList(newEdges).addElement(this.myGraph.connect(curNode, nextNode));
                curNode = nextNode;
            }
            boolean isOuter = this.myEmbeddedGraph.isOuterFace(face);
            List<Face> newFaces = this.myEmbeddedGraph.splitFace(face, newEdges, pathSource, pathTarget);
            Face newFaceWithNode = null;
            Edge firstEdge = (Edge)ListSequence.fromList(newEdges).first();
            Dart firstDart = this.myEmbeddedGraph.getSourceDart(firstEdge, firstEdge.getSource());
            for (Face newFace : ListSequence.fromList(newFaces)) {
                if (!ListSequence.fromList(newFace.getDarts()).contains(firstDart)) continue;
                newFaceWithNode = newFace;
            }
            SetSequence.fromSet(this.myBoxFaces).addElement(newFaceWithNode);
            if (isOuter) {
                Face newOuterFace = ListSequence.fromList(newFaces).getElement(0);
                if (newOuterFace == newFaceWithNode) {
                    newOuterFace = ListSequence.fromList(newFaces).getElement(1);
                }
                this.myEmbeddedGraph.setOuterFace(newOuterFace);
            }
            Direction2D curDir = ((Direction2D)((Object)MapSequence.fromMap(this.myDirections).get(cur))).turnClockwise(1);
            curNode = pathSource;
            for (Edge edge : ListSequence.fromList(newEdges)) {
                for (Dart dart : ListSequence.fromList(this.myEmbeddedGraph.getDarts(edge))) {
                    if (dart.getSource() == curNode) {
                        MapSequence.fromMap(this.myDirections).put(dart, curDir);
                        ListSequence.fromList((List)MapSequence.fromMap(edgesInDirection).get((Object)curDir)).addElement(edge);
                        continue;
                    }
                    MapSequence.fromMap(this.myDirections).put(dart, curDir.opposite());
                }
                curNode = edge.getOpposite(curNode);
                curDir = curDir.turnClockwise(1);
            }
            cur = next;
        }
        return edgesInDirection;
    }

    private void printEmbeddedGraph() {
        for (Face face : ListSequence.fromList(this.myEmbeddedGraph.getFaces())) {
            System.out.println("face: ");
            if (this.myEmbeddedGraph.isOuterFace(face)) {
                System.out.println("this is outer face");
            }
            for (Dart dart : ListSequence.fromList(face.getDarts())) {
                Object size = " ";
                if (MapSequence.fromMap(this.myBoxEdgeLengths).containsKey(dart.getEdge())) {
                    size = (String)size + String.valueOf(MapSequence.fromMap(this.myBoxEdgeLengths).get(dart.getEdge()));
                }
                System.out.println("  " + String.valueOf(dart) + " dir = " + String.valueOf(MapSequence.fromMap(this.myDirections).get(dart)) + (String)size);
            }
        }
    }

    public Set<Face> getBoxFaces() {
        return this.myBoxFaces;
    }

    public Map<Edge, Integer> getBoxEdgeLengths() {
        return this.myBoxEdgeLengths;
    }
}

