/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.flowOrthogonalLayout;

import com.vertabelo.autolayout_tool.repackaged.javaslang.Tuple2;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.flowOrthogonalLayout.AbstractOrthogonalFlowLayouter;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.flowOrthogonalLayout.ConstraintsGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.flowOrthogonalLayout.NodeBoxesMaker;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.flowOrthogonalLayout.OrthogonalRepresentation;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.flowOrthogonalLayout.QuasiOrthogonalRepresentation;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.flowOrthogonalLayout.QuasiRepresentationModifier;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.EdgesHistoryManager;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.GraphLayout;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.GraphLayoutFactory;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.LayoutInfo;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Dimension;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Direction2D;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Point;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Rectangle;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Util1D;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.Dart;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.EmbeddedGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.Face;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IMapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISetSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.SetSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.backports.LinkedList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OrthogonalFlowLayouter
extends AbstractOrthogonalFlowLayouter {
    private static int LABEL_DIST = 10;

    @Override
    public GraphLayout getLayoutFromEmbeddedGraph(EmbeddedGraph embeddedGraph, LayoutInfo layoutInfo) {
        Rectangle rect;
        Edge constraintEdge;
        if (SHOW_INFO > 0) {
            System.out.println("initial graph: " + String.valueOf(embeddedGraph));
        }
        IMapSequence<Node, Dimension> nodeSizes = MapSequence.fromMap(new LinkedHashMap(16, 0.75f, false));
        for (Node node : SetSequence.fromSet(layoutInfo.getNodesWithSize())) {
            MapSequence.fromMap(nodeSizes).put(node, layoutInfo.getNodeSize(node));
        }
        IMapSequence<Edge, Dimension> edgeSizes = MapSequence.fromMap(new LinkedHashMap(16, 0.75f, false));
        for (Edge edge : SetSequence.fromSet(layoutInfo.getLabeledEdges())) {
            MapSequence.fromMap(edgeSizes).put(edge, layoutInfo.getLabelSize(edge));
        }
        Graph graph = embeddedGraph.getGraph();
        EdgesHistoryManager historyManager = new EdgesHistoryManager(graph);
        IListSequence initialEdges = ListSequence.fromList(new ArrayList());
        ListSequence.fromList(initialEdges).addSequence((ISequence)ListSequence.fromList(graph.getEdges()));
        IListSequence<Node> initialNodes = ListSequence.fromList(new ArrayList());
        ListSequence.fromList(initialNodes).addSequence((ISequence)SetSequence.fromSet(MapSequence.fromMap(nodeSizes).keySet()));
        IMapSequence<Dart, Integer> bends = MapSequence.fromMap(new HashMap());
        IMapSequence<Dart, Integer> angles = MapSequence.fromMap(new HashMap());
        for (Edge edge : ListSequence.fromList(graph.getEdges())) {
            if (ListSequence.fromList(embeddedGraph.getDarts(edge)).count() == 2) continue;
            throw new RuntimeException("botva!!!");
        }
        QuasiOrthogonalRepresentation orthogonalRepresentation = new QuasiOrthogonalRepresentation();
        if (this.getUseRepresentationOptimizations()) {
            orthogonalRepresentation.setRealEdges(this.myRealEdges);
            orthogonalRepresentation.setRealNodes(this.myRealNodes);
            orthogonalRepresentation.setStraightEdges(this.myStraightEdges);
        }
        Tuple2<Map<Dart, Integer>, Map<Dart, Integer>> pair = orthogonalRepresentation.getRepresentation(embeddedGraph);
        bends = pair._1();
        angles = pair._2();
        for (Edge edge : ListSequence.fromList(graph.getEdges())) {
            for (Dart dart : ListSequence.fromList(embeddedGraph.getDarts(edge))) {
                if ((Integer)MapSequence.fromMap(angles).get(dart) >= 0 && (Integer)MapSequence.fromMap(angles).get(dart) <= 3) continue;
                throw new RuntimeException("botva!!!");
            }
        }
        QuasiRepresentationModifier quasiModifier = new QuasiRepresentationModifier(embeddedGraph, bends, angles);
        quasiModifier.reduceToOrthogonalRepresentation();
        List<QuasiRepresentationModifier.Modification> modifications = quasiModifier.getModifications();
        ISetSequence modifiedEdges = SetSequence.fromSet(new HashSet());
        ISetSequence newEdges = SetSequence.fromSet(new HashSet());
        for (QuasiRepresentationModifier.Modification modification : ListSequence.fromList(modifications)) {
            SetSequence.fromSet(modifiedEdges).addSequence(ListSequence.fromList(modification.getModifiedEdges()));
            SetSequence.fromSet(newEdges).addSequence(ListSequence.fromList(modification.getNewEdges()));
        }
        IMapSequence labeledEdges = MapSequence.fromMap(new HashMap());
        for (Edge edge : SetSequence.fromSet(MapSequence.fromMap(edgeSizes).keySet())) {
            List<Edge> history = historyManager.getHistory(edge);
            if (SetSequence.fromSet(modifiedEdges).contains(edge)) {
                for (Edge edge2 : ListSequence.fromList(history)) {
                    if (!SetSequence.fromSet(newEdges).contains(edge2)) continue;
                    MapSequence.fromMap(labeledEdges).put(edge, edge2);
                }
                continue;
            }
            MapSequence.fromMap(labeledEdges).put(edge, edge);
        }
        if (SHOW_INFO > 0) {
            System.out.println("modifications: ");
            for (QuasiRepresentationModifier.Modification modification : ListSequence.fromList(modifications)) {
                System.out.println(modification);
            }
        }
        OrthogonalRepresentation.replaceBendsByNodes(embeddedGraph, bends, angles);
        for (Edge edge : SetSequence.fromSet(MapSequence.fromMap(edgeSizes).keySet())) {
            Edge labeledEdge = this.getLabeledEdge(historyManager.getHistory((Edge)MapSequence.fromMap(labeledEdges).get(edge)));
            MapSequence.fromMap(labeledEdges).put(edge, labeledEdge);
        }
        Map<Dart, Direction2D> map = OrthogonalRepresentation.getDirections(embeddedGraph, angles);
        if (SHOW_INFO > 0) {
            System.out.println("modified graph: " + String.valueOf(embeddedGraph));
        }
        Map<Node, Map<Direction2D, Integer>> nodeDirectionSizes = this.getNodeDirectionSizes(initialNodes, nodeSizes);
        Map<Edge, Integer> edgeShifts = this.getEdgesShifts(modifications, map, nodeSizes);
        NodeBoxesMaker boxesMaker = new NodeBoxesMaker(embeddedGraph, map);
        boxesMaker.makeBoxes(nodeSizes);
        for (Object edge : SetSequence.fromSet(MapSequence.fromMap(edgeSizes).keySet())) {
            Edge labeledEdge = (Edge)MapSequence.fromMap(labeledEdges).get(edge);
            List<Edge> history = historyManager.getHistory(labeledEdge);
            int pos = 0;
            if (ListSequence.fromList(initialNodes).contains(labeledEdge.getSource())) {
                pos = 1;
            }
            MapSequence.fromMap(labeledEdges).put(edge, ListSequence.fromList(history).getElement(pos));
        }
        IMapSequence iMapSequence = MapSequence.fromMap(new HashMap());
        for (Object edge : SetSequence.fromSet(MapSequence.fromMap(edgeSizes).keySet())) {
            Edge labeledEdge = (Edge)MapSequence.fromMap(labeledEdges).get(edge);
            if (((Direction2D)((Object)MapSequence.fromMap(map).get(ListSequence.fromList(embeddedGraph.getDarts(labeledEdge)).first()))).isHorizontal()) {
                MapSequence.fromMap(iMapSequence).put(edge, Direction2D.UP);
                continue;
            }
            MapSequence.fromMap(iMapSequence).put(edge, Direction2D.RIGHT);
        }
        IMapSequence<Edge, Node> labelCenters = MapSequence.fromMap(new HashMap());
        for (Edge edge : SetSequence.fromSet(MapSequence.fromMap(edgeSizes).keySet())) {
            MapSequence.fromMap(labelCenters).put(edge, this.splitEdge((Edge)MapSequence.fromMap(labeledEdges).get(edge), embeddedGraph, map));
        }
        Set<Face> boxFaces = boxesMaker.getBoxFaces();
        Map<Edge, Integer> edgeLengths = boxesMaker.getBoxEdgeLengths();
        for (Node node : ListSequence.fromList(initialNodes)) {
            for (Edge edge : ListSequence.fromList(node.getEdges())) {
                Dart dart = embeddedGraph.getSourceDart(edge, node);
                MapSequence.fromMap(edgeLengths).put(edge, (Integer)MapSequence.fromMap((Map)MapSequence.fromMap(nodeDirectionSizes).get(node)).get(MapSequence.fromMap(map).get(dart)));
            }
        }
        for (Edge edge : SetSequence.fromSet(MapSequence.fromMap(edgeSizes).keySet())) {
            Dimension size = (Dimension)MapSequence.fromMap(edgeSizes).get(edge);
            int length = ((Direction2D)((Object)MapSequence.fromMap(iMapSequence).get(edge))).isHorizontal() ? size.height : size.width;
            for (Edge nodeEdge : ListSequence.fromList(((Node)MapSequence.fromMap(labelCenters).get(edge)).getEdges())) {
                MapSequence.fromMap(edgeLengths).put(nodeEdge, length / 2 + this.getUnitLength());
            }
        }
        for (Edge edge : SetSequence.fromSet(MapSequence.fromMap(edgeShifts).keySet())) {
            Edge firstEdge = (Edge)ListSequence.fromList(historyManager.getHistory(edge)).first();
            if (MapSequence.fromMap(edgeLengths).containsKey(firstEdge)) {
                MapSequence.fromMap(edgeLengths).put(firstEdge, (Integer)MapSequence.fromMap(edgeLengths).get(firstEdge) + (Integer)MapSequence.fromMap(edgeShifts).get(edge));
                continue;
            }
            MapSequence.fromMap(edgeLengths).put(firstEdge, (Integer)MapSequence.fromMap(edgeShifts).get(edge) + 2 * this.getUnitLength());
        }
        ConstraintsGraph constraintsGraph = new ConstraintsGraph(embeddedGraph, map);
        constraintsGraph.constructGraph(boxFaces);
        constraintsGraph.setUnitLength(this.getUnitLength());
        Map<Node, Point> coordinates = constraintsGraph.getCoordinates(edgeLengths, null);
        IMapSequence labelRects = MapSequence.fromMap(new HashMap());
        for (Iterator edge : SetSequence.fromSet(MapSequence.fromMap(edgeSizes).keySet())) {
            MapSequence.fromMap(labelRects).put(edge, this.getLabelLayout(labelCenters, (Edge)((Object)edge), coordinates, embeddedGraph, edgeSizes, map));
        }
        IMapSequence<Edge, Integer> constraintEdgeLengths = MapSequence.fromMap(new HashMap());
        for (Edge edge : SetSequence.fromSet(MapSequence.fromMap(labelRects).keySet())) {
            Rectangle rect2;
            Node center = (Node)MapSequence.fromMap(labelCenters).get(edge);
            boolean isHorizontal = ((Direction2D)((Object)MapSequence.fromMap(iMapSequence).get(edge))).isVertical();
            Rectangle labelRect = (Rectangle)MapSequence.fromMap(labelRects).get(edge);
            int width = labelRect.width + this.getUnitLength();
            int height = labelRect.height + this.getUnitLength();
            if (isHorizontal) {
                Rectangle rect22 = new Rectangle(labelRect.x - this.getUnitLength() / 2, labelRect.y, width, height);
            } else {
                rect2 = new Rectangle(labelRect.x, labelRect.y - this.getUnitLength() / 2, width, height);
            }
            for (Node node : ListSequence.fromList(graph.getNodes())) {
                Point point;
                if (node == center || !rect2.contains(point = (Point)MapSequence.fromMap(coordinates).get(node))) continue;
                if (isHorizontal) {
                    constraintEdge = constraintsGraph.addConstraintEdge(center, node, Direction2D.UP);
                    MapSequence.fromMap(constraintEdgeLengths).put(constraintEdge, rect2.height);
                    continue;
                }
                constraintEdge = constraintsGraph.addConstraintEdge(center, node, Direction2D.RIGHT);
                MapSequence.fromMap(constraintEdgeLengths).put(constraintEdge, rect2.width);
            }
            if (!this.getAvoidLabelCrossings()) continue;
            for (Edge graphEdge : ListSequence.fromList(graph.getEdges())) {
                int dist;
                boolean isIntersecting;
                if (ListSequence.fromList(center.getEdges()).contains(graphEdge) || ((Direction2D)((Object)MapSequence.fromMap(map).get(ListSequence.fromList(embeddedGraph.getDarts(graphEdge)).first()))).isHorizontal() != isHorizontal) continue;
                Point sourcePoint = (Point)MapSequence.fromMap(coordinates).get(graphEdge.getSource());
                Point targetPoint = (Point)MapSequence.fromMap(coordinates).get(graphEdge.getTarget());
                if (isHorizontal) {
                    isIntersecting = Util1D.insideClosedSegment(sourcePoint.x, targetPoint.x, rect2.x) && Util1D.insideClosedSegment(sourcePoint.x, targetPoint.x, rect2.x + rect2.width);
                    dist = rect2.y + rect2.height - sourcePoint.y;
                    if (!isIntersecting || dist >= rect2.height) continue;
                    Edge constraintEdge2 = constraintsGraph.addConstraintEdge(center, graphEdge.getSource(), Direction2D.UP);
                    MapSequence.fromMap(constraintEdgeLengths).put(constraintEdge2, rect2.height);
                    continue;
                }
                isIntersecting = Util1D.insideClosedSegment(sourcePoint.y, targetPoint.y, rect2.y) && Util1D.insideClosedSegment(sourcePoint.y, targetPoint.y, rect2.y + rect2.height);
                dist = rect2.x + rect2.width - sourcePoint.x;
                if (!isIntersecting || dist >= rect2.width) continue;
                Edge constraintEdge2 = constraintsGraph.addConstraintEdge(center, graphEdge.getSource(), Direction2D.RIGHT);
                MapSequence.fromMap(constraintEdgeLengths).put(constraintEdge2, rect2.width);
            }
        }
        coordinates = constraintsGraph.getCoordinates(edgeLengths, constraintEdgeLengths);
        for (Edge edge : SetSequence.fromSet(MapSequence.fromMap(edgeSizes).keySet())) {
            MapSequence.fromMap(labelRects).put(edge, this.getLabelLayout(labelCenters, edge, coordinates, embeddedGraph, edgeSizes, map));
        }
        IListSequence edgeList = ListSequence.fromList(new ArrayList());
        ListSequence.fromList(edgeList).addSequence((ISequence)SetSequence.fromSet(MapSequence.fromMap(labelRects).keySet()));
        for (int i = 0; i < ListSequence.fromList(edgeList).count(); ++i) {
            Edge edgeI = (Edge)ListSequence.fromList(edgeList).getElement(i);
            Direction2D dirI = (Direction2D)((Object)MapSequence.fromMap(iMapSequence).get(edgeI));
            Rectangle rectI = (Rectangle)MapSequence.fromMap(labelRects).get(edgeI);
            for (int j = i + 1; j < ListSequence.fromList(edgeList).count(); ++j) {
                Edge edgeJ = (Edge)ListSequence.fromList(edgeList).getElement(j);
                Direction2D dirJ = (Direction2D)((Object)MapSequence.fromMap(iMapSequence).get(edgeJ));
                Rectangle rectJ = (Rectangle)MapSequence.fromMap(labelRects).get(edgeJ);
                if (!rectI.intersects(rectJ)) continue;
                int shiftByDirI = rectJ.size(dirI) + rectI.size(dirI);
                int shiftByDirJ = rectJ.size(dirJ) + rectI.size(dirJ);
                if (shiftByDirJ < shiftByDirI) {
                    constraintEdge = constraintsGraph.addConstraintEdge((Node)MapSequence.fromMap(labelCenters).get(edgeJ), (Node)MapSequence.fromMap(labelCenters).get(edgeI), dirJ);
                    MapSequence.fromMap(constraintEdgeLengths).put(constraintEdge, shiftByDirJ - rectI.size(dirJ) / 2 + LABEL_DIST);
                    continue;
                }
                constraintEdge = constraintsGraph.addConstraintEdge((Node)MapSequence.fromMap(labelCenters).get(edgeI), (Node)MapSequence.fromMap(labelCenters).get(edgeJ), dirI);
                MapSequence.fromMap(constraintEdgeLengths).put(constraintEdge, shiftByDirI - rectJ.size(dirI) / 2 + LABEL_DIST);
            }
        }
        for (Edge edge : ListSequence.fromList(graph.getEdges())) {
            Point sourcePoint = (Point)MapSequence.fromMap(coordinates).get(edge.getSource());
            Point targetPoint = (Point)MapSequence.fromMap(coordinates).get(edge.getTarget());
            MapSequence.fromMap(edgeLengths).put(edge, Math.abs(sourcePoint.x - targetPoint.x) + Math.abs(sourcePoint.y - targetPoint.y));
        }
        coordinates = constraintsGraph.getCoordinates(edgeLengths, constraintEdgeLengths);
        GraphLayout graphLayout = GraphLayoutFactory.createGraphLayout(graph);
        for (Node node : ListSequence.fromList(initialNodes)) {
            rect = this.getNodeLayout(coordinates, node, nodeDirectionSizes, nodeSizes);
            graphLayout.setLayoutFor(node, rect);
        }
        for (Edge edge : ListSequence.fromList(initialEdges)) {
            List<Point> edgeLayout = this.getEdgeLayout(edge, embeddedGraph, historyManager, coordinates, initialNodes, map, nodeDirectionSizes);
            graphLayout.setLayoutFor(edge, edgeLayout);
        }
        for (Edge edge : SetSequence.fromSet(MapSequence.fromMap(edgeSizes).keySet())) {
            rect = this.getLabelLayout(labelCenters, edge, coordinates, embeddedGraph, edgeSizes, map);
            graphLayout.setLabelLayout(edge, rect);
        }
        for (QuasiRepresentationModifier.Modification modification : ListSequence.fromList(modifications)) {
            this.splitEdges(graphLayout, modification, edgeShifts);
        }
        return graphLayout;
    }

    private Rectangle getLabelLayout(Map<Edge, Node> labelCenters, Edge edge, Map<Node, Point> coordinates, EmbeddedGraph embeddedGraph, Map<Edge, Dimension> edgeSizes, Map<Dart, Direction2D> directions) {
        Node node = (Node)MapSequence.fromMap(labelCenters).get(edge);
        Point center = (Point)MapSequence.fromMap(coordinates).get(node);
        Dart dart = (Dart)ListSequence.fromList(embeddedGraph.getDarts((Edge)ListSequence.fromList(node.getEdges()).first())).first();
        Dimension size = (Dimension)MapSequence.fromMap(edgeSizes).get(edge);
        Rectangle rect = ((Direction2D)((Object)MapSequence.fromMap(directions).get(dart))).isHorizontal() ? new Rectangle(center.x - size.width / 2, center.y, size.width, size.height) : new Rectangle(center.x, center.y - size.height / 2, size.width, size.height);
        return rect;
    }

    private List<Point> getEdgeLayout(Edge edge, EmbeddedGraph embeddedGraph, EdgesHistoryManager manager, Map<Node, Point> coordinates, List<Node> initialNodes, Map<Dart, Direction2D> directions, Map<Node, Map<Direction2D, Integer>> nodeDirectionSizes) {
        Direction2D dir;
        Node source = edge.getSource();
        Node target = edge.getTarget();
        List<Edge> history = manager.getHistory(edge);
        IListSequence<Point> edgeLayout = ListSequence.fromList(new LinkedList());
        Node cur = source;
        ListSequence.fromList(edgeLayout).addElement(new Point((Point)MapSequence.fromMap(coordinates).get(cur)));
        for (Edge historyEdge : ListSequence.fromList(history)) {
            Node next = historyEdge.getOpposite(cur);
            ListSequence.fromList(edgeLayout).addElement(new Point((Point)MapSequence.fromMap(coordinates).get(next)));
            cur = next;
        }
        if (ListSequence.fromList(initialNodes).contains(source)) {
            dir = (Direction2D)((Object)MapSequence.fromMap(directions).get(embeddedGraph.getSourceDart((Edge)ListSequence.fromList(history).first(), source)));
            int size = (Integer)MapSequence.fromMap((Map)MapSequence.fromMap(nodeDirectionSizes).get(source)).get((Object)dir);
            Point first = ListSequence.fromList(edgeLayout).removeElementAt(0);
            first.translate(size * dir.dx(), size * dir.dy());
            ListSequence.fromList(edgeLayout).removeElementAt(0);
            ListSequence.fromList(edgeLayout).insertElement(0, first);
        }
        if (ListSequence.fromList(initialNodes).contains(edge.getTarget())) {
            dir = (Direction2D)((Object)MapSequence.fromMap(directions).get(embeddedGraph.getSourceDart((Edge)ListSequence.fromList(history).last(), target)));
            int size = (Integer)MapSequence.fromMap((Map)MapSequence.fromMap(nodeDirectionSizes).get(target)).get((Object)dir);
            Point last = ListSequence.fromList(edgeLayout).removeLastElement();
            last.translate(size * dir.dx(), size * dir.dy());
            ListSequence.fromList(edgeLayout).removeLastElement();
            ListSequence.fromList(edgeLayout).addElement(last);
        }
        return edgeLayout;
    }

    private Rectangle getNodeLayout(Map<Node, Point> coordinates, Node node, Map<Node, Map<Direction2D, Integer>> nodeDirectionSizes, Map<Node, Dimension> nodeSizes) {
        Point center = (Point)MapSequence.fromMap(coordinates).get(node);
        Map sizes = (Map)MapSequence.fromMap(nodeDirectionSizes).get(node);
        Dimension nodeSize = (Dimension)MapSequence.fromMap(nodeSizes).get(node);
        return new Rectangle(center.x - (Integer)MapSequence.fromMap(sizes).get((Object)Direction2D.LEFT), center.y - (Integer)MapSequence.fromMap(sizes).get((Object)Direction2D.DOWN), nodeSize.width, nodeSize.height);
    }

    @Override
    public Edge getLabeledEdge(List<Edge> edges) {
        return (Edge)ListSequence.fromList(edges).first();
    }

    private Node splitEdge(Edge oldEdge, EmbeddedGraph embeddedGraph, Map<Dart, Direction2D> directions) {
        Node source = oldEdge.getSource();
        Node target = oldEdge.getTarget();
        Dart sourceDart = embeddedGraph.getSourceDart(oldEdge, source);
        Dart targetDart = embeddedGraph.getSourceDart(oldEdge, target);
        IListSequence<Edge> edges = ListSequence.fromList(new ArrayList());
        Node node = embeddedGraph.splitEdge(oldEdge, edges);
        for (Edge edge : ListSequence.fromList(edges)) {
            for (Dart dart : ListSequence.fromList(embeddedGraph.getDarts(edge))) {
                if (dart.getSource() == source || dart.getTarget() == target) {
                    MapSequence.fromMap(directions).put(dart, (Direction2D)((Object)MapSequence.fromMap(directions).get(sourceDart)));
                    continue;
                }
                MapSequence.fromMap(directions).put(dart, (Direction2D)((Object)MapSequence.fromMap(directions).get(targetDart)));
            }
        }
        MapSequence.fromMap(directions).removeKey(sourceDart);
        MapSequence.fromMap(directions).removeKey(targetDart);
        return node;
    }
}

