/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.flowOrthogonalLayout;

import com.vertabelo.autolayout_tool.repackaged.mps.baseLanguage.closures.runtime.Wrappers;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms.Dfs;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms.MinCostCirculation;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.INode;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Direction2D;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.Dart;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.EmbeddedGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.Face;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IMapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISelector;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.SetSequence;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OrthogonalRepresentation {
    private static int SHOW_INFO = 0;

    public static void getRepresentation(EmbeddedGraph embeddedGraph, Set<Edge> edgesToBeStraight, Map<Dart, Integer> bends, Map<Dart, Integer> angles) {
        Graph graph = embeddedGraph.getGraph();
        Graph network = new Graph();
        Node center = network.createNode();
        IMapSequence<Edge, Integer> low = MapSequence.fromMap(new HashMap());
        IMapSequence<Edge, Integer> capacity = MapSequence.fromMap(new HashMap());
        IMapSequence<Edge, Integer> cost = MapSequence.fromMap(new HashMap());
        IMapSequence nodeMap = MapSequence.fromMap(new HashMap());
        for (Object node : ListSequence.fromList(graph.getNodes())) {
            Node networkNode = network.createNode();
            MapSequence.fromMap(nodeMap).put(node, networkNode);
            Edge edge = network.connect(center, networkNode);
            MapSequence.fromMap(low).put(edge, 4);
            MapSequence.fromMap(capacity).put(edge, (Integer)MapSequence.fromMap(low).get(edge));
            MapSequence.fromMap(cost).put(edge, 0);
        }
        IMapSequence faceMap = MapSequence.fromMap(new HashMap());
        for (Face face : ListSequence.fromList(embeddedGraph.getFaces())) {
            Iterator node = network.createNode();
            MapSequence.fromMap(faceMap).put(face, (Node)((Object)node));
            Edge edge = network.connect((INode)((Object)node), center);
            if (embeddedGraph.isOuterFace(face)) {
                MapSequence.fromMap(low).put(edge, 2 * ListSequence.fromList(face.getDarts()).count() + 4);
            } else {
                MapSequence.fromMap(low).put(edge, 2 * ListSequence.fromList(face.getDarts()).count() - 4);
            }
            MapSequence.fromMap(capacity).put(edge, (Integer)MapSequence.fromMap(low).get(edge));
            MapSequence.fromMap(cost).put(edge, 0);
        }
        IMapSequence dartBendMap = MapSequence.fromMap(new HashMap());
        IMapSequence dartAngleMap = MapSequence.fromMap(new HashMap());
        for (Face face : ListSequence.fromList(embeddedGraph.getFaces())) {
            Node faceNode = (Node)MapSequence.fromMap(faceMap).get(face);
            for (Dart dart : ListSequence.fromList(face.getDarts())) {
                Edge edge = network.connect((INode)MapSequence.fromMap(nodeMap).get(dart.getSource()), faceNode);
                MapSequence.fromMap(dartAngleMap).put(dart, edge);
                MapSequence.fromMap(low).put(edge, 1);
                MapSequence.fromMap(capacity).put(edge, 4);
                MapSequence.fromMap(cost).put(edge, 0);
                List<Face> faces = embeddedGraph.getAdjacentFaces(dart.getEdge());
                Node oppositeFaceNode = ListSequence.fromList(faces).getElement(0) == face ? (Node)MapSequence.fromMap(faceMap).get(ListSequence.fromList(faces).getElement(1)) : (Node)MapSequence.fromMap(faceMap).get(ListSequence.fromList(faces).getElement(0));
                edge = network.connect(faceNode, oppositeFaceNode);
                MapSequence.fromMap(dartBendMap).put(dart, edge);
                MapSequence.fromMap(low).put(edge, 0);
                if (SetSequence.fromSet(edgesToBeStraight).contains(dart.getEdge())) {
                    MapSequence.fromMap(capacity).put(edge, 0);
                } else {
                    MapSequence.fromMap(capacity).put(edge, 0x3FFFFFFF);
                }
                MapSequence.fromMap(cost).put(edge, 1);
            }
        }
        if (SHOW_INFO > 0) {
            System.out.println("Constructed network:");
            for (Node node : ListSequence.fromList(graph.getNodes())) {
                System.out.println("for node " + String.valueOf(node) + ": " + String.valueOf(MapSequence.fromMap(nodeMap).get(node)));
            }
            for (Face face : ListSequence.fromList(embeddedGraph.getFaces())) {
                System.out.println("for face " + String.valueOf(face) + ": " + String.valueOf(MapSequence.fromMap(faceMap).get(face)));
            }
            for (Edge edge : ListSequence.fromList(network.getEdges())) {
                System.out.println("edge " + String.valueOf(edge) + ": low = " + String.valueOf(MapSequence.fromMap(low).get(edge)) + ", cap = " + String.valueOf(MapSequence.fromMap(capacity).get(edge)) + ", cost = " + String.valueOf(MapSequence.fromMap(cost).get(edge)));
            }
        }
        Map<Edge, Integer> circulation = MinCostCirculation.getCirculation(network, low, capacity, cost);
        for (Dart dart : SetSequence.fromSet(MapSequence.fromMap(dartBendMap).keySet())) {
            MapSequence.fromMap(bends).put(dart, (Integer)MapSequence.fromMap(circulation).get(MapSequence.fromMap(dartBendMap).get(dart)));
            MapSequence.fromMap(angles).put(dart, (Integer)MapSequence.fromMap(circulation).get(MapSequence.fromMap(dartAngleMap).get(dart)));
        }
        if (SHOW_INFO > 0) {
            System.out.println("bends: " + String.valueOf(bends));
            System.out.println("angles: " + String.valueOf(angles));
        }
    }

    public static void getRepresentation(EmbeddedGraph embeddedGraph, Map<Dart, Integer> bends, Map<Dart, Integer> angles) {
        OrthogonalRepresentation.getRepresentation(embeddedGraph, SetSequence.fromSet(new HashSet()), bends, angles);
    }

    public static void replaceBendsByNodes(EmbeddedGraph embeddedGraph, Map<Dart, Integer> bends, Map<Dart, Integer> angles) {
        for (Edge edge : ListSequence.fromList(embeddedGraph.getGraph().getEdges())) {
            List<Dart> darts = embeddedGraph.getDarts(edge);
            Wrappers._T<Object> dartToSplit = new Wrappers._T<Object>(null);
            Dart opposite = null;
            if ((Integer)MapSequence.fromMap(bends).get(ListSequence.fromList(darts).getElement(0)) > 0) {
                dartToSplit.value = ListSequence.fromList(darts).getElement(0);
                opposite = ListSequence.fromList(darts).getElement(1);
            }
            if ((Integer)MapSequence.fromMap(bends).get(ListSequence.fromList(darts).getElement(1)) > 0) {
                dartToSplit.value = ListSequence.fromList(darts).getElement(1);
                opposite = ListSequence.fromList(darts).getElement(0);
            }
            if (dartToSplit.value == null) continue;
            while ((Integer)MapSequence.fromMap(bends).get(dartToSplit.value) > 0) {
                IListSequence<Edge> newEdges = ListSequence.fromList(new ArrayList());
                Node addedNode = embeddedGraph.splitEdge(((Dart)dartToSplit.value).getEdge(), newEdges);
                Edge first = ListSequence.fromList(newEdges).findFirst(it -> it.getOpposite(addedNode) == ((Dart)dartToSplit.value).getSource());
                Edge second = ListSequence.fromList(newEdges).findFirst(it -> it.getOpposite(addedNode) == ((Dart)dartToSplit.value).getTarget());
                for (Dart firstDart : ListSequence.fromList(embeddedGraph.getDarts(first))) {
                    MapSequence.fromMap(bends).put(firstDart, 0);
                    if (firstDart.getSource() == addedNode) {
                        MapSequence.fromMap(angles).put(firstDart, 3);
                        continue;
                    }
                    MapSequence.fromMap(angles).put(firstDart, (Integer)MapSequence.fromMap(angles).get(dartToSplit.value));
                }
                Dart nextToSplit = null;
                Dart nextOpposite = null;
                for (Dart secondDart : ListSequence.fromList(embeddedGraph.getDarts(second))) {
                    if (secondDart.getSource() == addedNode) {
                        nextToSplit = secondDart;
                        MapSequence.fromMap(bends).put(secondDart, (Integer)MapSequence.fromMap(bends).get(dartToSplit.value) - 1);
                        MapSequence.fromMap(angles).put(secondDart, 1);
                        continue;
                    }
                    nextOpposite = secondDart;
                    MapSequence.fromMap(bends).put(secondDart, 0);
                    MapSequence.fromMap(angles).put(secondDart, (Integer)MapSequence.fromMap(angles).get(opposite));
                }
                MapSequence.fromMap(bends).removeKey((Dart)dartToSplit.value);
                MapSequence.fromMap(angles).removeKey((Dart)dartToSplit.value);
                MapSequence.fromMap(bends).removeKey(opposite);
                MapSequence.fromMap(angles).removeKey(opposite);
                dartToSplit.value = nextToSplit;
                opposite = nextOpposite;
            }
        }
    }

    public static Map<Dart, Direction2D> getDirections(EmbeddedGraph embeddedGraph, Map<Dart, Integer> angles) {
        GetDirectionsDfs dfs = new GetDirectionsDfs(embeddedGraph, angles);
        dfs.doDfs(embeddedGraph.getGraph(), Edge.Direction.BOTH);
        return dfs.getDirections();
    }

    private static class GetDirectionsDfs
    extends Dfs {
        private Map<Dart, Direction2D> myDirections;
        private EmbeddedGraph myEmbeddedGraph;
        private Map<Dart, Integer> myAngles;

        public GetDirectionsDfs(EmbeddedGraph embeddedGraph, Map<Dart, Integer> angles) {
            this.myEmbeddedGraph = embeddedGraph;
            this.myAngles = angles;
            this.myDirections = MapSequence.fromMap(new HashMap());
        }

        @Override
        protected void preprocessRoot(Node root) {
            Edge edge = (Edge)ListSequence.fromList(root.getEdges()).first();
            Dart dart = ListSequence.fromList(this.myEmbeddedGraph.getDarts(edge)).findFirst(it -> it.getSource() == root);
            MapSequence.fromMap(this.myDirections).put(dart, Direction2D.RIGHT);
            MapSequence.fromMap(this.myDirections).put(this.myEmbeddedGraph.getOpposite(dart), ((Direction2D)((Object)MapSequence.fromMap(this.myDirections).get(dart))).opposite());
        }

        @Override
        protected void preprocess(final Node node, Edge from) {
            Dart next;
            IListSequence<Dart> darts = ListSequence.fromList(node.getEdges()).select(new ISelector<Edge, Dart>(){

                @Override
                public Dart select(Edge edge) {
                    return ListSequence.fromList(myEmbeddedGraph.getDarts(edge)).findFirst(dart -> dart.getSource() == node);
                }
            }).toListSequence();
            Dart first = ListSequence.fromList(darts).findFirst(dart -> MapSequence.fromMap(this.myDirections).containsKey(dart));
            IListSequence orderedDarts = ListSequence.fromList(new ArrayList());
            ListSequence.fromList(orderedDarts).addElement(first);
            Dart cur = first;
            do {
                next = this.myEmbeddedGraph.getNextSourceDart(cur);
                MapSequence.fromMap(this.myDirections).put(next, ((Direction2D)((Object)MapSequence.fromMap(this.myDirections).get(cur))).turnClockwise((Integer)MapSequence.fromMap(this.myAngles).get(cur)));
                MapSequence.fromMap(this.myDirections).put(this.myEmbeddedGraph.getOpposite(next), ((Direction2D)((Object)MapSequence.fromMap(this.myDirections).get(next))).opposite());
            } while ((cur = next) != first);
        }

        public Map<Dart, Direction2D> getDirections() {
            return this.myDirections;
        }
    }
}

