/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.flowOrthogonalLayout;

import com.vertabelo.autolayout_tool.repackaged.javaslang.Tuple;
import com.vertabelo.autolayout_tool.repackaged.javaslang.Tuple2;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms.MinCostMaxFlowWithPotentials;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.INode;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.Dart;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.EmbeddedGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.Face;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IMapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.Sequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.SetSequence;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class QuasiOrthogonalRepresentation {
    private static int INF = 1000000;
    private static int SHOW_INFO = 0;
    private Set<Edge> myStraightEdges = null;
    private Set<Edge> myRealEdges = null;
    private Set<Node> myRealNodes = null;

    public void setStraightEdges(Set<Edge> straightEdges) {
        this.myStraightEdges = straightEdges;
    }

    public void setRealEdges(Set<Edge> realEdges) {
        this.myRealEdges = realEdges;
    }

    public void setRealNodes(Set<Node> realNodes) {
        this.myRealNodes = realNodes;
    }

    public Tuple2<Map<Dart, Integer>, Map<Dart, Integer>> getRepresentation(EmbeddedGraph embeddedGraph) {
        Graph graph = embeddedGraph.getGraph();
        int c = 100 * graph.getNumNodes();
        Graph network = new Graph();
        Node networkSource = network.createNode();
        Node networkTarget = network.createNode();
        IMapSequence<Edge, Integer> capacity = MapSequence.fromMap(new HashMap());
        IMapSequence<Edge, Integer> cost = MapSequence.fromMap(new HashMap());
        IMapSequence nodeMap = MapSequence.fromMap(new HashMap());
        for (Object node : ListSequence.fromList(graph.getNodes())) {
            Node networkNode = network.createNode();
            MapSequence.fromMap(nodeMap).put(node, networkNode);
            int deg = ListSequence.fromList(((Node)node).getEdges()).count();
            Edge edge = null;
            if (deg < 4) {
                edge = network.connect(networkSource, networkNode);
            }
            if (deg > 4) {
                edge = network.connect(networkNode, networkTarget);
            }
            if (edge == null) continue;
            MapSequence.fromMap(cost).put(edge, 0);
            MapSequence.fromMap(capacity).put(edge, Math.abs(deg - 4));
        }
        IMapSequence faceMap = MapSequence.fromMap(new HashMap());
        for (Face face : ListSequence.fromList(embeddedGraph.getFaces())) {
            Edge edge;
            Node networkNode = network.createNode();
            MapSequence.fromMap(faceMap).put(face, networkNode);
            int deg = ListSequence.fromList(face.getDarts()).count();
            if (embeddedGraph.isOuterFace(face)) {
                edge = network.connect(networkNode, networkTarget);
                MapSequence.fromMap(cost).put(edge, 0);
                MapSequence.fromMap(capacity).put(edge, deg + 4);
                continue;
            }
            edge = null;
            if (deg < 4) {
                edge = network.connect(networkSource, networkNode);
            }
            if (deg > 4) {
                edge = network.connect(networkNode, networkTarget);
            }
            if (edge == null) continue;
            MapSequence.fromMap(cost).put(edge, 0);
            MapSequence.fromMap(capacity).put(edge, Math.abs(deg - 4));
        }
        IMapSequence dartBendMap = MapSequence.fromMap(new HashMap());
        IMapSequence dartAngleMap = MapSequence.fromMap(new HashMap());
        for (Face face : ListSequence.fromList(embeddedGraph.getFaces())) {
            Node faceNode = (Node)MapSequence.fromMap(faceMap).get(face);
            for (Dart dart : ListSequence.fromList(face.getDarts())) {
                Edge graphEdge = dart.getEdge();
                Edge edge = network.connect((INode)MapSequence.fromMap(nodeMap).get(dart.getSource()), faceNode);
                MapSequence.fromMap(dartAngleMap).put(dart, edge);
                MapSequence.fromMap(capacity).put(edge, INF);
                MapSequence.fromMap(cost).put(edge, 0);
                Dart oppositeDart = embeddedGraph.getOpposite(dart);
                Node node = (Node)MapSequence.fromMap(faceMap).get(embeddedGraph.getFace(oppositeDart));
                edge = network.connect(faceNode, node);
                MapSequence.fromMap(dartBendMap).put(dart, edge);
                MapSequence.fromMap(capacity).put(edge, this.getCapacity(graphEdge));
                MapSequence.fromMap(cost).put(edge, this.getCost(graphEdge));
            }
        }
        IMapSequence faceToNodeEdges = MapSequence.fromMap(new HashMap());
        IMapSequence tempEdgesToDart = MapSequence.fromMap(new HashMap());
        for (Node node : ListSequence.fromList(graph.getNodes())) {
            Edge edge;
            if (!this.isParallelEdgeNode(node)) continue;
            List<Dart> darts = embeddedGraph.getDartWithSource(node);
            Iterator faceNodes = MapSequence.fromMap(new HashMap());
            IMapSequence faceEdges = MapSequence.fromMap(new HashMap());
            for (Dart dart : ListSequence.fromList(darts)) {
                Node faceNode = network.createNode();
                Face face = embeddedGraph.getFace(dart);
                MapSequence.fromMap(faceNodes).put(face, faceNode);
                edge = network.connect(faceNode, (INode)MapSequence.fromMap(nodeMap).get(node));
                MapSequence.fromMap(cost).put(edge, 0);
                MapSequence.fromMap(capacity).put(edge, 1);
                MapSequence.fromMap(faceEdges).put(face, edge);
            }
            for (Dart dart : ListSequence.fromList(darts)) {
                Face face = embeddedGraph.getFace(dart);
                Face leftFace = embeddedGraph.getFace(embeddedGraph.getOpposite(dart));
                edge = network.connect((INode)MapSequence.fromMap(faceMap).get(leftFace), (INode)MapSequence.fromMap(faceNodes).get(face));
                MapSequence.fromMap(cost).put(edge, 1);
                MapSequence.fromMap(capacity).put(edge, 1);
                MapSequence.fromMap(tempEdgesToDart).put(edge, dart);
            }
            MapSequence.fromMap(faceToNodeEdges).put(node, faceEdges);
        }
        Map<Edge, Integer> flow = MinCostMaxFlowWithPotentials.getFlow(network, networkSource, networkTarget, capacity, cost);
        IMapSequence bends = MapSequence.fromMap(new HashMap());
        IMapSequence angles = MapSequence.fromMap(new HashMap());
        for (Face face : ListSequence.fromList(embeddedGraph.getFaces())) {
            for (Dart dart : ListSequence.fromList(face.getDarts())) {
                Node source = dart.getSource();
                int angle = (Integer)MapSequence.fromMap(flow).get(MapSequence.fromMap(dartAngleMap).get(dart)) + 1;
                if (MapSequence.fromMap((Map)MapSequence.fromMap(faceToNodeEdges).get(source)).get(face) != null && (Integer)MapSequence.fromMap(flow).get(MapSequence.fromMap((Map)MapSequence.fromMap(faceToNodeEdges).get(source)).get(face)) > 0) {
                    --angle;
                }
                MapSequence.fromMap(angles).put(dart, angle);
            }
        }
        for (Dart dart : SetSequence.fromSet(MapSequence.fromMap(dartBendMap).keySet())) {
            MapSequence.fromMap(bends).put(dart, (Integer)MapSequence.fromMap(flow).get(MapSequence.fromMap(dartBendMap).get(dart)));
        }
        for (Face face : ListSequence.fromList(embeddedGraph.getFaces())) {
            List<Dart> darts = face.getDarts();
            for (Dart dart : ListSequence.fromList(darts)) {
                Node node = dart.getSource();
                Edge edgeToNode = (Edge)MapSequence.fromMap((Map)MapSequence.fromMap(faceToNodeEdges).get(node)).get(face);
                if (edgeToNode == null || (Integer)MapSequence.fromMap(flow).get(edgeToNode) <= 0) continue;
                Dart dartWithBend = embeddedGraph.getOpposite(dart);
                MapSequence.fromMap(bends).put(dartWithBend, (Integer)MapSequence.fromMap(bends).get(dartWithBend) + 1);
            }
        }
        if (SHOW_INFO > 0) {
            for (Object node : ListSequence.fromList(graph.getNodes())) {
                System.out.println("node " + String.valueOf(node));
                for (Dart dart : ListSequence.fromList(embeddedGraph.getDartWithSource((Node)node))) {
                    System.out.println(String.valueOf(dart) + " angle = " + String.valueOf(MapSequence.fromMap(angles).get(dart)) + ", bends = " + String.valueOf(MapSequence.fromMap(bends).get(dart)) + ", opposite bends = " + String.valueOf(MapSequence.fromMap(bends).get(embeddedGraph.getOpposite(dart))));
                }
            }
            int totalCost = 0;
            for (Edge edge : ListSequence.fromList(network.getEdges())) {
                totalCost += (Integer)MapSequence.fromMap(flow).get(edge) * (Integer)MapSequence.fromMap(cost).get(edge);
            }
            System.out.println("!!! total cost = " + totalCost);
            int totalBendsNumber = 0;
            for (Integer n : Sequence.fromIterable(MapSequence.fromMap(bends).values())) {
                totalBendsNumber += n.intValue();
            }
            System.out.println("!!! total bends number = " + totalBendsNumber);
            if (totalBendsNumber != totalCost) {
                throw new RuntimeException("total cost is not equal to bends number");
            }
        }
        return Tuple.of(bends, angles);
    }

    private boolean isParallelEdgeNode(Node node) {
        return SetSequence.fromSet(this.myRealNodes).contains(node) || ListSequence.fromList(node.getEdges()).count() > 4;
    }

    private int getCapacity(Edge edge) {
        if (SetSequence.fromSet(this.myStraightEdges).contains(edge)) {
            System.out.println("edge " + String.valueOf(edge) + " is straight");
            return 0;
        }
        return INF;
    }

    private int getCost(Edge edge) {
        int cost = SetSequence.fromSet(this.myRealEdges).contains(edge) ? 50 : 1;
        return cost;
    }

    public static void getRepresentation(EmbeddedGraph embeddedGraph, Map<Dart, Integer> bends, Map<Dart, Integer> angles) {
        QuasiOrthogonalRepresentation.getRepresentation(embeddedGraph, bends, angles, SetSequence.fromSet(new HashSet()));
    }

    public static void getRepresentation(EmbeddedGraph embeddedGraph, Map<Dart, Integer> bends, Map<Dart, Integer> angles, Set<Edge> straightEdges) {
        Graph graph = embeddedGraph.getGraph();
        int c = 100 * graph.getNumNodes();
        Graph network = new Graph();
        Node networkSource = network.createNode();
        Node networkTarget = network.createNode();
        IMapSequence<Edge, Integer> capacity = MapSequence.fromMap(new HashMap());
        IMapSequence<Edge, Integer> cost = MapSequence.fromMap(new HashMap());
        IMapSequence nodeMap = MapSequence.fromMap(new HashMap());
        for (Object node : ListSequence.fromList(graph.getNodes())) {
            Node networkNode = network.createNode();
            MapSequence.fromMap(nodeMap).put(node, networkNode);
            int deg = ListSequence.fromList(((Node)node).getEdges()).count();
            Edge edge = null;
            if (deg < 4) {
                edge = network.connect(networkSource, networkNode);
            }
            if (deg > 4) {
                edge = network.connect(networkNode, networkTarget);
            }
            if (edge == null) continue;
            MapSequence.fromMap(cost).put(edge, 0);
            MapSequence.fromMap(capacity).put(edge, Math.abs(deg - 4));
        }
        IMapSequence faceMap = MapSequence.fromMap(new HashMap());
        for (Face face : ListSequence.fromList(embeddedGraph.getFaces())) {
            Edge edge;
            Node networkNode = network.createNode();
            MapSequence.fromMap(faceMap).put(face, networkNode);
            int deg = ListSequence.fromList(face.getDarts()).count();
            if (embeddedGraph.isOuterFace(face)) {
                edge = network.connect(networkNode, networkTarget);
                MapSequence.fromMap(cost).put(edge, 0);
                MapSequence.fromMap(capacity).put(edge, deg + 4);
                continue;
            }
            edge = null;
            if (deg < 4) {
                edge = network.connect(networkSource, networkNode);
            }
            if (deg > 4) {
                edge = network.connect(networkNode, networkTarget);
            }
            if (edge == null) continue;
            MapSequence.fromMap(cost).put(edge, 0);
            MapSequence.fromMap(capacity).put(edge, Math.abs(deg - 4));
        }
        IMapSequence dartBendMap = MapSequence.fromMap(new HashMap());
        IMapSequence dartAngleMap = MapSequence.fromMap(new HashMap());
        for (Face face : ListSequence.fromList(embeddedGraph.getFaces())) {
            Node faceNode = (Node)MapSequence.fromMap(faceMap).get(face);
            for (Dart dart : ListSequence.fromList(face.getDarts())) {
                Edge edge = network.connect((INode)MapSequence.fromMap(nodeMap).get(dart.getSource()), faceNode);
                MapSequence.fromMap(dartAngleMap).put(dart, edge);
                MapSequence.fromMap(capacity).put(edge, INF);
                MapSequence.fromMap(cost).put(edge, 0);
                Dart dart2 = embeddedGraph.getOpposite(dart);
                Node oppositeFaceNode = (Node)MapSequence.fromMap(faceMap).get(embeddedGraph.getFace(dart2));
                edge = network.connect(faceNode, oppositeFaceNode);
                MapSequence.fromMap(dartBendMap).put(dart, edge);
                if (SetSequence.fromSet(straightEdges).contains(edge)) {
                    MapSequence.fromMap(capacity).put(edge, 0);
                } else {
                    MapSequence.fromMap(capacity).put(edge, INF);
                }
                MapSequence.fromMap(cost).put(edge, 1);
            }
        }
        IMapSequence faceToNodeEdges = MapSequence.fromMap(new HashMap());
        IMapSequence tempEdgesToDart = MapSequence.fromMap(new HashMap());
        for (Object node : ListSequence.fromList(graph.getNodes())) {
            Edge edge;
            if (ListSequence.fromList(((Node)node).getEdges()).count() <= 4) continue;
            List<Dart> darts = embeddedGraph.getDartWithSource((Node)node);
            IMapSequence faceNodes = MapSequence.fromMap(new HashMap());
            IMapSequence iMapSequence = MapSequence.fromMap(new HashMap());
            for (Dart dart : ListSequence.fromList(darts)) {
                Node faceNode = network.createNode();
                Face face = embeddedGraph.getFace(dart);
                MapSequence.fromMap(faceNodes).put(face, faceNode);
                edge = network.connect(faceNode, (INode)MapSequence.fromMap(nodeMap).get(node));
                MapSequence.fromMap(cost).put(edge, 0);
                MapSequence.fromMap(capacity).put(edge, 1);
                MapSequence.fromMap(iMapSequence).put(face, edge);
            }
            for (Dart dart : ListSequence.fromList(darts)) {
                Face face = embeddedGraph.getFace(dart);
                Face leftFace = embeddedGraph.getFace(embeddedGraph.getOpposite(dart));
                edge = network.connect((INode)MapSequence.fromMap(faceMap).get(leftFace), (INode)MapSequence.fromMap(faceNodes).get(face));
                MapSequence.fromMap(cost).put(edge, 1);
                MapSequence.fromMap(capacity).put(edge, 1);
                MapSequence.fromMap(tempEdgesToDart).put(edge, dart);
            }
            MapSequence.fromMap(faceToNodeEdges).put(node, iMapSequence);
        }
        Map<Edge, Integer> flow = MinCostMaxFlowWithPotentials.getFlow(network, networkSource, networkTarget, capacity, cost);
        for (Face face : ListSequence.fromList(embeddedGraph.getFaces())) {
            for (Dart dart : ListSequence.fromList(face.getDarts())) {
                Node source = dart.getSource();
                int angle = (Integer)MapSequence.fromMap(flow).get(MapSequence.fromMap(dartAngleMap).get(dart)) + 1;
                if (MapSequence.fromMap((Map)MapSequence.fromMap(faceToNodeEdges).get(source)).get(face) != null && (Integer)MapSequence.fromMap(flow).get(MapSequence.fromMap((Map)MapSequence.fromMap(faceToNodeEdges).get(source)).get(face)) > 0) {
                    --angle;
                }
                MapSequence.fromMap(angles).put(dart, angle);
            }
        }
        for (Dart dart : SetSequence.fromSet(MapSequence.fromMap(dartBendMap).keySet())) {
            MapSequence.fromMap(bends).put(dart, (Integer)MapSequence.fromMap(flow).get(MapSequence.fromMap(dartBendMap).get(dart)));
        }
        for (Face face : ListSequence.fromList(embeddedGraph.getFaces())) {
            List<Dart> darts = face.getDarts();
            for (Dart dart : ListSequence.fromList(darts)) {
                Node node = dart.getSource();
                Edge edgeToNode = (Edge)MapSequence.fromMap((Map)MapSequence.fromMap(faceToNodeEdges).get(node)).get(face);
                if (edgeToNode == null || (Integer)MapSequence.fromMap(flow).get(edgeToNode) <= 0) continue;
                Dart dartWithBend = embeddedGraph.getOpposite(dart);
                MapSequence.fromMap(bends).put(dartWithBend, (Integer)MapSequence.fromMap(bends).get(dartWithBend) + 1);
            }
        }
        if (SHOW_INFO > 0) {
            for (Object node : ListSequence.fromList(graph.getNodes())) {
                System.out.println("node " + String.valueOf(node));
                for (Dart dart : ListSequence.fromList(embeddedGraph.getDartWithSource((Node)node))) {
                    System.out.println(String.valueOf(dart) + " angle = " + String.valueOf(MapSequence.fromMap(angles).get(dart)) + ", bends = " + String.valueOf(MapSequence.fromMap(bends).get(dart)) + ", opposite bends = " + String.valueOf(MapSequence.fromMap(bends).get(embeddedGraph.getOpposite(dart))));
                }
            }
            int totalCost = 0;
            for (Edge edge : ListSequence.fromList(network.getEdges())) {
                totalCost += (Integer)MapSequence.fromMap(flow).get(edge) * (Integer)MapSequence.fromMap(cost).get(edge);
            }
            System.out.println("!!! total cost = " + totalCost);
            int totalBendsNumber = 0;
            for (Integer n : Sequence.fromIterable(MapSequence.fromMap(bends).values())) {
                totalBendsNumber += n.intValue();
            }
            System.out.println("!!! total bends number = " + totalBendsNumber);
            if (totalBendsNumber != totalCost) {
                throw new RuntimeException("total cost is not equal to bends number");
            }
        }
    }
}

