/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.flowOrthogonalLayout;

import com.vertabelo.autolayout_tool.repackaged.mps.baseLanguage.closures.runtime.Wrappers;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.GraphModificationEvent;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.Dart;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.EmbeddedGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.Face;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IMapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISetSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.SetSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.backports.LinkedList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class QuasiRepresentationModifier {
    private Graph myGraph;
    private EmbeddedGraph myEmbeddedGraph;
    private Map<Dart, Integer> myAngles;
    private Map<Dart, Integer> myBends;
    private List<Modification> myModifications;

    public QuasiRepresentationModifier(EmbeddedGraph embeddedGraph, Map<Dart, Integer> bends, Map<Dart, Integer> angles) {
        this.myGraph = embeddedGraph.getGraph();
        this.myEmbeddedGraph = embeddedGraph;
        this.myAngles = angles;
        this.myBends = bends;
        this.myModifications = ListSequence.fromList(new LinkedList());
    }

    public void reduceToOrthogonalRepresentation() {
        Graph graph = this.myEmbeddedGraph.getGraph();
        IMapSequence edgeTransform = MapSequence.fromMap(new HashMap());
        IListSequence initialNodes = ListSequence.fromList(new ArrayList());
        ListSequence.fromList(initialNodes).addSequence((ISequence)ListSequence.fromList(this.myGraph.getNodes()));
        for (Node node : ListSequence.fromList(initialNodes)) {
            List<Dart> darts = this.getOrderedDarts(node);
            Iterator dartItr = ListSequence.fromList(darts).iterator();
            ISetSequence removed = SetSequence.fromSet(new HashSet());
            while (dartItr.hasNext()) {
                Dart curDart = (Dart)dartItr.next();
                if ((Integer)MapSequence.fromMap(this.myAngles).get(curDart) != 0) continue;
                IListSequence sameDirectionDarts = ListSequence.fromList(new LinkedList());
                while ((Integer)MapSequence.fromMap(this.myAngles).get(curDart) == 0) {
                    ListSequence.fromList(sameDirectionDarts).addElement(curDart);
                    curDart = (Dart)dartItr.next();
                }
                IListSequence modifiedEdges = ListSequence.fromList(new LinkedList());
                for (Dart dart : ListSequence.fromList(sameDirectionDarts)) {
                    Edge edge = dart.getEdge();
                    if (MapSequence.fromMap(edgeTransform).containsKey(edge)) {
                        edge = (Edge)MapSequence.fromMap(edgeTransform).get(edge);
                    }
                    ListSequence.fromList(modifiedEdges).addElement(edge);
                }
                Edge edge = curDart.getEdge();
                if (MapSequence.fromMap(edgeTransform).containsKey(edge)) {
                    edge = (Edge)MapSequence.fromMap(edgeTransform).get(edge);
                }
                ListSequence.fromList(modifiedEdges).addElement(edge);
                Wrappers._T<Edge> curEdge = new Wrappers._T<Edge>(curDart.getEdge());
                int curNum = 0;
                IListSequence<Edge> newEdges = ListSequence.fromList(new LinkedList());
                for (Dart dart : ListSequence.fromList(sameDirectionDarts).reversedList()) {
                    SetSequence.fromSet(removed).addElement(curDart);
                    SetSequence.fromSet(removed).addElement(this.myEmbeddedGraph.getOpposite(curDart));
                    Dart backCurDart = this.myEmbeddedGraph.getOpposite(curDart);
                    IListSequence<Edge> edgesFromSplit = ListSequence.fromList(new ArrayList());
                    Node newNode = this.myEmbeddedGraph.splitEdge((Edge)curEdge.value, edgesFromSplit);
                    Edge nextEdge = ListSequence.fromList(edgesFromSplit).findFirst(it -> ListSequence.fromList(it.getAdjacentNodes()).contains(node));
                    Dart tempDart = this.myEmbeddedGraph.getSourceDart(nextEdge, node);
                    MapSequence.fromMap(this.myAngles).put(tempDart, (Integer)MapSequence.fromMap(this.myAngles).get(curDart));
                    MapSequence.fromMap(this.myBends).put(tempDart, 0);
                    tempDart = this.myEmbeddedGraph.getOpposite(tempDart);
                    MapSequence.fromMap(this.myAngles).put(tempDart, 1);
                    MapSequence.fromMap(this.myBends).put(tempDart, 0);
                    Edge anotherEdge = ListSequence.fromList(edgesFromSplit).findFirst(it -> ListSequence.fromList(it.getAdjacentNodes()).contains(((Edge)curEdge.value).getOpposite(node)));
                    if (dart == ListSequence.fromList(sameDirectionDarts).last()) {
                        MapSequence.fromMap(edgeTransform).put(anotherEdge, (Edge)curEdge.value);
                        ListSequence.fromList(newEdges).addElement(anotherEdge);
                    }
                    tempDart = this.myEmbeddedGraph.getSourceDart(anotherEdge, newNode);
                    MapSequence.fromMap(this.myAngles).put(tempDart, 2);
                    MapSequence.fromMap(this.myBends).put(tempDart, (Integer)MapSequence.fromMap(this.myBends).get(curDart));
                    tempDart = this.myEmbeddedGraph.getOpposite(tempDart);
                    MapSequence.fromMap(this.myAngles).put(tempDart, (Integer)MapSequence.fromMap(this.myAngles).get(backCurDart));
                    MapSequence.fromMap(this.myBends).put(tempDart, (Integer)MapSequence.fromMap(this.myBends).get(backCurDart));
                    Face face = this.myEmbeddedGraph.getFace(dart);
                    Dart oppositeDart = this.myEmbeddedGraph.getOpposite(dart);
                    Face anotherFace = this.myEmbeddedGraph.getFace(oppositeDart);
                    Edge oldEdge = dart.getEdge();
                    Dart frontOldDart = this.myEmbeddedGraph.getSourceDart(oldEdge, node);
                    Dart backOldDart = this.myEmbeddedGraph.getOpposite(frontOldDart);
                    SetSequence.fromSet(removed).addElement(frontOldDart);
                    SetSequence.fromSet(removed).addElement(backOldDart);
                    face.makeStartsWith(dart);
                    graph.removeEdge(oldEdge);
                    Edge newEdge = graph.connect(newNode, oldEdge.getOpposite(node));
                    ListSequence.fromList(newEdges).addElement(newEdge);
                    MapSequence.fromMap(edgeTransform).put(newEdge, oldEdge);
                    Dart lastFaceDart = (Dart)ListSequence.fromList(face.getDarts()).last();
                    this.myEmbeddedGraph.removeDart(face, lastFaceDart);
                    Dart frontNewDart = new Dart(newEdge, newNode);
                    this.myEmbeddedGraph.setDart(face, 0, frontNewDart);
                    MapSequence.fromMap(this.myAngles).put(frontNewDart, 1);
                    MapSequence.fromMap(this.myBends).put(frontNewDart, (Integer)MapSequence.fromMap(this.myBends).get(frontOldDart));
                    anotherFace.makeEndsWith(oppositeDart);
                    Dart backNewDart = new Dart(newEdge, oldEdge.getOpposite(node));
                    this.myEmbeddedGraph.setDart(anotherFace, ListSequence.fromList(anotherFace.getDarts()).count() - 1, backNewDart);
                    this.myEmbeddedGraph.insertDart(anotherFace, ListSequence.fromList(anotherFace.getDarts()).count(), lastFaceDart);
                    MapSequence.fromMap(this.myAngles).put(backNewDart, (Integer)MapSequence.fromMap(this.myAngles).get(backOldDart));
                    MapSequence.fromMap(this.myBends).put(backNewDart, (Integer)MapSequence.fromMap(this.myBends).get(backOldDart) - 1);
                    IListSequence<Edge> historyEdgesList = ListSequence.fromListAndArray(new ArrayList(), nextEdge, newEdge);
                    GraphModificationEvent splitEvent = new GraphModificationEvent(GraphModificationEvent.Type.EDGE_SPLITTED, oldEdge, historyEdgesList);
                    this.myGraph.getModificationProcessor().fire(splitEvent);
                    curEdge.value = nextEdge;
                    curDart = this.myEmbeddedGraph.getSourceDart((Edge)curEdge.value, node);
                    ++curNum;
                }
                ListSequence.fromList(this.myModifications).addElement(new Modification(this, ListSequence.fromList(modifiedEdges).reversedList(), newEdges, node, curDart));
            }
            for (Dart dart : SetSequence.fromSet(removed)) {
                MapSequence.fromMap(this.myAngles).removeKey(dart);
                MapSequence.fromMap(this.myBends).removeKey(dart);
            }
        }
    }

    private List<Dart> getOrderedDarts(Node node) {
        List<Dart> darts = this.myEmbeddedGraph.getOrderedDarts(node);
        boolean hasZeroAngles = false;
        for (Dart dart : ListSequence.fromList(darts)) {
            if ((Integer)MapSequence.fromMap(this.myAngles).get(dart) != 0) continue;
            hasZeroAngles = true;
        }
        if (hasZeroAngles) {
            while ((Integer)MapSequence.fromMap(this.myAngles).get(ListSequence.fromList(darts).first()) != 0) {
                ListSequence.fromList(darts).addElement(ListSequence.fromList(darts).removeElementAt(0));
            }
            while ((Integer)MapSequence.fromMap(this.myAngles).get(ListSequence.fromList(darts).last()) == 0) {
                ListSequence.fromList(darts).insertElement(0, ListSequence.fromList(darts).removeLastElement());
            }
        }
        return darts;
    }

    public List<Modification> getModifications() {
        return this.myModifications;
    }

    public class Modification {
        private List<Edge> myModifiedEdges;
        private List<Edge> myNewEdges;
        private Node mySource;
        private Dart mySourceDart;

        public Modification(QuasiRepresentationModifier this$0, List<Edge> modifiedEdges, List<Edge> newEdges, Node source, Dart sourceDart) {
            this.myModifiedEdges = modifiedEdges;
            this.myNewEdges = newEdges;
            this.mySource = source;
            this.mySourceDart = sourceDart;
        }

        public List<Edge> getModifiedEdges() {
            return this.myModifiedEdges;
        }

        public List<Edge> getNewEdges() {
            return this.myNewEdges;
        }

        public Node getSource() {
            return this.mySource;
        }

        public Dart getSourceDart() {
            return this.mySourceDart;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("modification:\n");
            builder.append("  modified edges: " + String.valueOf(this.myModifiedEdges));
            builder.append("  new edges: " + String.valueOf(this.myNewEdges));
            builder.append("  source: " + String.valueOf(this.mySource));
            builder.append("  dart: " + String.valueOf(this.mySourceDart));
            return builder.toString();
        }
    }
}

