/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.ClusteredGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.GraphCopier;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.INode;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Tree;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.ClusteredGraphLayout;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.GraphLayout;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Point;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.util.Filter;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.SetSequence;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClusterGraphCopier
extends GraphCopier {
    private Map<Node, Node> myClusterMap;
    private ClusteredGraph myClusteredGraph;
    private Set<Node> myGoodClusters;

    public ClusterGraphCopier(ClusteredGraph graph) {
        super(graph);
        this.myClusteredGraph = graph;
        this.myClusterMap = MapSequence.fromMap(new HashMap());
        this.myGoodClusters = SetSequence.fromSet(new HashSet());
    }

    @Override
    public Graph copySubgraph(Filter<INode> nodeFilter) {
        super.copySubgraph(nodeFilter);
        Tree tree = this.myClusteredGraph.getInclusionTree();
        Iterable clusters = tree.getNodes();
        for (Node leafCluster : ListSequence.fromList(clusters).where(it -> ListSequence.fromList(it.getOutEdges()).count() == 0)) {
            Node node = this.getLeafNode(leafCluster);
            if (!nodeFilter.accept(node)) continue;
            this.findGoodClusters(leafCluster);
        }
        Tree copyTree = this.getCopy().getInclusionTree();
        Node copyRoot = copyTree.createNode();
        this.getCopy().setRoot(copyRoot);
        this.copyCluster(this.myClusteredGraph.getRoot(), copyRoot);
        return this.getCopy();
    }

    private Node getLeafNode(Node leafCluster) {
        return (Node)SetSequence.fromSet(this.myClusteredGraph.getNodesInCluster(leafCluster)).first();
    }

    private void findGoodClusters(Node cluster) {
        Node curCluster = cluster;
        while (curCluster != this.myClusteredGraph.getRoot() && !SetSequence.fromSet(this.myGoodClusters).contains(curCluster)) {
            SetSequence.fromSet(this.myGoodClusters).addElement(curCluster);
            curCluster = this.myClusteredGraph.getInclusionTree().getParent(curCluster);
        }
        SetSequence.fromSet(this.myGoodClusters).addElement(curCluster);
    }

    private void copyCluster(Node cluster, Node copy) {
        MapSequence.fromMap(this.myClusterMap).put(cluster, copy);
        List<Node> children = this.myClusteredGraph.getInclusionTree().getChildren(cluster);
        if (ListSequence.fromList(children).count() == 0) {
            this.getCopy().setNodeInCluster(copy, this.getNodeCopy(this.getLeafNode(cluster)));
        } else {
            for (Node child : ListSequence.fromList(children).where(it -> SetSequence.fromSet(this.myGoodClusters).contains(it))) {
                Tree tree = this.getCopy().getInclusionTree();
                Node copyChild = tree.createNode();
                tree.connect(copy, copyChild);
                this.copyCluster(child, copyChild);
            }
        }
    }

    @Override
    public ClusteredGraphLayout restoreLayout(GraphLayout copyLayout) {
        ClusteredGraphLayout graphLayout = (ClusteredGraphLayout)super.restoreLayout(copyLayout);
        if (copyLayout instanceof ClusteredGraphLayout) {
            ClusteredGraphLayout clusteredCopyLayout = (ClusteredGraphLayout)copyLayout;
            for (Node cluster : ListSequence.fromList(this.myClusteredGraph.getClusters())) {
                List<Point> route = clusteredCopyLayout.getClusterLayout(this.getCluserCopy(cluster));
                if (route == null) continue;
                graphLayout.setClusterLayout(cluster, route);
            }
        }
        return graphLayout;
    }

    public Node getCluserCopy(Node cluster) {
        return (Node)MapSequence.fromMap(this.myClusterMap).get(cluster);
    }

    public Set<Node> getCopiedClusters() {
        return MapSequence.fromMap(this.myClusterMap).keySet();
    }

    @Override
    public ClusteredGraph getCopy() {
        return (ClusteredGraph)super.getCopy();
    }
}

